/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix");
    private final SmartPsiElementPointer myMethodCall;

    public CreateMethodFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(0);
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCall.getProject()).createSmartPsiElementPointer((PsiElement)methodCall);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null || !call.isValid()) {
            return false;
        }
        PsiReferenceExpression ref = call.getMethodExpression();
        String name2 = ref.getReferenceName();
        if (name2 == null || !PsiNameHelper.getInstance((Project)ref.getProject()).isIdentifier(name2)) {
            return false;
        }
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(call)) {
            return false;
        }
        this.setText(this.getDisplayString(name2));
        return true;
    }

    protected String getDisplayString(String name2) {
        return QuickFixBundle.message("create.method.from.usage.text", name2);
    }

    public static boolean isMethodSignatureExists(PsiMethodCallExpression call, PsiClass target) {
        PsiMethod[] methods;
        String name2 = call.getMethodExpression().getReferenceName();
        JavaResolveResult resolveResult = call.getMethodExpression().advancedResolve(false);
        PsiExpressionList list = call.getArgumentList();
        for (PsiMethod method : methods = target.findMethodsByName(name2, false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)resolveResult.getSubstitutor(), (PsiExpressionList)list)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasErrorsInArgumentList(PsiMethodCallExpression call) {
        Project project = call.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(call.getContainingFile());
        if (document == null) {
            return true;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        TextRange argRange = argumentList.getTextRange();
        return !DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.ERROR, (int)(argRange.getStartOffset() + 1), (int)(argRange.getEndOffset() - 1), info -> info.getActualStartOffset() <= argRange.getStartOffset() || info.getActualEndOffset() >= argRange.getEndOffset());
    }

    @Override
    protected PsiElement getElement() {
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null || !CreateMethodFromUsageFix.canModify((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> targets = super.getTargetClasses(element);
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiMethodCallExpression call = this.getMethodCall();
        if (call == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CreateMethodFromUsageFix.$$$reportNull$$$0(1);
            }
            return list;
        }
        for (PsiClass target : targets) {
            if (CreateMethodFromUsageFix.shouldCreateStaticMember(call.getMethodExpression(), target) && (target.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)target) || target.getContainingClass() != null && !target.hasModifierProperty("static")) || CreateMethodFromUsageFix.isMethodSignatureExists(call, target)) continue;
            result.add(target);
        }
        ArrayList<PsiClass> arrayList = result;
        if (arrayList == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (targetClass == null) {
            return;
        }
        PsiMethodCallExpression expression2 = this.getMethodCall();
        if (expression2 == null) {
            return;
        }
        PsiReferenceExpression ref = expression2.getMethodExpression();
        if (this.isValidElement((PsiElement)expression2)) {
            return;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        PsiMember enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class});
        String methodName = ref.getReferenceName();
        LOG.assertTrue(methodName != null);
        PsiMethod method = CreateMethodFromUsageFix.createMethod(targetClass, parentClass, enclosingContext, methodName);
        if (method == null) {
            return;
        }
        if (enclosingContext instanceof PsiMethod && methodName.equals(enclosingContext.getName()) && PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)parentClass, (boolean)true) && !ref.isQualified()) {
            RefactoringChangeUtil.qualifyReference(ref, (PsiMember)method, null);
        }
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        boolean shouldBeAbstract = this.shouldBeAbstract(expression2.getMethodExpression(), targetClass);
        if (shouldBeAbstract) {
            body2.delete();
            if (!targetClass.isInterface()) {
                method.getModifierList().setModifierProperty("abstract", true);
            }
        }
        this.setupVisibility(parentClass, targetClass, method.getModifierList());
        expression2 = this.getMethodCall();
        LOG.assertTrue(expression2.isValid());
        if ((!targetClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) && CreateMethodFromUsageFix.shouldCreateStaticMember(expression2.getMethodExpression(), targetClass) && !shouldBeAbstract) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        Object[] arguments = expression2.getArgumentList().getExpressions();
        CreateMethodFromUsageFix.doCreate(targetClass, method, shouldBeAbstract, ContainerUtil.map2List((Object[])arguments, (Function)Pair.createFunction(null)), CreateMethodFromUsageFix.getTargetSubstitutor((PsiElement)expression2), CreateFromUsageUtils.guessExpectedTypes((PsiExpression)expression2, expression2.getParent() instanceof PsiStatement), context);
    }

    public static PsiMethod createMethod(PsiClass targetClass, PsiClass parentClass, PsiMember enclosingContext, String methodName) {
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        if (factory == null) {
            return null;
        }
        PsiMethod method = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        if (targetClass.equals(parentClass)) {
            method = (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)enclosingContext);
        } else {
            PsiMember anchor;
            for (anchor = enclosingContext; anchor != null && anchor.getParent() != null && !anchor.getParent().equals(targetClass); anchor = anchor.getParent()) {
            }
            if (anchor != null && anchor.getParent() == null) {
                anchor = null;
            }
            method = anchor != null ? (PsiMethod)targetClass.addAfter((PsiElement)method, (PsiElement)anchor) : (PsiMethod)targetClass.add((PsiElement)method);
        }
        return method;
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method, List<? extends Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        CreateMethodFromUsageFix.doCreate(targetClass, method, CreateMethodFromUsageFix.shouldBeAbstractImpl(null, targetClass), arguments, substitutor, expectedTypes, context);
    }

    public static void doCreate(PsiClass targetClass, PsiMethod method, boolean shouldBeAbstract, List<? extends Pair<PsiExpression, PsiType>> arguments, PsiSubstitutor substitutor, ExpectedTypeInfo[] expectedTypes, @Nullable PsiElement context) {
        if ((method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method)) == null) {
            return;
        }
        final Project project = targetClass.getProject();
        final PsiFile targetFile = targetClass.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(targetFile);
        if (document == null) {
            return;
        }
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)method);
        CreateFromUsageUtils.setupMethodParameters(method, (TemplateBuilder)builder, context, substitutor, arguments);
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement != null) {
            new GuessTypeParameters(project, (JVMElementFactory)JavaPsiFacade.getElementFactory((Project)project), (TemplateBuilder)builder, substitutor).setupTypeElement(returnTypeElement, expectedTypes, context, targetClass);
        }
        PsiCodeBlock body2 = method.getBody();
        builder.setEndVariableAfter((PsiElement)(shouldBeAbstract || body2 == null ? method : body2.getLBrace()));
        method = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
        if (method == null) {
            return;
        }
        RangeMarker rangeMarker = document.createRangeMarker(method.getTextRange());
        final Editor newEditor = CreateMethodFromUsageFix.positionCursor(project, targetFile, (PsiElement)method);
        if (newEditor == null) {
            return;
        }
        Template template = builder.buildTemplate();
        newEditor.getCaretModel().moveToOffset(rangeMarker.getStartOffset());
        newEditor.getDocument().deleteString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        rangeMarker.dispose();
        if (!shouldBeAbstract) {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(newEditor.getDocument());
                        int offset = newEditor.getCaretModel().getOffset();
                        PsiMethod method1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)targetFile, (int)(offset - 1), PsiMethod.class, (boolean)false);
                        if (method1 != null) {
                            try {
                                CreateFromUsageUtils.setupMethodBody(method1);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                            CreateFromUsageUtils.setupEditor(method1, newEditor);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix$1", "templateFinished"));
                }
            });
        } else {
            CreateMethodFromUsageFix.startTemplate(newEditor, template, project);
        }
    }

    public static boolean checkTypeParam(final PsiMethod method, PsiTypeParameter typeParameter) {
        final String typeParameterName = typeParameter.getName();
        PsiTypeVisitor<Boolean> visitor = new PsiTypeVisitor<Boolean>(){

            public Boolean visitClassType(PsiClassType classType) {
                PsiClass psiClass = classType.resolve();
                if (psiClass instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)((PsiTypeParameter)psiClass).getOwner(), (PsiElement)method, (boolean)true)) {
                    return false;
                }
                if (Comparing.strEqual((String)typeParameterName, (String)classType.getCanonicalText())) {
                    return true;
                }
                for (PsiType p : classType.getParameters()) {
                    if (!((Boolean)p.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return false;
            }

            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound != null) {
                    return (Boolean)bound.accept((PsiTypeVisitor)this);
                }
                return false;
            }
        };
        PsiTypeElement rElement = method.getReturnTypeElement();
        if (rElement != null && ((Boolean)rElement.getType().accept((PsiTypeVisitor)visitor)).booleanValue()) {
            return true;
        }
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            PsiTypeElement element = parameter2.getTypeElement();
            if (element == null || !((Boolean)element.getType().accept((PsiTypeVisitor)visitor)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldBeAbstract(PsiReferenceExpression expression2, PsiClass targetClass) {
        return CreateMethodFromUsageFix.shouldBeAbstractImpl(expression2, targetClass);
    }

    private static boolean shouldBeAbstractImpl(PsiReferenceExpression expression2, PsiClass targetClass) {
        return targetClass.isInterface() && (expression2 == null || !CreateMethodFromUsageFix.shouldCreateStaticMember(expression2, targetClass));
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression referenceExpression = callExpression.getMethodExpression();
        return CreateFromUsageUtils.isValidMethodReference((PsiReference)referenceExpression, callExpression);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected PsiMethodCallExpression getMethodCall() {
        return (PsiMethodCallExpression)this.myMethodCall.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromUsageFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

