/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodFix
extends StaticImportMemberFix<PsiMethod> {
    protected final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            StaticImportMethodFix.$$$reportNull$$$0(0);
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        String string = QuickFixBundle.message("static.import.method.text", new Object[0]);
        if (string == null) {
            StaticImportMethodFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiMethod method) {
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0);
        if (string == null) {
            StaticImportMethodFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<PsiMethod> getMembersToImport(boolean applicableOnly, @NotNull StaticMembersProcessor.SearchMode searchMode) {
        String name2;
        if (searchMode == null) {
            StaticImportMethodFix.$$$reportNull$$$0(3);
        }
        Project project = this.myMethodCall.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element == null ? null : element.getMethodExpression();
        String string = name2 = reference == null ? null : reference.getReferenceName();
        if (name2 == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                StaticImportMethodFix.$$$reportNull$$$0(4);
            }
            return list;
        }
        MyStaticMethodProcessor processor = new MyStaticMethodProcessor(element, this.toAddStaticImports(), searchMode);
        cache.processMethodsWithName(name2, element.getResolveScope(), (Processor)processor);
        List<PsiMethod> list = processor.getMembersToImport(applicableOnly);
        if (list == null) {
            StaticImportMethodFix.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    protected boolean toAddStaticImports() {
        return true;
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(List<? extends PsiMethod> methodsToImport, @NotNull Project project, Editor editor) {
        if (project == null) {
            StaticImportMethodFix.$$$reportNull$$$0(6);
        }
        StaticImportMethodQuestionAction<PsiMethod> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiMethod>(project, editor, methodsToImport, this.myMethodCall);
        if (staticImportMethodQuestionAction == null) {
            StaticImportMethodFix.$$$reportNull$$$0(7);
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myMethodCall.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        return element != null ? element.getMethodExpression().getQualifierExpression() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.getElement();
        return methodCallExpression != null ? methodCallExpression.resolveMethod() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchMode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberPresentableText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersToImport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuestionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMembersToImport";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createQuestionAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyStaticMethodProcessor
    extends StaticMembersProcessor<PsiMethod> {
        private MyStaticMethodProcessor(@NotNull PsiMethodCallExpression place, boolean showMembersFromDefaultPackage, @NotNull StaticMembersProcessor.SearchMode mode) {
            if (place == null) {
                MyStaticMethodProcessor.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                MyStaticMethodProcessor.$$$reportNull$$$0(1);
            }
            super((PsiElement)place, showMembersFromDefaultPackage, mode);
        }

        @Override
        protected boolean isApplicable(PsiMethod method, PsiElement place) {
            PsiExpressionList argumentList = ((PsiMethodCallExpression)place).getArgumentList();
            MethodCandidateInfo candidateInfo = new MethodCandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null);
            PsiSubstitutor substitutorForMethod = candidateInfo.getSubstitutor();
            if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutorForMethod, (PsiExpressionList)argumentList)) {
                PsiType returnType = substitutorForMethod.substitute(method.getReturnType());
                if (returnType == null) {
                    return true;
                }
                return this.isApplicableFor(returnType);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mode";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix$MyStaticMethodProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

