/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingIfBranchesFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
        Document doc = editor.getDocument();
        PsiKeyword elseElement = ifStatement.getElseElement();
        if (elseElement != null) {
            MissingIfBranchesFixer.handleBranch(doc, ifStatement, (PsiElement)elseElement, ifStatement.getElseBranch());
        }
        PsiJavaToken rParenth = ifStatement.getRParenth();
        assert (rParenth != null);
        MissingIfBranchesFixer.handleBranch(doc, ifStatement, (PsiElement)rParenth, ifStatement.getThenBranch());
    }

    private static void handleBranch(@NotNull Document doc, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement beforeBranch, @Nullable PsiStatement branch) {
        boolean transformingOneLiner;
        if (doc == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(0);
        }
        if (ifStatement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(1);
        }
        if (beforeBranch == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(2);
        }
        if (branch instanceof PsiBlockStatement || beforeBranch.textMatches((CharSequence)"else") && branch instanceof PsiIfStatement) {
            return;
        }
        boolean bl = transformingOneLiner = branch != null && (MissingIfBranchesFixer.startLine(doc, beforeBranch) == MissingIfBranchesFixer.startLine(doc, (PsiElement)branch) || MissingIfBranchesFixer.startCol(doc, (PsiElement)ifStatement) < MissingIfBranchesFixer.startCol(doc, (PsiElement)branch));
        if (!transformingOneLiner) {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{");
            doc.insertString(branch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(3);
        }
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static int startCol(Document doc, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(4);
        }
        int offset = psiElement.getTextRange().getStartOffset();
        return offset - doc.getLineStartOffset(doc.getLineNumber(offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeBranch";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingIfBranchesFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startCol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

