/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LiteralSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(0);
        }
        PsiElement parent = e.getParent();
        return LiteralSelectioner.isStringLiteral(e) || LiteralSelectioner.isStringLiteral(parent);
    }

    private static boolean isStringLiteral(PsiElement element) {
        PsiType type2 = element instanceof PsiLiteralExpression ? ((PsiLiteralExpression)element).getType() : null;
        return type2 != null && type2.equalsToText("java.lang.String") && element.getText().startsWith("\"") && element.getText().endsWith("\"");
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            LiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LiteralSelectioner.$$$reportNull$$$0(3);
        }
        List result = super.select(e, editorText, cursorOffset, editor);
        TextRange range = e.getTextRange();
        SelectWordUtil.addWordHonoringEscapeSequences((CharSequence)editorText, (TextRange)range, (int)cursorOffset, (Lexer)new StringLiteralLexer('\"', JavaTokenType.STRING_LITERAL), (List)result);
        result.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/LiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

