/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");

    private static String getCodeBlockPlaceholder(PsiElement codeBlock) {
        return codeBlock instanceof PsiCodeBlock && ((PsiCodeBlock)codeBlock).isEmpty() ? "{}" : "{...}";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        if (e1 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (e2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method) {
        PsiExpression expr;
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)method.getProject())) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || body2.getLBrace() == null || body2.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtilBase.isSimplePropertySetter((PsiMethod)method);
        }
        return false;
    }

    @Nullable
    private static TextRange importListRange(@NotNull PsiImportList list) {
        PsiImportStatementBase[] statements;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if ((statements = list.getAllImportStatements()).length == 0) {
            return null;
        }
        PsiElement importKeyword = statements[0].getFirstChild();
        if (importKeyword == null) {
            return null;
        }
        int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
        int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
        return JavaFoldingBuilderBase.hasErrorElementsNearby(list.getContainingFile(), startOffset, endOffset) ? null : new TextRange(startOffset, endOffset);
    }

    @Nullable
    private static TextRange lambdaRange(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body2;
        if (lambdaExpression == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        return (body2 = lambdaExpression.getBody()) instanceof PsiCodeBlock ? body2.getTextRange() : null;
    }

    @Nullable
    private static TextRange methodRange(@NotNull PsiMethod element) {
        PsiCodeBlock body2;
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        return (body2 = element.getBody()) == null ? null : body2.getTextRange();
    }

    @Nullable
    private static TextRange classRange(@NotNull PsiClass aClass) {
        PsiElement lBrace;
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        if ((lBrace = aClass.getLBrace()) == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (rBrace == null) {
            return null;
        }
        return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
    }

    @Nullable
    private static TextRange moduleRange(@NotNull PsiJavaModule element) {
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        PsiElement left = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.LBRACE));
        PsiElement right = (PsiElement)SyntaxTraverser.psiTraverser().children((Object)element).find(e -> PsiUtil.isJavaToken((PsiElement)e, (IElementType)JavaTokenType.RBRACE));
        return left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset() + 1) : null;
    }

    @NotNull
    private static TextRange annotationRange(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        PsiAnnotation element = annotation;
        int startOffset = element.getTextRange().getStartOffset();
        PsiAnnotation last = element;
        while (element instanceof PsiAnnotation) {
            last = element;
            element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        }
        TextRange textRange = new TextRange(startOffset, last.getTextRange().getEndOffset());
        if (textRange == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        endOffset = CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)endOffset, (String)" \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffset, (int)endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange fileHeaderRange(@NotNull PsiJavaFile file) {
        PsiElement first;
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        if ((first = file.getFirstChild()) instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element = prevSibling;
        }
        if (element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(@NotNull List<? super FoldingDescriptor> list, @Nullable PsiModifierList modifierList, @NotNull Document document) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(13);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        if (modifierList == null) {
            return;
        }
        PsiElement[] children = modifierList.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PsiElement nextChild;
            int j;
            PsiElement child = children[i];
            if (!(child instanceof PsiAnnotation)) continue;
            PsiAnnotation annotation = (PsiAnnotation)child;
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)annotation, document, false, "@{...}", JavaFoldingBuilderBase.annotationRange(annotation), JavaCodeFoldingSettings.getInstance().isCollapseAnnotations());
            for (j = i + 1; j < children.length && !((nextChild = children[j]) instanceof PsiModifier); ++j) {
            }
            i = j;
        }
    }

    private static void addFoldsForComment(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiComment comment, @NotNull Set<? super PsiElement> processedComments) {
        ASTNode node;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        if (comment == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT || JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)comment)) {
            return;
        }
        processedComments.add((PsiElement)comment);
        PsiElement end = null;
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT && !JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add((PsiElement)current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null) {
            list.add((FoldingDescriptor)new NamedFoldingDescriptor(comment.getNode(), new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset()), null, "//...", Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseEndOfLineComments()), Collections.emptySet()));
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethodCallExpression expression2, @NotNull Document document, boolean quick) {
        PsiReferenceExpression methodExpression;
        PsiReferenceParameterList parameterList;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(19);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        if ((parameterList = (methodExpression = expression2.getMethodExpression()).getParameterList()) == null || parameterList.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression2;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(list, document, parameterList, 3, quick);
    }

    private static void addLocalVariableTypeFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiVariable expression2, boolean quick) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        if (quick) {
            return;
        }
        PsiTypeElement typeElement = expression2.getTypeElement();
        if (typeElement == null) {
            return;
        }
        if (!typeElement.isInferredType()) {
            return;
        }
        String presentableText = expression2.getType().getPresentableText();
        list.add((FoldingDescriptor)new NamedFoldingDescriptor(typeElement.getNode(), typeElement.getTextRange(), null, presentableText, Boolean.valueOf(true), Collections.emptySet()));
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(23);
        }
        for (JavaResolveResult result : expression2.multiResolve(true)) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiNewExpression expression2, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList parameterList;
        PsiAnonymousClass anonymousClass;
        PsiElement parent;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(24);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(25);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(26);
        }
        if (!((parent = expression2.getParent()) instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters2 = ((PsiClassType)declType).getParameters();
        if (parameters2.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        if (classReference2 == null && (anonymousClass = expression2.getAnonymousClass()) != null) {
            classReference2 = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), (PsiElement)anonymousClass)) {
                return;
            }
        }
        if (classReference2 != null && (parameterList = classReference2.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !parameterList.getText().equals(declList.getText()) : !Arrays.equals(parameterList.getTypeArguments(), parameters2)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(list, document, parameterList, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull Document document, @NotNull PsiReferenceParameterList parameterList, int ifLongerThan, boolean quick) {
        String text2;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(27);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(28);
        }
        if (parameterList == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(29);
        }
        if (!quick) {
            for (PsiType type2 : parameterList.getTypeArguments()) {
                if (!type2.isValid()) {
                    return;
                }
                if (!(type2 instanceof PsiClassType) && !(type2 instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type2) != null) continue;
                return;
            }
        }
        if ((text2 = parameterList.getText()).startsWith("<") && text2.endsWith(">") && text2.length() > ifLongerThan) {
            TextRange range = parameterList.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(list, (PsiElement)parameterList, document, true, range, "<~>", JavaCodeFoldingSettings.getInstance().isCollapseConstructorGenericParameters());
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static void addToFold(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull String placeholder, @Nullable TextRange range, boolean isCollapsedByDefault) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(30);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(31);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(32);
        }
        if (placeholder == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(33);
        }
        if (range != null) {
            PsiUtilCore.ensureValid((PsiElement)elementToFold);
            JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range, placeholder, isCollapsedByDefault);
        }
    }

    private static void addFoldRegion(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range, @NotNull String placeholder, boolean isCollapsedByDefault) {
        int endLine;
        int startLine;
        TextRange fileRange;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(34);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(35);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(36);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(37);
        }
        if (placeholder == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(38);
        }
        if (range.equals((Object)(fileRange = elementToFold.getContainingFile().getTextRange()))) {
            return;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return;
        }
        if (!allowOneLiners ? (startLine = document.getLineNumber(range.getStartOffset())) >= (endLine = document.getLineNumber(range.getEndOffset() - 1)) || range.getLength() <= 1 : range.getLength() <= placeholder.length()) {
            return;
        }
        list.add((FoldingDescriptor)new NamedFoldingDescriptor(elementToFold.getNode(), range, null, placeholder, Boolean.valueOf(isCollapsedByDefault), Collections.emptySet()));
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        PsiClass[] classes2;
        if (descriptors == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(39);
        }
        if (root == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(40);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(41);
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)root;
        JavaFoldingBuilderBase.addFoldsForImports(descriptors, file);
        PsiJavaModule module = file.getModuleDeclaration();
        if (module != null) {
            JavaFoldingBuilderBase.addFoldsForModule(descriptors, module, document);
        }
        for (PsiClass aClass : classes2 = file.getClasses()) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addFoldsForClass(descriptors, aClass, document, true, quick);
        }
        JavaFoldingBuilderBase.addFoldsForFileHeader(descriptors, file, document);
    }

    private static void addFoldsForImports(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaFile file) {
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        PsiImportList importList;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(42);
        }
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(43);
        }
        if ((importList = file.getImportList()) != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.importListRange(importList)) != null && rangeToFold.getLength() > 1) {
            NamedFoldingDescriptor descriptor2 = new NamedFoldingDescriptor(importList.getNode(), rangeToFold, null, "...", Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseImports()), Collections.emptySet());
            descriptor2.setCanBeRemovedWhenCollapsed(true);
            list.add((FoldingDescriptor)descriptor2);
        }
    }

    private static void addFoldsForFileHeader(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaFile file, @NotNull Document document) {
        TextRange range;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(44);
        }
        if (file == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(45);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(46);
        }
        if ((range = JavaFoldingBuilderBase.fileHeaderRange(file)) != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiJavaFile anchorElementToUse = file;
            PsiElement candidate = file.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals((Object)range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            list.add((FoldingDescriptor)new NamedFoldingDescriptor(anchorElementToUse.getNode(), range, null, "/.../", Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseFileHeader()), Collections.emptySet()));
        }
    }

    private static void addFoldsForModule(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaModule module, @NotNull Document document) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(47);
        }
        if (module == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(48);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(49);
        }
        JavaFoldingBuilderBase.addToFold(list, (PsiElement)module, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.moduleRange(module), false);
        JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)module);
        JavaFoldingBuilderBase.addAnnotationsToFold(list, module.getModifierList(), document);
    }

    private void addFoldsForClass(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiClass aClass, @NotNull Document document, boolean foldJavaDocs, boolean quick) {
        PsiElement parent;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(50);
        }
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(51);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(52);
        }
        if (!((parent = aClass.getParent()) instanceof PsiJavaFile) || ((PsiJavaFile)parent).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)aClass, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.classRange(aClass), !(parent instanceof PsiFile) && JavaCodeFoldingSettings.getInstance().isCollapseInnerClasses());
        }
        if (foldJavaDocs) {
            JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)aClass);
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(list, aClass.getModifierList(), document);
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child = aClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)child;
                this.addFoldsForMethod(list, method, document, foldJavaDocs, quick, processedComments);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs) {
                    JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)field);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(list, field.getModifierList(), document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds(list, (PsiElement)initializer, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds(list, (PsiElement)field, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)child;
                JavaFoldingBuilderBase.addToFold(list, child, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)initializer.getBody()), initializer.getBody().getTextRange(), JavaCodeFoldingSettings.getInstance().isCollapseMethods());
                this.addCodeBlockFolds(list, child, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addFoldsForClass(list, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addFoldsForComment(list, (PsiComment)child, processedComments);
        }
    }

    private void addFoldsForMethod(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethod method, @NotNull Document document, boolean foldJavaDocs, boolean quick, @NotNull Set<PsiElement> processedComments) {
        boolean oneLiner;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(53);
        }
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(54);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(55);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(56);
        }
        if (!(oneLiner = this.addOneLineMethodFolding(list, method))) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)method, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)method.getBody()), JavaFoldingBuilderBase.methodRange(method), JavaFoldingBuilderBase.isCollapseMethodByDefault(method));
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(list, method.getModifierList(), document);
        if (foldJavaDocs) {
            JavaFoldingBuilderBase.addDocCommentToFold(list, document, (PsiJavaDocumentedElement)method);
        }
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            JavaFoldingBuilderBase.addAnnotationsToFold(list, parameter2.getModifierList(), document);
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            this.addCodeBlockFolds(list, (PsiElement)body2, processedComments, document, quick);
        }
    }

    private static void addDocCommentToFold(@NotNull List<? super FoldingDescriptor> list, @NotNull Document document, @NotNull PsiJavaDocumentedElement element) {
        PsiDocComment docComment;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(57);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(58);
        }
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(59);
        }
        if ((docComment = element.getDocComment()) != null) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)docComment, document, true, "/**...*/", docComment.getTextRange(), JavaFoldingBuilderBase.isCollapseDocCommentByDefault(docComment));
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethod method) {
        boolean collapseOneLineMethods;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(60);
        }
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(61);
        }
        if (!(collapseOneLineMethods = JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods())) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body2 = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body2 == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body2.getLBrace();
        PsiJavaToken rBrace = body2.getRBrace();
        PsiStatement[] statements = body2.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)lBrace, (PsiElement)statement, document) || !JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)statement, (PsiElement)rBrace, document)) {
            return false;
        }
        int leftStart = method.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body2.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement.getTextRange().getStartOffset();
        int rightStart = statement.getTextRange().getEndOffset();
        int rightEnd = body2.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin((PsiElement)method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        list.add((FoldingDescriptor)new NamedFoldingDescriptor(lBrace.getNode(), new TextRange(leftStart, leftEnd), group, leftText, Boolean.valueOf(true), Collections.emptySet()));
        list.add((FoldingDescriptor)new NamedFoldingDescriptor(rBrace.getNode(), new TextRange(rightStart, rightEnd), group, rightText, Boolean.valueOf(true), Collections.emptySet()));
        return true;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(62);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(63);
        }
        return null;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(64);
        }
        LOG.error("Unknown element:" + node);
        return false;
    }

    private static boolean isCollapseDocCommentByDefault(@NotNull PsiDocComment element) {
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(65);
        }
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiJavaFile) {
            if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                return false;
            }
            PsiElement firstChild = parent.getFirstChild();
            if (firstChild instanceof PsiWhiteSpace) {
                firstChild = firstChild.getNextSibling();
            }
            if (element.equals(firstChild)) {
                return settings.isCollapseFileHeader();
            }
        }
        return settings.isCollapseJavadocs();
    }

    private static boolean isCollapseMethodByDefault(@NotNull PsiMethod element) {
        JavaCodeFoldingSettings settings;
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(66);
        }
        if (!(settings = JavaCodeFoldingSettings.getInstance()).isCollapseAccessors() && !settings.isCollapseMethods()) {
            return false;
        }
        if (JavaFoldingBuilderBase.isSimplePropertyAccessor(element)) {
            return settings.isCollapseAccessors();
        }
        return settings.isCollapseMethods();
    }

    private void addCodeBlockFolds(final @NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement scope, final @NotNull Set<PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(67);
        }
        if (scope == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(68);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(69);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(70);
        }
        final boolean dumb = DumbService.isDumb((Project)scope.getProject());
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, list, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)aClass, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.classRange(aClass), JavaCodeFoldingSettings.getInstance().isCollapseInnerClasses());
                    JavaFoldingBuilderBase.this.addFoldsForClass(list, aClass, document, false, quick);
                }
            }

            public void visitVariable(PsiVariable variable) {
                if (!dumb && JavaCodeFoldingSettings.getInstance().isReplaceVarWithInferredType()) {
                    JavaFoldingBuilderBase.addLocalVariableTypeFolding(list, variable, quick);
                }
                super.visitVariable(variable);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(list, expression2, document, quick);
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(list, expression2, document, quick);
                }
                super.visitNewExpression(expression2);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)expression2, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(expression2.getBody()), JavaFoldingBuilderBase.lambdaRange(expression2), JavaCodeFoldingSettings.getInstance().isCollapseAnonymousClasses());
                }
                super.visitLambdaExpression(expression2);
            }

            public void visitCodeBlock(PsiCodeBlock block) {
                if (Registry.is((String)"java.folding.icons.for.control.flow", (boolean)true) && block.getStatementCount() > 0) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)block, document, false, JavaFoldingBuilderBase.getCodeBlockPlaceholder((PsiElement)block), block.getTextRange(), false);
                }
                super.visitCodeBlock(block);
            }

            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addFoldsForComment(list, comment, processedComments);
                super.visitComment(comment);
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<? super FoldingDescriptor> list, @NotNull Set<PsiElement> processedComments, boolean quick) {
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(71);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(72);
        }
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(73);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(74);
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<NamedFoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<NamedFoldingDescriptor> list2 = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                list.addAll(descriptors);
                this.addCodeBlockFolds(list, (PsiElement)closureFolding.methodBody, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        if ("->" == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(75);
        }
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        if (element == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(76);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(77);
        }
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getContainingFile(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull PsiFile var1, int var2);

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(78);
        }
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(79);
        }
        if ((nodeType = node.getElementType()) == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 2: 
            case 14: 
            case 20: 
            case 26: 
            case 28: 
            case 32: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 70: 
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 54: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 42: 
            case 44: 
            case 47: 
            case 50: 
            case 53: 
            case 57: 
            case 60: 
            case 67: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 6: 
            case 8: 
            case 59: 
            case 65: 
            case 66: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 51: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase";
                break;
            }
            case 11: 
            case 12: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 17: 
            case 56: 
            case 69: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedComments";
                break;
            }
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFold";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 37: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 62: 
            case 64: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotationRange";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "rightArrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areOnAdjacentLines";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSimplePropertyAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "importListRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambdaRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "methodRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "classRange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moduleRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotationRange";
                break;
            }
            case 10: 
            case 75: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElementsNearby";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileHeaderRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationsToFold";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForComment";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMethodGenericParametersFolding";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addLocalVariableTypeFolding";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolvesCorrectly";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addGenericParametersFolding";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addTypeParametersFolding";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addToFold";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForImports";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForFileHeader";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForModule";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForClass";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addFoldsForMethod";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addDocCommentToFold";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addOneLineMethodFolding";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isCollapseDocCommentByDefault";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isCollapseMethodByDefault";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addCodeBlockFolds";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addClosureFolding";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fitsRightMargin";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

