/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaWithRunnableSurrounder
extends JavaStatementsSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.runnable.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, final Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = container.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        String baseName = "runnable";
        String uniqueName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("runnable", container, false);
        String text2 = "Runnable runnable = new Runnable(){\npublic void run(){\n}};";
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)factory.createStatementFromText(text2, null);
        declarationStatement = (PsiDeclarationStatement)codeStyleManager.reformat((PsiElement)declarationStatement);
        declarationStatement = (PsiDeclarationStatement)container.addAfter((PsiElement)declarationStatement, statements[statements.length - 1]);
        PsiVariable variable = (PsiVariable)declarationStatement.getDeclaredElements()[0];
        if (!Comparing.strEqual((String)uniqueName, (String)"runnable")) {
            variable.setName(uniqueName);
        }
        PsiNewExpression newExpression = (PsiNewExpression)variable.getInitializer();
        PsiElement[] children = newExpression.getChildren();
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)children[children.length - 1];
        PsiMethod method = anonymousClass.getMethods()[0];
        PsiCodeBlock body2 = method.getBody();
        body2.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        JavaWithRunnableSurrounder.makeVariablesFinal((PsiElement)body2, body2);
        int textOffset = variable.getNameIdentifier().getTextOffset();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(textOffset);
        editor.getSelectionModel().removeSelection();
        new VariableInplaceRenamer((PsiNamedElement)variable, editor){

            protected boolean shouldSelectAll() {
                return true;
            }

            protected void moveOffsetAfter(boolean success) {
                PsiNamedElement renamedVariable;
                super.moveOffsetAfter(success);
                if (success && (renamedVariable = this.getVariable()) != null) {
                    editor.getCaretModel().moveToOffset(renamedVariable.getTextRange().getEndOffset());
                }
            }
        }.performInplaceRename();
        return null;
    }

    private static void makeVariablesFinal(PsiElement scope, PsiCodeBlock body2) throws IncorrectOperationException {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            PsiElement parent;
            PsiVariable variable;
            PsiModifierList modifierList;
            PsiElement refElement;
            JavaWithRunnableSurrounder.makeVariablesFinal(child, body2);
            if (!(child instanceof PsiReferenceExpression) || child.getParent() instanceof PsiMethodCallExpression || PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)child)) || !((refElement = ((PsiReferenceExpression)child).resolve()) instanceof PsiLocalVariable) && !(refElement instanceof PsiParameter) || (modifierList = (variable = (PsiVariable)refElement).getModifierList()) != null && modifierList.hasModifierProperty("final")) continue;
            PsiMethod enclosingMethod = null;
            for (parent = variable.getParent(); parent != null && !parent.equals(body2); parent = parent.getParent()) {
                if (!(parent instanceof PsiMethod)) continue;
                enclosingMethod = (PsiMethod)parent;
            }
            if (parent != null || !JavaWithRunnableSurrounder.canBeDeclaredFinal(variable, enclosingMethod)) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
        }
    }

    private static boolean canBeDeclaredFinal(@NotNull PsiVariable variable, @Nullable PsiElement scope) {
        if (variable == null) {
            JavaWithRunnableSurrounder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            return false;
        }
        Collection references = ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope)).findAll();
        boolean foundOnce = variable instanceof PsiParameter || variable.getInitializer() != null;
        for (PsiReference reference : references) {
            if (!(reference instanceof PsiReferenceExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)reference))) continue;
            if (foundOnce) {
                return false;
            }
            foundOnce = true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/generation/surroundWith/JavaWithRunnableSurrounder", "canBeDeclaredFinal"));
    }
}

