/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.AnnotationHintsPassFactory;
import com.intellij.codeInsight.hints.ElementProcessingHintPass;
import com.intellij.codeInsight.hints.ModificationStampHolder;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001d\u001e\u001f B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000326\u0010\f\u001a2\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\n0\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass;", "Lcom/intellij/codeInsight/hints/ElementProcessingHintPass;", "rootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modificationStampHolder", "Lcom/intellij/codeInsight/hints/ModificationStampHolder;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/ModificationStampHolder;)V", "collectElementHints", "", "element", "collector", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "offset", "", "hint", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "getHintKey", "Lcom/intellij/openapi/util/Key;", "", "isAvailable", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "AnnotationHintRenderer", "Companion", "ToggleExternalAnnotationsHintsAction", "ToggleInferredAnnotationsHintsAction", "intellij.java.impl"})
public final class AnnotationHintsPass
extends ElementProcessingHintPass {
    private static final Key<Boolean> ANNOTATION_INLAY_KEY;
    public static final Companion Companion;

    @Override
    public boolean isAvailable(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE && ExternalAnnotationsManager.getInstance((Project)this.myProject).hasAnnotationRootsForFile(virtualFile) || CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectElementHints(@NotNull PsiElement element, @NotNull Function2<? super Integer, ? super String, Unit> collector) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(collector, (String)"collector");
        if (element instanceof PsiModifierListOwner) {
            Sequence annotations2 = SequencesKt.emptySequence();
            if (CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE) {
                void $receiver$iv;
                PsiAnnotation[] psiAnnotationArray = ExternalAnnotationsManager.getInstance((Project)this.myProject).findExternalAnnotations((PsiModifierListOwner)element);
                Sequence sequence = annotations2;
                PsiAnnotation[] psiAnnotationArray2 = $receiver$iv;
                if (psiAnnotationArray2 == null) {
                    psiAnnotationArray2 = new PsiAnnotation[]{};
                }
                void var14_6 = psiAnnotationArray2;
                annotations2 = SequencesKt.plus((Sequence)sequence, (Object[])var14_6);
            }
            if (CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE) {
                Object[] objectArray = InferredAnnotationsManager.getInstance((Project)this.myProject).findInferredAnnotations((PsiModifierListOwner)element);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"InferredAnnotationsManag\u2026erredAnnotations(element)");
                annotations2 = SequencesKt.plus((Sequence)annotations2, (Object[])objectArray);
            }
            Set shownAnnotations = new LinkedHashSet();
            Sequence $receiver$iv = annotations2;
            for (Object element$iv : $receiver$iv) {
                PsiAnnotation it = (PsiAnnotation)element$iv;
                PsiJavaCodeReferenceElement nameReferenceElement = it.getNameReferenceElement();
                if (nameReferenceElement == null || ((PsiModifierListOwner)element).getModifierList() == null) continue;
                String string = nameReferenceElement.getQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"nameReferenceElement.qualifiedName");
                if (!shownAnnotations.add(string) && !JavaDocInfoGenerator.isRepeatableAnnotationType((PsiElement)it)) continue;
                PsiModifierList psiModifierList = ((PsiModifierListOwner)element).getModifierList();
                if (psiModifierList == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"element.modifierList!!");
                TextRange textRange = psiModifierList.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.modifierList!!.textRange");
                int offset = textRange.getStartOffset();
                Integer n = offset;
                StringBuilder stringBuilder = new StringBuilder().append("@").append(nameReferenceElement.getReferenceName());
                PsiAnnotationParameterList psiAnnotationParameterList = it.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"it.parameterList");
                collector.invoke((Object)n, (Object)stringBuilder.append(psiAnnotationParameterList.getText()).toString());
            }
        }
    }

    @Override
    @NotNull
    public Key<Boolean> getHintKey() {
        Key<Boolean> key2 = ANNOTATION_INLAY_KEY;
        Intrinsics.checkExpressionValueIsNotNull(key2, (String)"ANNOTATION_INLAY_KEY");
        return key2;
    }

    @Override
    @NotNull
    public HintRenderer createRenderer(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return new AnnotationHintRenderer(text2);
    }

    public AnnotationHintsPass(@NotNull PsiElement rootElement, @NotNull Editor editor, @NotNull ModificationStampHolder modificationStampHolder) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)modificationStampHolder, (String)"modificationStampHolder");
        super(rootElement, editor, modificationStampHolder);
    }

    static {
        Companion = new Companion(null);
        ANNOTATION_INLAY_KEY = Key.create((String)"ANNOTATION_INLAY_KEY");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$AnnotationHintRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "", "(Ljava/lang/String;)V", "getContextMenuGroupId", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.java.impl"})
    private static final class AnnotationHintRenderer
    extends HintRenderer {
        @NotNull
        public String getContextMenuGroupId(@NotNull Inlay<?> inlay) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            return "AnnotationHintsContextMenu";
        }

        public AnnotationHintRenderer(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            super(text2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleExternalAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleExternalAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            CodeInsightSettings.getInstance().SHOW_EXTERNAL_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.getModificationStampHolder().forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$ToggleInferredAnnotationsHintsAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.impl"})
    public static final class ToggleInferredAnnotationsHintsAction
    extends ToggleAction {
        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            CodeInsightSettings.getInstance().SHOW_INFERRED_ANNOTATIONS_INLINE = state;
            AnnotationHintsPassFactory.Companion.getModificationStampHolder().forceHintsUpdateOnNextPass();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/AnnotationHintsPass$Companion;", "", "()V", "ANNOTATION_INLAY_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "intellij.java.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

