/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.codeInsight.hints.ElementProcessingHintPass;
import com.intellij.codeInsight.hints.ModificationStampHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002JH\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000526\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/hints/MethodChainHintsPass;", "Lcom/intellij/codeInsight/hints/ElementProcessingHintPass;", "modificationStampHolder", "Lcom/intellij/codeInsight/hints/ModificationStampHolder;", "rootElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/codeInsight/hints/ModificationStampHolder;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "collectChain", "", "Lcom/intellij/psi/PsiMethodCallExpression;", "call", "collectElementHints", "", "element", "collector", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "offset", "", "hint", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "getHintKey", "Lcom/intellij/openapi/util/Key;", "", "isAvailable", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isFirstCall", "Companion", "MethodChainHintRenderer", "intellij.java.impl"})
public final class MethodChainHintsPass
extends ElementProcessingHintPass {
    private static final Key<Boolean> METHOD_CHAIN_INLAY_KEY;
    public static final Companion Companion;

    @Override
    public boolean isAvailable(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return CodeInsightSettings.getInstance().SHOW_METHOD_CHAIN_TYPES_INLINE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectElementHints(@NotNull PsiElement element, @NotNull Function2<? super Integer, ? super String, Unit> collector) {
        int i;
        void $receiver$iv$iv22;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(collector, (String)"collector");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            psiElement = null;
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)psiElement;
        if (psiMethodCallExpression == null) {
            return;
        }
        PsiMethodCallExpression call = psiMethodCallExpression;
        if (!this.isFirstCall(call)) {
            return;
        }
        PsiElement next = call.getNextSibling();
        if (!(next instanceof PsiWhiteSpace) || !next.textContains('\n')) {
            return;
        }
        Iterable iterable = this.collectChain(call);
        void var7_6 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiWhiteSpace nextSibling;
            PsiMethodCallExpression it = (PsiMethodCallExpression)element$iv$iv;
            PsiElement psiElement2 = it.getNextSibling();
            if (!(psiElement2 instanceof PsiWhiteSpace)) {
                psiElement2 = null;
            }
            boolean bl = (PsiWhiteSpace)psiElement2 == null ? false : nextSibling.textContains('\n');
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List chain = (List)destination$iv$iv;
        if (chain.isEmpty()) {
            return;
        }
        Iterable $receiver$iv2 = chain;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv22 = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv22;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PsiType psiType;
            Object element$iv$iv = element$iv$iv$iv;
            PsiMethodCallExpression it = (PsiMethodCallExpression)element$iv$iv;
            if (it.getType() == null) continue;
            PsiType it$iv$iv = psiType;
            destination$iv$iv22.add(it$iv$iv);
        }
        List types = (List)destination$iv$iv22;
        if (types.size() != chain.size()) {
            return;
        }
        Set uniqueTypes = new LinkedHashSet();
        int $receiver$iv$iv22 = 0;
        int destination$iv$iv22 = types.size() - 1;
        while ($receiver$iv$iv22 < destination$iv$iv22) {
            Object e = types.get(i);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"types[i]");
            uniqueTypes.add(e);
            ++i;
        }
        if (uniqueTypes.size() < 2) {
            return;
        }
        i = 0;
        for (PsiMethodCallExpression currentCall : (Iterable)chain) {
            void index;
            TextRange textRange = currentCall.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"currentCall.textRange");
            int offset = textRange.getEndOffset();
            Integer n = offset;
            Object e = types.get((int)index);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"types[index]");
            String string = ((PsiType)e).getPresentableText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"types[index].presentableText");
            collector.invoke((Object)n, (Object)string);
            ++index;
        }
    }

    private final boolean isFirstCall(PsiMethodCallExpression call) {
        PsiMethodCallExpression firstQualifierCall;
        int callLine;
        Document document;
        block12: {
            block11: {
                Editor editor = this.myEditor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
                document = editor.getDocument();
                PsiExpressionList psiExpressionList = call.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList, (String)"call.argumentList");
                int textOffset = psiExpressionList.getTextOffset();
                Document document2 = document;
                Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                if (document2.getTextLength() - 1 < textOffset) {
                    return false;
                }
                callLine = document.getLineNumber(textOffset);
                PsiMethodCallExpression callForQualifier = ExpressionUtils.getCallForQualifier((PsiExpression)call);
                if (callForQualifier == null) break block11;
                PsiExpressionList psiExpressionList2 = callForQualifier.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList2, (String)"callForQualifier.argumentList");
                if (document.getLineNumber(psiExpressionList2.getTextOffset()) != callLine) break block12;
            }
            return false;
        }
        PsiReferenceExpression psiReferenceExpression = call.getMethodExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"call.methodExpression");
        PsiElement psiElement = psiReferenceExpression.getQualifier();
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            psiElement = null;
        }
        if ((firstQualifierCall = (PsiMethodCallExpression)psiElement) != null) {
            PsiExpressionList psiExpressionList = firstQualifierCall.getArgumentList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList, (String)"firstQualifierCall.argumentList");
            if (document.getLineNumber(psiExpressionList.getTextOffset()) != callLine) {
                return false;
            }
            PsiMethodCallExpression currentQualifierCall = firstQualifierCall;
            while (true) {
                PsiReferenceExpression psiReferenceExpression2 = currentQualifierCall.getMethodExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression2, (String)"currentQualifierCall.methodExpression");
                PsiElement qualifier = psiReferenceExpression2.getQualifier();
                if (qualifier == null) {
                    return false;
                }
                if (!(qualifier instanceof PsiMethodCallExpression)) {
                    return true;
                }
                PsiExpressionList psiExpressionList3 = ((PsiMethodCallExpression)qualifier).getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList3, (String)"qualifier.argumentList");
                if (document.getLineNumber(psiExpressionList3.getTextOffset()) != callLine) {
                    return false;
                }
                currentQualifierCall = (PsiMethodCallExpression)qualifier;
            }
        }
        return true;
    }

    private final List<PsiMethodCallExpression> collectChain(PsiMethodCallExpression call) {
        PsiMethodCallExpression nextCall;
        List chain = CollectionsKt.mutableListOf((Object[])new PsiMethodCallExpression[]{call});
        PsiMethodCallExpression current = call;
        while ((nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)current)) != null) {
            chain.add(nextCall);
            current = nextCall;
        }
        return chain;
    }

    @Override
    @NotNull
    public Key<Boolean> getHintKey() {
        Key<Boolean> key2 = METHOD_CHAIN_INLAY_KEY;
        Intrinsics.checkExpressionValueIsNotNull(key2, (String)"METHOD_CHAIN_INLAY_KEY");
        return key2;
    }

    @Override
    @NotNull
    public HintRenderer createRenderer(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return new MethodChainHintRenderer(text2);
    }

    public MethodChainHintsPass(@NotNull ModificationStampHolder modificationStampHolder, @NotNull PsiElement rootElement, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)modificationStampHolder, (String)"modificationStampHolder");
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super(rootElement, editor, modificationStampHolder);
    }

    static {
        Companion = new Companion(null);
        METHOD_CHAIN_INLAY_KEY = Key.create((String)"METHOD_CHAIN_INLAY_KEY");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/codeInsight/hints/MethodChainHintsPass$MethodChainHintRenderer;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "text", "", "(Ljava/lang/String;)V", "getContextMenuGroupId", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.java.impl"})
    private static final class MethodChainHintRenderer
    extends HintRenderer {
        @NotNull
        public String getContextMenuGroupId(@NotNull Inlay<?> inlay) {
            Intrinsics.checkParameterIsNotNull(inlay, (String)"inlay");
            return "MethodChainHintsContextMenu";
        }

        public MethodChainHintRenderer(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            super(text2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/MethodChainHintsPass$Companion;", "", "()V", "METHOD_CHAIN_INLAY_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "intellij.java.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

