/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIfConditionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiIfStatement ifStatement;
        if (project == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(1);
        }
        if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) == null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (!(condition2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiType expressionType = polyadicExpression.getType();
        if (expressionType == null || !PsiType.BOOLEAN.isAssignableFrom(expressionType)) {
            return false;
        }
        IElementType operation = polyadicExpression.getOperationTokenType();
        if (operation != JavaTokenType.OROR && operation != JavaTokenType.ANDAND) {
            return false;
        }
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.extract.if.condition.text", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand2)}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement;
        if (project == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(3);
        }
        if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class)) == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CommentTracker tracker = new CommentTracker();
        PsiStatement newIfStatement = ExtractIfConditionAction.create(factory, ifStatement, element, tracker);
        if (newIfStatement == null) {
            return;
        }
        codeStyleManager.reformat(tracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)newIfStatement));
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement element, CommentTracker tracker) {
        PsiExpression condition2;
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(4);
        }
        if (ifStatement == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(6);
        }
        if (!((condition2 = ifStatement.getCondition()) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return null;
        }
        PsiExpression leave = ExtractIfConditionAction.removeOperand(factory, polyadicExpression, operand2, tracker);
        return SplitConditionUtil.create(factory, ifStatement, operand2, leave, polyadicExpression.getOperationTokenType(), tracker);
    }

    @NotNull
    private static PsiExpression removeOperand(@NotNull PsiElementFactory factory, @NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2, CommentTracker tracker) {
        if (factory == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(7);
        }
        if (expression2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(8);
        }
        if (operand2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(9);
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression e : expression2.getOperands()) {
            if (e == operand2) continue;
            PsiJavaToken token = expression2.getTokenBeforeOperand(e);
            if (token != null && sb.length() != 0) {
                sb.append(token.getText()).append(" ");
            }
            sb.append(tracker.text((PsiElement)e));
        }
        PsiExpression psiExpression = factory.createExpressionFromText(sb.toString(), (PsiElement)expression2);
        if (psiExpression == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(10);
        }
        return psiExpression;
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        if (e == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(11);
        }
        if (expression2 == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(12);
        }
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.extract.if.condition.family", (Object[])new Object[0]);
        if (string == null) {
            ExtractIfConditionAction.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ExtractIfConditionAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeOperand";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeOperand";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOperand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

