/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddAssertStatementFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AddAssertStatementFix");
    private final SmartPsiElementPointer<PsiExpression> myExpressionToAssert;
    private final String myText;

    public AddAssertStatementFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            AddAssertStatementFix.$$$reportNull$$$0(0);
        }
        this.myExpressionToAssert = SmartPointerManager.getInstance((Project)expressionToAssert.getProject()).createSmartPsiElementPointer((PsiElement)expressionToAssert);
        LOG.assertTrue(PsiType.BOOLEAN.equals((Object)expressionToAssert.getType()));
        this.myText = expressionToAssert.getText();
    }

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.assert.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            AddAssertStatementFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement prev;
        PsiExpression expressionToAssert;
        if (project == null) {
            AddAssertStatementFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            AddAssertStatementFix.$$$reportNull$$$0(3);
        }
        if ((expressionToAssert = (PsiExpression)this.myExpressionToAssert.getElement()) == null) {
            return;
        }
        PsiElement element = descriptor2.getPsiElement();
        PsiElement anchorElement = RefactoringUtil.getParentStatement(element, false);
        LOG.assertTrue(anchorElement != null);
        PsiElement tempParent = anchorElement.getParent();
        if (tempParent instanceof PsiForStatement && !PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)tempParent).getBody(), (PsiElement)anchorElement, (boolean)false)) {
            anchorElement = tempParent;
        }
        if ((prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorElement)) instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            anchorElement = prev;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            String text2 = "assert c;";
            PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText(text2, null);
            PsiExpression assertCondition = assertStatement.getAssertCondition();
            assert (assertCondition != null);
            assertCondition.replace((PsiElement)expressionToAssert);
            PsiElement parent = anchorElement.getParent();
            if (parent instanceof PsiCodeBlock) {
                parent.addBefore((PsiElement)assertStatement, anchorElement);
            } else {
                RefactoringUtil.putStatementInLoopBody((PsiStatement)assertStatement, parent, anchorElement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.quickfix.assert.family", (Object[])new Object[0]);
        if (string == null) {
            AddAssertStatementFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToAssert";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AddAssertStatementFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AddAssertStatementFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

