/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LambdaCanBeMethodCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher PREDICATE_TEST = CallMatcher.instanceCall("java.util.function.Predicate", "test").parameterTypes("T");
    private static final CallMatcher MATCHER_FIND = CallMatcher.instanceCall("java.util.regex.Matcher", "find").parameterCount(0);
    private static final CallMatcher MATCHER_MATCHES = CallMatcher.instanceCall("java.util.regex.Matcher", "matches").parameterCount(0);
    private static final CallMatcher PATTERN_MATCHER = CallMatcher.instanceCall("java.util.regex.Pattern", "matcher").parameterCount(1);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LambdaCanBeMethodCallInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                LambdaCanBeMethodCallInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final boolean java11 = PsiUtil.isLanguageLevel11OrHigher((PsiElement)holder.getFile());
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiElement body2 = lambda2.getBody();
                if (body2 == null) {
                    return;
                }
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                if (!(type2 instanceof PsiClassType)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)lambda2.getParent());
                if (parent instanceof PsiTypeCastExpression && InheritanceUtil.isInheritor((PsiType)((PsiTypeCastExpression)parent).getType(), (String)"java.io.Serializable")) {
                    return;
                }
                PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2));
                if (expression2 == null) {
                    return;
                }
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length == 1) {
                    PsiParameter parameter2 = parameters2[0];
                    if (ExpressionUtils.isReferenceTo(expression2, (PsiVariable)parameter2)) {
                        this.handleFunctionIdentity(lambda2, (PsiClassType)type2);
                    }
                    if (expression2 instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
                        PsiClass aClass = ((PsiClassType)type2).resolve();
                        if (aClass != null && "java.util.function.Predicate".equals(aClass.getQualifiedName())) {
                            this.handlePredicateIsEqual(lambda2, parameter2, call);
                            this.handlePatternAsPredicate(lambda2, parameter2, call);
                        }
                    }
                    this.handlePatternNegate(lambda2, parameter2, expression2);
                }
            }

            private void handlePatternNegate(PsiLambdaExpression lambda2, PsiParameter parameter2, PsiExpression expression2) {
                if (!BoolUtils.isNegation(expression2)) {
                    return;
                }
                PsiMethodCallExpression negated = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)BoolUtils.getNegated(expression2), PsiMethodCallExpression.class);
                if (!PREDICATE_TEST.test(negated)) {
                    return;
                }
                if (!ExpressionUtils.isReferenceTo(negated.getArgumentList().getExpressions()[0], (PsiVariable)parameter2)) {
                    return;
                }
                PsiExpression qualifier = negated.getMethodExpression().getQualifierExpression();
                if (!ExpressionUtils.isSafelyRecomputableExpression(qualifier) || ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)parameter2)) {
                    return;
                }
                PsiType lambdaType = ExpectedTypeUtils.findExpectedType((PsiExpression)lambda2, false);
                if (lambdaType == null || qualifier.getType() == null || !lambdaType.isAssignableFrom(qualifier.getType())) {
                    return;
                }
                this.registerProblem(lambda2, "Pattern.negate()", ParenthesesUtils.getText(qualifier, 1) + ".negate()");
            }

            private void handleFunctionIdentity(PsiLambdaExpression lambda2, PsiClassType type2) {
                PsiClass aClass = type2.resolve();
                if (aClass == null || !"java.util.function.Function".equals(aClass.getQualifiedName())) {
                    return;
                }
                PsiType[] typeParameters = type2.getParameters();
                if (typeParameters.length != 2 || !typeParameters[1].isAssignableFrom(typeParameters[0])) {
                    return;
                }
                String replacement = "java.util.function.Function.identity()";
                if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda2, (String)replacement)) {
                    return;
                }
                this.registerProblem(lambda2, "Function.identity()", replacement);
            }

            private void handlePatternAsPredicate(PsiLambdaExpression lambda2, PsiParameter parameter2, PsiMethodCallExpression call) {
                if (!(MATCHER_FIND.test(call) || java11 && MATCHER_MATCHES.test(call))) {
                    return;
                }
                PsiMethodCallExpression matcherCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!PATTERN_MATCHER.test(matcherCall)) {
                    return;
                }
                PsiExpression matcherArg = matcherCall.getArgumentList().getExpressions()[0];
                if (!ExpressionUtils.isReferenceTo(matcherArg, (PsiVariable)parameter2)) {
                    return;
                }
                PsiExpression pattern = matcherCall.getMethodExpression().getQualifierExpression();
                if (pattern == null || !LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)pattern)) {
                    return;
                }
                String methodName = "find".equalsIgnoreCase(call.getMethodExpression().getReferenceName()) ? "asPredicate" : "asMatchPredicate";
                this.registerProblem(lambda2, "Pattern." + methodName + "()", ParenthesesUtils.getText(pattern, 2) + "." + methodName + "()");
            }

            private void handlePredicateIsEqual(PsiLambdaExpression lambda2, PsiParameter parameter2, PsiMethodCallExpression call) {
                PsiExpression[] args;
                if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Objects", "equals", 2) && (args = call.getArgumentList().getExpressions()).length == 2) {
                    PsiExpression comparedWith;
                    if (ExpressionUtils.isReferenceTo(args[0], (PsiVariable)parameter2)) {
                        comparedWith = args[1];
                    } else if (ExpressionUtils.isReferenceTo(args[1], (PsiVariable)parameter2)) {
                        comparedWith = args[0];
                    } else {
                        return;
                    }
                    if (LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)comparedWith)) {
                        this.registerProblem(lambda2, "Predicate.isEqual()", "java.util.function.Predicate.isEqual(" + comparedWith.getText() + ")");
                    }
                }
            }

            private void registerProblem(PsiLambdaExpression lambda2, String displayReplacement, String replacement) {
                holder.registerProblem((PsiElement)lambda2, InspectionsBundle.message((String)"inspection.lambda.to.method.call.message", (Object[])new Object[]{displayReplacement}), new LocalQuickFix[]{new ReplaceWithFunctionCallFix(replacement, displayReplacement)});
            }
        };
        if (javaElementVisitor == null) {
            LambdaCanBeMethodCallInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LambdaCanBeMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LambdaCanBeMethodCallInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ReplaceWithFunctionCallFix
    implements LocalQuickFix {
        private final String myDisplayReplacement;
        private final String myReplacement;

        ReplaceWithFunctionCallFix(String replacement, String displayReplacement) {
            this.myReplacement = replacement;
            this.myDisplayReplacement = displayReplacement;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.lambda.to.method.call.fix.name", (Object[])new Object[]{this.myDisplayReplacement});
            if (string == null) {
                ReplaceWithFunctionCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.lambda.to.method.call.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithFunctionCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ReplaceWithFunctionCallFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceWithFunctionCallFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getStartElement()) instanceof PsiLambdaExpression)) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments(element, this.myReplacement);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LambdaCanBeMethodCallInspection$ReplaceWithFunctionCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

