/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class RemoveAssignmentFix
extends RemoveInitializerFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.unused.assignment.remove.assignment.quickfix", (Object[])new Object[0]);
        if (string == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement gParent;
        PsiElement element;
        PsiElement parent;
        if (project == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            RemoveAssignmentFix.$$$reportNull$$$0(2);
        }
        if (!((parent = (element = descriptor2.getPsiElement()) instanceof PsiReferenceExpression ? element.getParent() : element) instanceof PsiAssignmentExpression)) {
            return;
        }
        IElementType operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType();
        PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
        if (JavaTokenType.EQ != operationSign && rExpression != null) {
            rExpression = DeclarationJoinLinesHandler.getInitializerExpression(((PsiAssignmentExpression)parent).getLExpression(), (PsiAssignmentExpression)parent);
        }
        if (((gParent = parent.getParent()) instanceof PsiExpression || gParent instanceof PsiExpressionList || gParent instanceof PsiReturnStatement) && rExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(gParent.getContainingFile())) {
                return;
            }
            PsiExpression finalRExpr = rExpression;
            WriteAction.run(() -> {
                if (gParent instanceof PsiParenthesizedExpression) {
                    gParent.replace((PsiElement)finalRExpr);
                } else {
                    parent.replace((PsiElement)finalRExpr);
                }
            });
            return;
        }
        PsiElement resolve = null;
        if (element instanceof PsiReferenceExpression) {
            resolve = ((PsiReferenceExpression)element).resolve();
        } else {
            PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)parent).getLExpression());
            if (lExpr instanceof PsiReferenceExpression) {
                resolve = ((PsiReferenceExpression)lExpr).resolve();
            }
        }
        if (!(resolve instanceof PsiVariable)) {
            return;
        }
        RemoveAssignmentFix.sideEffectAwareRemove(project, rExpression, parent, (PsiVariable)resolve);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAssignmentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

