/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.replace.ternary.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(1);
        }
        this.myText = ParenthesesUtils.getText(expressionToAssert, 10);
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement parent;
        if (project == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(4);
        }
        PsiElement element = descriptor2.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiCallExpression || parent instanceof PsiJavaCodeReferenceElement) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiFile file = expression2.getContainingFile();
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWithConditionalExpression(project, this.myText + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
        ReplaceWithTernaryOperatorFix.selectElseBranch(file, conditionalExpression);
    }

    static void selectElseBranch(PsiFile file, PsiConditionalExpression conditionalExpression) {
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        if (elseExpression2 != null) {
            ((Navigatable)elseExpression2).navigate(true);
            SelectInEditorManager.getInstance((Project)file.getProject()).selectInEditor(file.getVirtualFile(), elseExpression2.getTextRange().getStartOffset(), elseExpression2.getTextRange().getEndOffset(), false, true);
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWithConditionalExpression(@NotNull Project project, @NotNull String condition2, @NotNull PsiExpression expression2, @NotNull String defaultValue) {
        if (project == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(5);
        }
        if (condition2 == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(7);
        }
        if (defaultValue == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(8);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement parent = expression2.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition2 + " ? " + expression2.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiConditionalExpression psiConditionalExpression = (PsiConditionalExpression)expression2.replace(codeStyleManager.reformat((PsiElement)conditionalExpression));
        if (psiConditionalExpression == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(9);
        }
        return psiConditionalExpression;
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression2) {
        if (qualifier == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(11);
        }
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression2.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ReplaceWithTernaryOperatorFix.$$$reportNull$$$0(12);
        }
        PsiType type2 = expression2.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToAssert";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithConditionalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithConditionalExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReplaceMethodRefWithTernaryOperatorFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.replace.methodref.ternary.quickfix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceMethodRefWithTernaryOperatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiMethodReferenceExpression element;
            if (project == null) {
                ReplaceMethodRefWithTernaryOperatorFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceMethodRefWithTernaryOperatorFix.$$$reportNull$$$0(2);
            }
            if ((element = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)descriptor2.getPsiElement(), PsiMethodReferenceExpression.class)) == null) {
                return;
            }
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.convertMethodReferenceToLambda(element, false, true);
            if (lambda2 == null) {
                return;
            }
            PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (expression2 == null) {
                return;
            }
            PsiParameter parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])lambda2.getParameterList().getParameters());
            if (parameter2 == null) {
                return;
            }
            String text2 = parameter2.getName();
            PsiFile file = expression2.getContainingFile();
            PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWithConditionalExpression(project, text2 + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
            ReplaceWithTernaryOperatorFix.selectElseBranch(file, conditionalExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix$ReplaceMethodRefWithTernaryOperatorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix$ReplaceMethodRefWithTernaryOperatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

