/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressManagerImpl
extends SuppressManager
implements RedundantSuppressionDetector {
    private static final Logger LOG = Logger.getInstance(SuppressManager.class);

    @NotNull
    public SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        if (displayKey == null) {
            SuppressManagerImpl.$$$reportNull$$$0(0);
        }
        SuppressQuickFix[] batchSuppressActions = this.createBatchSuppressActions(displayKey);
        SuppressIntentionAction[] suppressIntentionActionArray = SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions((SuppressQuickFix[])batchSuppressActions);
        if (suppressIntentionActionArray == null) {
            SuppressManagerImpl.$$$reportNull$$$0(1);
        }
        return suppressIntentionActionArray;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        HighlightDisplayKey displayKey;
        if (toolId == null) {
            SuppressManagerImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((displayKey = HighlightDisplayKey.findById((String)toolId)) != null, (Object)("Display key is null for `" + toolId + "` tool"));
        SuppressQuickFix[] suppressQuickFixArray = this.createBatchSuppressActions(displayKey);
        if (suppressQuickFixArray == null) {
            SuppressManagerImpl.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            SuppressManagerImpl.$$$reportNull$$$0(4);
        }
        if (toolId == null) {
            SuppressManagerImpl.$$$reportNull$$$0(5);
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        if (element == null) {
            SuppressManagerImpl.$$$reportNull$$$0(6);
        }
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            SuppressManagerImpl.$$$reportNull$$$0(7);
        }
        if (toolId == null) {
            SuppressManagerImpl.$$$reportNull$$$0(8);
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file) {
        if (file == null) {
            SuppressManagerImpl.$$$reportNull$$$0(9);
        }
        return JavaSuppressionUtil.canHave15Suppressions(file);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        if (commentOwner == null) {
            SuppressManagerImpl.$$$reportNull$$$0(10);
        }
        return JavaSuppressionUtil.alreadyHas14Suppressions((PsiJavaDocumentedElement)commentOwner);
    }

    public String getSuppressionIds(@NotNull PsiElement element) {
        if (element == null) {
            SuppressManagerImpl.$$$reportNull$$$0(11);
        }
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        PsiElement suppressionScope;
        if (elementWithSuppression == null) {
            SuppressManagerImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            SuppressManagerImpl.$$$reportNull$$$0(13);
        }
        if (toolId == null) {
            SuppressManagerImpl.$$$reportNull$$$0(14);
        }
        return (suppressionScope = JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId)) != null && PsiTreeUtil.isAncestor((PsiElement)elementWithSuppression, (PsiElement)suppressionScope, (boolean)false);
    }

    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        if (toolId == null) {
            SuppressManagerImpl.$$$reportNull$$$0(15);
        }
        return new RemoveSuppressWarningAction(toolId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayKey";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuppressManagerImpl";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWithSuppression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuppressManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInspectionIdsIn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToolSuppressedIn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canHave15Suppressions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "alreadyHas14Suppressions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionIds";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressionFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveRedundantSuppressionFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

