/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AnnotatedElementInspectionBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class UnstableApiUsageInspection
extends AnnotatedElementInspectionBase {
    public final List<String> unstableApiAnnotations = new ExternalizableStringSet("org.jetbrains.annotations.ApiStatus.Experimental", "com.google.common.annotations.Beta", "io.reactivex.annotations.Beta", "io.reactivex.annotations.Experimental", "rx.annotations.Experimental", "rx.annotations.Beta", "org.apache.http.annotation.Beta", "org.gradle.api.Incubating");

    @Override
    @NotNull
    protected List<String> getAnnotations() {
        List<String> list = this.unstableApiAnnotations;
        if (list == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    protected void createProblem(@NotNull PsiReference reference, @NotNull ProblemsHolder holder) {
        if (reference == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(2);
        }
        String message2 = JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.description", UnstableApiUsageInspection.getReferenceText(reference));
        holder.registerProblem(reference, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    protected boolean shouldProcessElement(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(3);
        }
        return UnstableApiUsageInspection.isLibraryElement((PsiElement)element);
    }

    @Override
    @NotNull
    public JPanel createOptionsPanel() {
        JPanel checkboxPanel = super.createOptionsPanel();
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl(this.unstableApiAnnotations, JvmAnalysisBundle.message("jvm.inspections.unstable.api.usage.annotations.list", new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)checkboxPanel, "North");
        panel.add((Component)annotationsListControl, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static boolean isLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            UnstableApiUsageInspection.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        PsiFile containingPsiFile = element.getContainingFile();
        if (containingPsiFile == null) {
            return false;
        }
        VirtualFile containingVirtualFile = containingPsiFile.getVirtualFile();
        if (containingVirtualFile == null) {
            return false;
        }
        return ProjectFileIndex.getInstance((Project)element.getProject()).isInLibraryClasses(containingVirtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UnstableApiUsageInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProblem";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

