/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class BytecodeAnalysisIndex
extends ScalarIndexExtension<HMember> {
    private static final ID<HMember, Void> NAME = ID.create((String)"bytecodeAnalysis");
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int VERSION = 11;
    private static final int VERSION_MODIFIER = HardCodedPurity.AGGRESSIVE_HARDCODED_PURITY ? 1 : 0;
    private static final int FINAL_VERSION = 22 + VERSION_MODIFIER;
    private static final VirtualFileGist<Map<HMember, Equations>> ourGist = GistManager.getInstance().newVirtualFileGist("BytecodeAnalysisIndex", FINAL_VERSION, (DataExternalizer)new EquationsExternalizer(), (VirtualFileGist.GistCalculator)new ClassDataIndexer());
    static final BinaryOperator<Equations> MERGER = (eq1, eq2) -> eq1.equals(eq2) ? eq1 : new Equations(Collections.emptyList(), false);

    @NotNull
    public ID<HMember, Void> getName() {
        ID<HMember, Void> iD = NAME;
        if (iD == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<HMember, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            try {
                return BytecodeAnalysisIndex.collectKeys(inputData.getContent());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
                return Collections.emptyMap();
            }
        };
        if (dataIndexer == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<HMember, Void> collectKeys(byte[] content) {
        final HashMap<HMember, Void> map = new HashMap<HMember, Void>();
        final MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
        ClassReader reader = new ClassReader(content);
        final String className = reader.getClassName();
        reader.accept(new ClassVisitor(458752){

            public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
                if ((access & 2) == 0) {
                    map.put(new Member(className, name2, desc).hashed(md), null);
                }
                return null;
            }

            public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                map.put(new Member(className, name2, desc).hashed(md), null);
                return null;
            }
        }, 7);
        HashMap<HMember, Void> hashMap = map;
        if (hashMap == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    public KeyDescriptor<HMember> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(3);
        }
        return hKeyDescriptor;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 10;
    }

    @NotNull
    static List<Equations> getEquations(GlobalSearchScope scope, HMember key2) {
        Project project = ProjectManager.getInstance().getDefaultProject();
        List list = ContainerUtil.mapNotNull((Collection)FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)key2, scope), file -> (Equations)((Map)ourGist.getFileData(project, file)).get(key2));
        if (list == null) {
            BytecodeAnalysisIndex.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquations";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class EquationsExternalizer
    implements DataExternalizer<Map<HMember, Equations>> {
        public void save(@NotNull DataOutput out, Map<HMember, Equations> value2) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(0);
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, value2.entrySet(), entry -> {
                if (out == null) {
                    EquationsExternalizer.$$$reportNull$$$0(12);
                }
                KEY_DESCRIPTOR.save(out, (HMember)entry.getKey());
                EquationsExternalizer.saveEquations(out, (Equations)entry.getValue());
            });
        }

        public Map<HMember, Equations> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(1);
            }
            return StreamEx.of((Collection)DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                if (in == null) {
                    EquationsExternalizer.$$$reportNull$$$0(11);
                }
                return Pair.create((Object)KEY_DESCRIPTOR.read(in), (Object)EquationsExternalizer.readEquations(in));
            })).toMap(p -> (HMember)p.getFirst(), p -> (Equations)p.getSecond(), MERGER);
        }

        private static void saveEquations(@NotNull DataOutput out, Equations eqs) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(2);
            }
            out.writeBoolean(eqs.stable);
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)eqs.results.size());
            for (DirectionResultPair directionResultPair : eqs.results) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)directionResultPair.directionKey);
                Result rhs = directionResultPair.result;
                if (rhs instanceof Value) {
                    Value finalResult = (Value)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)finalResult.ordinal());
                    continue;
                }
                if (rhs instanceof Pending) {
                    Pending pendResult = (Pending)rhs;
                    out.writeBoolean(false);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)pendResult.delta.length);
                    for (Component component : pendResult.delta) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)component.value.ordinal());
                        EKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)ids.length);
                        for (EKey hKey : ids) {
                            EquationsExternalizer.writeKey(out, hKey, md);
                        }
                    }
                    continue;
                }
                if (!(rhs instanceof Effects)) continue;
                Effects effects = (Effects)rhs;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)effects.effects.size());
                for (EffectQuantum effect : effects.effects) {
                    EquationsExternalizer.writeEffect(out, effect, md);
                }
                EquationsExternalizer.writeDataValue(out, effects.returnValue, md);
            }
        }

        private static Equations readEquations(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(3);
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT((DataInput)in);
                Direction direction = Direction.fromInt(directionKey);
                if (direction == Direction.Pure || direction == Direction.Volatile) {
                    HashSet<EffectQuantum> effects = new HashSet<EffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT((DataInput)in);
                    for (int i = 0; i < effectsSize; ++i) {
                        effects.add(EquationsExternalizer.readEffect(in));
                    }
                    DataValue returnValue = EquationsExternalizer.readDataValue(in);
                    results.add(new DirectionResultPair(directionKey, new Effects(returnValue, effects)));
                    continue;
                }
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value2 = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, value2));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT((DataInput)in);
                Component[] components = new Component[sumLength];
                for (int i = 0; i < sumLength; ++i) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value3 = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT((DataInput)in);
                    EKey[] ids = new EKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        ids[j] = EquationsExternalizer.readKey(in);
                    }
                    components[i] = new Component(value3, ids);
                }
                results.add(new DirectionResultPair(directionKey, new Pending(components)));
            }
            return new Equations(results, stable);
        }

        @NotNull
        private static EKey readKey(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(4);
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            int rawDirKey = DataInputOutputUtil.readINT((DataInput)in);
            EKey eKey = new EKey((MemberDescriptor)new HMember(bytes), Direction.fromInt(Math.abs(rawDirKey)), in.readBoolean(), rawDirKey < 0);
            if (eKey == null) {
                EquationsExternalizer.$$$reportNull$$$0(5);
            }
            return eKey;
        }

        private static void writeKey(@NotNull DataOutput out, EKey key2, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(6);
            }
            out.write(key2.member.hashed(md).asBytes());
            int rawDirKey = key2.negated ? -key2.dirKey : key2.dirKey;
            DataInputOutputUtil.writeINT((DataOutput)out, (int)rawDirKey);
            out.writeBoolean(key2.stable);
        }

        private static void writeEffect(@NotNull DataOutput out, EffectQuantum effect, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(7);
            }
            if (effect == EffectQuantum.TopEffectQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (effect == EffectQuantum.ThisChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (effect instanceof EffectQuantum.CallQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
                EffectQuantum.CallQuantum callQuantum = (EffectQuantum.CallQuantum)effect;
                EquationsExternalizer.writeKey(out, callQuantum.key, md);
                out.writeBoolean(callQuantum.isStatic);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)callQuantum.data.length);
                for (DataValue dataValue : callQuantum.data) {
                    EquationsExternalizer.writeDataValue(out, dataValue, md);
                }
            } else if (effect instanceof EffectQuantum.ReturnChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
                EquationsExternalizer.writeKey(out, ((EffectQuantum.ReturnChangeQuantum)effect).key, md);
            } else if (effect instanceof EffectQuantum.FieldReadQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
                EquationsExternalizer.writeKey(out, ((EffectQuantum.FieldReadQuantum)effect).key, md);
            } else if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((EffectQuantum.ParamChangeQuantum)effect).n);
            }
        }

        private static EffectQuantum readEffect(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(8);
            }
            int effectMask = DataInputOutputUtil.readINT((DataInput)in);
            switch (effectMask) {
                case -1: {
                    return EffectQuantum.TopEffectQuantum;
                }
                case -2: {
                    return EffectQuantum.ThisChangeQuantum;
                }
                case -3: {
                    EKey key2 = EquationsExternalizer.readKey(in);
                    boolean isStatic = in.readBoolean();
                    int dataLength = DataInputOutputUtil.readINT((DataInput)in);
                    DataValue[] data = new DataValue[dataLength];
                    for (int di = 0; di < dataLength; ++di) {
                        data[di] = EquationsExternalizer.readDataValue(in);
                    }
                    return new EffectQuantum.CallQuantum(key2, data, isStatic);
                }
                case -4: {
                    return new EffectQuantum.ReturnChangeQuantum(EquationsExternalizer.readKey(in));
                }
                case -5: {
                    return new EffectQuantum.FieldReadQuantum(EquationsExternalizer.readKey(in));
                }
            }
            return new EffectQuantum.ParamChangeQuantum(effectMask);
        }

        private static void writeDataValue(@NotNull DataOutput out, DataValue dataValue, MessageDigest md) throws IOException {
            if (out == null) {
                EquationsExternalizer.$$$reportNull$$$0(9);
            }
            if (dataValue == DataValue.ThisDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (dataValue == DataValue.LocalDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (dataValue == DataValue.OwnedDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
            } else if (dataValue == DataValue.UnknownDataValue1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
            } else if (dataValue == DataValue.UnknownDataValue2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
            } else if (dataValue instanceof DataValue.ReturnDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-6);
                EquationsExternalizer.writeKey(out, ((DataValue.ReturnDataValue)dataValue).key, md);
            } else if (dataValue instanceof DataValue.ParameterDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((DataValue.ParameterDataValue)dataValue).n);
            }
        }

        private static DataValue readDataValue(@NotNull DataInput in) throws IOException {
            if (in == null) {
                EquationsExternalizer.$$$reportNull$$$0(10);
            }
            int dataI = DataInputOutputUtil.readINT((DataInput)in);
            switch (dataI) {
                case -1: {
                    return DataValue.ThisDataValue;
                }
                case -2: {
                    return DataValue.LocalDataValue;
                }
                case -3: {
                    return DataValue.OwnedDataValue;
                }
                case -4: {
                    return DataValue.UnknownDataValue1;
                }
                case -5: {
                    return DataValue.UnknownDataValue2;
                }
                case -6: {
                    return new DataValue.ReturnDataValue(EquationsExternalizer.readKey(in));
                }
            }
            return DataValue.ParameterDataValue.create(dataI);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "saveEquations";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readEquations";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readKey";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "writeKey";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "writeEffect";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "readEffect";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "writeDataValue";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "readDataValue";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$read$1";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$save$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<HMember>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, HMember value2) throws IOException {
            if (out == null) {
                HKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.write(value2.asBytes());
        }

        public HMember read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                HKeyDescriptor.$$$reportNull$$$0(1);
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            return new HMember(bytes);
        }

        public int getHashCode(HMember value2) {
            return value2.hashCode();
        }

        public boolean isEqual(HMember val1, HMember val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

