/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomMethodHandlers {
    private static final CallMatcher CONSTANT_CALLS = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.String", "contains", "indexOf", "startsWith", "endsWith", "lastIndexOf", "length", "trim", "substring", "equals", "equalsIgnoreCase", "charAt", "codePointAt", "compareTo", "replace"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterCount(1), CallMatcher.staticCall("java.lang.Math", "abs", "sqrt", "min", "max"));
    private static final int MAX_STRING_CONSTANT_LENGTH_TO_TRACK = 1024;
    private static final CallMapper<CustomMethodHandler> CUSTOM_METHOD_HANDLERS = new CallMapper<CustomMethodHandler>().register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf"), (args, memState, factory) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.STRING_LENGTH)).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "indexOf", "lastIndexOf"), (args, memState, factory) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("int"), (args, memState, factory) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("long"), (args, memState, factory) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory, true)).register(DfaOptionalSupport.OPTIONAL_OF_NULLABLE, (args, memState, factory) -> CustomMethodHandlers.ofNullable(args.myArguments[0], memState, factory));

    CustomMethodHandlers() {
    }

    public static CustomMethodHandler find(PsiMethod method) {
        CustomMethodHandler handler = null;
        if (CustomMethodHandlers.isConstantCall(method)) {
            handler = (args, memState, factory) -> CustomMethodHandlers.handleConstantCall(args, memState, factory, method);
        }
        CustomMethodHandler handler2 = CUSTOM_METHOD_HANDLERS.mapFirst(method);
        return handler == null ? handler2 : handler.compose(handler2);
    }

    @Contract(value="null -> false")
    private static boolean isConstantCall(PsiMethod method) {
        return CONSTANT_CALLS.methodMatches(method);
    }

    @Nullable
    private static DfaValue handleConstantCall(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory, PsiMethod method) {
        Object result;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Object qualifierValue = null;
        if (!method.hasModifierProperty("static") && (qualifierValue = CustomMethodHandlers.getConstantValue(state, arguments.myQualifier)) == null) {
            return null;
        }
        for (DfaValue argument : arguments.myArguments) {
            long longValue;
            Object argumentValue = CustomMethodHandlers.getConstantValue(state, argument);
            if (argumentValue == null) {
                return null;
            }
            if (argumentValue instanceof Long && (longValue = ((Long)argumentValue).longValue()) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                argumentValue = (int)longValue;
            }
            args.add(argumentValue);
        }
        Method jvmMethod = CustomMethodHandlers.toJvmMethod(method);
        if (jvmMethod == null) {
            return null;
        }
        try {
            result = jvmMethod.invoke(qualifierValue, args.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
        return factory.getConstFactory().createFromValue(result, returnType);
    }

    private static Method toJvmMethod(final PsiMethod method) {
        return (Method)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<Method>(){

            @NotNull
            public CachedValueProvider.Result<Method> compute() {
                Method reflection = this.getMethod();
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)reflection, (Object[])new Object[]{method});
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result;
            }

            private Class<?> toJvmType(PsiType type2) {
                if (TypeUtils.isJavaLangString(type2)) {
                    return String.class;
                }
                if (TypeUtils.isJavaLangObject(type2)) {
                    return Object.class;
                }
                if (TypeUtils.typeEquals("java.lang.CharSequence", type2)) {
                    return CharSequence.class;
                }
                if (PsiType.INT.equals((Object)type2)) {
                    return Integer.TYPE;
                }
                if (PsiType.BOOLEAN.equals((Object)type2)) {
                    return Boolean.TYPE;
                }
                if (PsiType.CHAR.equals((Object)type2)) {
                    return Character.TYPE;
                }
                if (PsiType.LONG.equals((Object)type2)) {
                    return Long.TYPE;
                }
                if (PsiType.FLOAT.equals((Object)type2)) {
                    return Float.TYPE;
                }
                if (PsiType.DOUBLE.equals((Object)type2)) {
                    return Double.TYPE;
                }
                return null;
            }

            @Nullable
            private Method getMethod() {
                Class<?> containingClass;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return null;
                }
                try {
                    containingClass = Class.forName(aClass.getQualifiedName());
                }
                catch (ClassNotFoundException ignored) {
                    return null;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                Class[] parameterTypes = new Class[parameters2.length];
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter parameter2 = parameters2[i];
                    PsiType type2 = parameter2.getType();
                    Class<?> jvmType = this.toJvmType(type2);
                    if (jvmType == null) {
                        return null;
                    }
                    parameterTypes[i] = jvmType;
                }
                return ReflectionUtil.getMethod(containingClass, (String)method.getName(), (Class[])parameterTypes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CustomMethodHandlers$1", "compute"));
            }
        });
    }

    private static DfaValue indexOf(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory, SpecialField specialField) {
        DfaValue length = specialField.createValue(factory, qualifier);
        LongRangeSet range = memState.getValueFact(length, DfaFactType.RANGE);
        long maxLen = range == null || range.isEmpty() ? Integer.MAX_VALUE : range.max();
        return factory.getFactValue(DfaFactType.RANGE, LongRangeSet.range(-1L, maxLen - 1L));
    }

    private static DfaValue ofNullable(DfaValue argument, DfaMemoryState state, DfaValueFactory factory) {
        if (state.isNull(argument)) {
            return DfaOptionalSupport.getOptionalValue(factory, false);
        }
        if (state.isNotNull(argument)) {
            return DfaOptionalSupport.getOptionalValue(factory, true);
        }
        return null;
    }

    private static DfaValue mathAbs(DfaValue[] args, DfaMemoryState memState, DfaValueFactory factory, boolean isLong) {
        DfaValue arg = (DfaValue)ArrayUtil.getFirstElement((Object[])args);
        if (arg == null) {
            return null;
        }
        LongRangeSet range = memState.getValueFact(arg, DfaFactType.RANGE);
        if (range == null) {
            return null;
        }
        return factory.getFactValue(DfaFactType.RANGE, range.abs(isLong));
    }

    private static Object getConstantValue(DfaMemoryState memoryState, DfaValue value2) {
        LongRangeSet fact;
        if (value2 != null && (fact = memoryState.getValueFact(value2, DfaFactType.RANGE)) != null && !fact.isEmpty() && fact.min() == fact.max()) {
            return fact.min();
        }
        DfaConstValue dfaConst = memoryState.getConstantValue(value2);
        if (dfaConst != null) {
            Object constant = dfaConst.getValue();
            if (constant instanceof String && ((String)constant).length() > 1024) {
                return null;
            }
            return constant;
        }
        return null;
    }

    static interface CustomMethodHandler {
        @Nullable
        public DfaValue getMethodResult(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3);

        default public CustomMethodHandler compose(CustomMethodHandler other) {
            if (other == null) {
                return this;
            }
            return (args, memState, factory) -> {
                DfaValue result = this.getMethodResult(args, memState, factory);
                return result == null ? other.getMethodResult(args, memState, factory) : result;
            };
        }
    }
}

