/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance(DfaMemoryStateImpl.class);
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final MyIdMap myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final DistinctPairSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private boolean myEphemeral;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new DistinctPairSet(this);
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap();
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new DistinctPairSet(this, toCopy.myDistinctClasses);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = (MyIdMap)toCopy.myIdToEqClassesIndices.clone();
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        return dfaMemoryStateImpl;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        for (DfaVariableValue value2 : new ArrayList<DfaVariableValue>(copy.myVariableStates.keySet())) {
            copy.dropFact(value2, DfaFactType.LOCALITY);
        }
        copy.flushFields();
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.myEphemeral == that.myEphemeral && this.myStack.equals(that.myStack) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs()) && this.myVariableStates.equals(that.myVariableStates);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    DistinctPairSet getDistinctClassPairs() {
        return this.myDistinctClasses;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = ((this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode()) * 31 + this.myVariableStates.hashCode();
        this.myCachedHash = hash;
        return this.myCachedHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<');
        if (this.myEphemeral) {
            result.append("ephemeral, ");
        }
        for (EqClass set : this.getNonTrivialEqClasses()) {
            result.append(set);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of((Collection)this.getDistinctClassPairs()).map(DistinctPairSet.DistinctPair::toString).sorted()).joining((CharSequence)" ");
            result.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result.append("\n  vars: ");
            this.myVariableStates.forEach((key2, value2) -> result.append("[").append(key2).append("->").append(value2).append("] "));
        }
        result.append('>');
        return result.toString();
    }

    @Override
    @NotNull
    public DfaValue pop() {
        this.myCachedHash = null;
        DfaValue dfaValue = (DfaValue)this.myStack.pop();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue peek() {
        DfaValue dfaValue = (DfaValue)this.myStack.peek();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    @Override
    @Nullable
    public DfaValue getStackValue(int offset) {
        int index = this.myStack.size() - 1 - offset;
        return index < 0 ? null : (DfaValue)this.myStack.get(index);
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myCachedHash = null;
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleStackValueOnVariableFlush(value2, var, null);
        this.flushVariable(var);
        this.flushQualifiedMethods(var);
        if (value2 instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNotNull());
            return;
        }
        DfaVariableState state = this.getVariableState(var).withValue(value2);
        if (value2 instanceof DfaFactMapValue) {
            this.setVariableState(var, state.withFacts(((DfaFactMapValue)value2).getFacts()));
        } else if (DfaUtil.isComparedByEquals(value2.getType()) && !DfaUtil.isComparedByEquals(var.getType())) {
            TypeConstraint typeConstraint = TypeConstraint.empty().withInstanceofValue(this.myFactory.createDfaType(value2.getType()));
            this.setVariableState(var, this.createVariableState(var).withFacts(this.getFactMap(value2).with(DfaFactType.TYPE_CONSTRAINT, typeConstraint)));
        } else {
            this.setVariableState(var, this.isNull(value2) ? state.withFact(DfaFactType.NULLABILITY, DfaNullability.NULLABLE) : state);
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.EQ, value2);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value2 instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value2));
            }
        }
        this.updateEqClassesByState(var);
    }

    private DfaValue handleStackValueOnVariableFlush(DfaValue value2, DfaVariableValue flushed, DfaVariableValue replacement) {
        if (value2 instanceof DfaVariableValue && (value2 == flushed || flushed.getDependentVariables().contains(value2))) {
            DfaNullability dfaNullability;
            DfaVariableValue target;
            if (replacement != null && (target = DfaMemoryStateImpl.replaceQualifier((DfaVariableValue)value2, flushed, replacement)) != value2) {
                return target;
            }
            DfaNullability dfaNullability2 = dfaNullability = this.isNotNull(value2) ? DfaNullability.NOT_NULL : this.getValueFact(value2, DfaFactType.NULLABILITY);
            if (dfaNullability == null) {
                dfaNullability = DfaNullability.fromNullability(((DfaVariableValue)value2).getInherentNullability());
            }
            return this.myFactory.withFact(this.myFactory.createTypeValue(value2.getType(), Nullability.UNKNOWN), DfaFactType.NULLABILITY, dfaNullability);
        }
        return value2;
    }

    @Nullable(value="for non-variables and non-constants which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        int i;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        if ((i = this.getEqClassIndex(dfaValue)) != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue)) {
            return null;
        }
        dfaValue = this.canonicalize(dfaValue);
        EqClass eqClass = new EqClass(this.myFactory);
        eqClass.add(dfaValue.getID());
        int resultIndex = this.storeClass(eqClass);
        this.checkInvariants();
        return resultIndex;
    }

    private int storeClass(EqClass eqClass) {
        int resultIndex;
        int freeIndex = this.myEqClasses.indexOf(null);
        int n = resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, eqClass);
        } else {
            this.myEqClasses.add(eqClass);
        }
        eqClass.forEach(id -> {
            this.myIdToEqClassesIndices.put(id, resultIndex);
            return true;
        });
        return resultIndex;
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (this.myEphemeral && !that.myEphemeral) {
            return false;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return false;
        }
        for (int i = 0; i < this.myStack.size(); ++i) {
            if (DfaMemoryStateImpl.isSuperValue((DfaValue)this.myStack.get(i), (DfaValue)that.myStack.get(i))) continue;
            return false;
        }
        int[] thisToThat = this.getClassesMap(that);
        if (thisToThat == null) {
            return false;
        }
        for (DistinctPairSet.DistinctPair pair : this.myDistinctClasses) {
            int firstIndex = thisToThat[pair.getFirstIndex()];
            int secondIndex = thisToThat[pair.getSecondIndex()];
            if (firstIndex == -1 || secondIndex == -1 || firstIndex == secondIndex) {
                return false;
            }
            DfaRelationValue.RelationType relation = that.myDistinctClasses.getRelation(firstIndex, secondIndex);
            if (relation != null && (!pair.isOrdered() || relation == DfaRelationValue.RelationType.LT)) continue;
            return false;
        }
        HashSet<DfaVariableValue> values = new HashSet<DfaVariableValue>(this.myVariableStates.keySet());
        values.addAll(that.myVariableStates.keySet());
        for (DfaVariableValue value2 : values) {
            DfaVariableState thatState;
            DfaVariableState thisState = this.getVariableState(value2);
            if (thisState.isSuperStateOf(thatState = that.getVariableState(value2))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private int[] getClassesMap(DfaMemoryStateImpl that) {
        List<EqClass> thisClasses = this.myEqClasses;
        List<EqClass> thatClasses = that.myEqClasses;
        int thisSize = thisClasses.size();
        int thatSize = thatClasses.size();
        int[] thisToThat = new int[thisSize];
        for (int thisIdx = 0; thisIdx < thisSize; ++thisIdx) {
            EqClass thisClass = thisClasses.get(thisIdx);
            thisToThat[thisIdx] = -1;
            if (thisClass == null) continue;
            boolean found = false;
            for (int thatIdx = 0; thatIdx < thatSize; ++thatIdx) {
                EqClass thatClass = thatClasses.get(thatIdx);
                if (thatClass == null || !thatClass.containsAll(thisClass)) continue;
                thisToThat[thisIdx] = thatIdx;
                found = true;
                break;
            }
            if (found || thisClass.size() <= 1) continue;
            return null;
        }
        return thisToThat;
    }

    private static boolean isSuperValue(DfaValue superValue, DfaValue subValue) {
        if (superValue == DfaUnknownValue.getInstance() || superValue == subValue) {
            return true;
        }
        if (superValue instanceof DfaFactMapValue && subValue instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)superValue).getFacts().isSuperStateOf(((DfaFactMapValue)subValue).getFacts());
        }
        return false;
    }

    private static boolean canBeInRelation(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(7);
        }
        return value2 instanceof DfaBoxedValue || value2 instanceof DfaVariableValue || value2 instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        List<Object> list = (set = this.getEqClass(dfaValue)) == null ? Collections.emptyList() : set.getMemberValues();
        if (list == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        if (!(dfaValue instanceof DfaVariableValue) || !PsiType.FLOAT.equals((Object)dfaValue.getType()) && !PsiType.DOUBLE.equals((Object)dfaValue.getType())) {
            return false;
        }
        EqClass eqClass = this.getEqClass(dfaValue);
        DfaValue constant = eqClass == null ? null : eqClass.findConstant(false);
        return constant == null || DfaMemoryStateImpl.isNaN(constant);
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        EqClass eqClass;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(11);
        }
        return (eqClass = this.getEqClass(dfaValue)) != null && DfaMemoryStateImpl.isNaN(eqClass.findConstant(false));
    }

    List<EqClass> getEqClasses() {
        return this.myEqClasses;
    }

    @Nullable
    private EqClass getEqClass(DfaValue value2) {
        int index = this.getEqClassIndex(value2);
        return index == -1 ? null : this.myEqClasses.get(index);
    }

    int getEqClassIndex(@NotNull DfaValue dfaValue) {
        Integer classIndex;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(12);
        }
        if ((classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID())) == null) {
            dfaValue = this.canonicalize(dfaValue);
            classIndex = (Integer)this.myIdToEqClassesIndices.get(dfaValue.getID());
        }
        if (classIndex == null) {
            return -1;
        }
        EqClass aClass = this.myEqClasses.get(classIndex);
        assert (aClass.contains(dfaValue.getID()));
        return classIndex;
    }

    DfaVariableValue getCanonicalVariable(DfaValue val) {
        EqClass eqClass = this.getEqClass(val);
        return eqClass == null ? null : eqClass.getCanonicalVariable();
    }

    private boolean uniteClasses(DfaValue val1, DfaValue val2) {
        DfaVariableValue var1 = this.getCanonicalVariable(val1);
        DfaVariableValue var2 = this.getCanonicalVariable(val2);
        Integer c1Index = this.getOrCreateEqClassIndex(val1);
        Integer c2Index = this.getOrCreateEqClassIndex(val2);
        if (c1Index == null || c2Index == null || c1Index.equals(c2Index)) {
            return true;
        }
        if (!this.myDistinctClasses.unite(c1Index, c2Index)) {
            return false;
        }
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        if (c1.findConstant(true) != null && c2.findConstant(true) != null) {
            return false;
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (int i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.myIdToEqClassesIndices.put(c, c1Index);
        }
        this.myEqClasses.set(c2Index, null);
        this.checkInvariants();
        if (var1 == null || var2 == null || var1 == var2) {
            return true;
        }
        int compare = EqClass.CANONICAL_VARIABLE_COMPARATOR.compare(var1, var2);
        return compare < 0 ? this.convertQualifiers(var2, var1) : this.convertQualifiers(var1, var2);
    }

    private static DfaVariableValue replaceQualifier(DfaVariableValue variable, DfaVariableValue from, DfaVariableValue to) {
        DfaVariableValue qualifier = variable.getQualifier();
        if (qualifier != null) {
            return variable.withQualifier(DfaMemoryStateImpl.replaceQualifier(qualifier == from ? to : qualifier, from, to));
        }
        return variable;
    }

    private boolean convertQualifiers(DfaVariableValue from, DfaVariableValue to) {
        assert (from != to);
        if (from.getDependentVariables().isEmpty()) {
            return true;
        }
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableStates.keySet());
        for (DfaVariableValue var : vars) {
            DfaVariableState fromState;
            DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
            if (target == var || (fromState = (DfaVariableState)this.myVariableStates.remove(var)) == null) continue;
            DfaVariableState toState = this.myVariableStates.get(target);
            if (toState == null) {
                toState = fromState;
            } else {
                toState = fromState.intersectMap(toState.myFactMap);
                if (toState == null) {
                    return false;
                }
            }
            this.setVariableState(target, toState);
        }
        for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
            DfaValue value2 = this.myFactory.getValue((int)valueId);
            DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
            if (var == null || var.getQualifier() != from) continue;
            DfaVariableValue target = var.withQualifier(to);
            if (!this.uniteClasses(var, target)) {
                return false;
            }
            this.removeEquivalenceForVariableAndWrappers(var);
        }
        return true;
    }

    private void checkInvariants() {
        if (!LOG.isDebugEnabled() && !ApplicationManager.getApplication().isEAP()) {
            return;
        }
        this.myIdToEqClassesIndices.forEachEntry((id, classIndex) -> {
            EqClass eqClass = this.myEqClasses.get((int)classIndex);
            if (eqClass == null || !eqClass.contains(id)) {
                LOG.error("Invariant violated: null-class for id=" + this.myFactory.getValue(id));
            }
            return true;
        });
        this.myDistinctClasses.forEach(DistinctPairSet.DistinctPair::check);
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaFactMapValue) {
            return DfaNullability.isNotNull(((DfaFactMapValue)dfaVar).getFacts());
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue(dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        Integer c1Index = this.getOrCreateEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index == null || c2Index < 0) {
            return false;
        }
        return this.myDistinctClasses.areDistinctUnordered(c1Index, c2Index);
    }

    public Set<Object> getNonEqualConstants(DfaVariableValue value2) {
        int index = this.getEqClassIndex(value2);
        if (index == -1 || this.myEqClasses.get(index).findConstant(true) != null) {
            return Collections.emptySet();
        }
        return this.getDistinctClassPairs().stream().map(pair -> pair.getOtherClass(index)).filter(Objects::nonNull).map(otherClass -> otherClass.findConstant(true)).filter(Objects::nonNull).map(constant -> ((DfaConstValue)DfaMemoryStateImpl.unwrap(constant)).getValue()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    @Contract(value="null -> null")
    public DfaConstValue getConstantValue(@Nullable DfaValue value2) {
        if (value2 instanceof DfaConstValue) {
            return (DfaConstValue)value2;
        }
        if (value2 instanceof DfaVariableValue) {
            EqClass ec = this.getEqClass(value2);
            return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
        }
        return null;
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean isEmptyStack() {
        return this.myStack.isEmpty();
    }

    @Override
    public boolean castTopOfStack(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        DfaValue value2 = DfaMemoryStateImpl.unwrap(this.peek());
        DfaFactMap facts = null;
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)value2;
            if (this.isNull(dfaVar)) {
                return true;
            }
            DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(type2);
            if (newState == null) {
                return false;
            }
            this.setVariableState(dfaVar, newState);
        } else if (value2 instanceof DfaFactMapValue) {
            facts = ((DfaFactMapValue)value2).getFacts();
        }
        if (facts != null) {
            DfaFactMap newFacts = TypeConstraint.withInstanceOf(facts, type2);
            if (newFacts == null) {
                return false;
            }
            this.pop();
            this.push(this.myFactory.getFactFactory().createValue(newFacts));
        }
        return true;
    }

    private boolean applyFacts(DfaValue value2, DfaFactMap facts) {
        if (value2 instanceof DfaVariableValue) {
            DfaVariableState oldState = this.getVariableState((DfaVariableValue)value2);
            DfaVariableState newState = oldState.intersectMap(facts);
            if (newState == null) {
                newState = oldState.withoutFact(DfaFactType.TYPE_CONSTRAINT);
                if (newState.intersectMap(facts) != null && DfaNullability.isNotNull(facts)) {
                    this.setVariableState((DfaVariableValue)value2, newState);
                    return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), false);
                }
                return false;
            }
            this.setVariableState((DfaVariableValue)value2, newState);
            if (DfaUtil.isComparedByEquals(newState.getTypeConstraint().getPsiType()) && !newState.getTypeConstraint().equals(oldState.getTypeConstraint())) {
                this.convertReferenceEqualityToValueEquality(value2);
            }
            this.updateEquivalentVariables((DfaVariableValue)value2, newState);
            return this.updateEqClassesByState((DfaVariableValue)value2);
        }
        return true;
    }

    private void convertReferenceEqualityToValueEquality(DfaValue value2) {
        int id = this.canonicalize(value2).getID();
        Integer index = (Integer)this.myIdToEqClassesIndices.get(id);
        assert (index != null);
        Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
        while (iterator.hasNext()) {
            DistinctPairSet.DistinctPair pair = iterator.next();
            EqClass otherClass = pair.getOtherClass(index);
            if (otherClass == null || otherClass.findConstant(false) == this.getFactory().getConstFactory().getNull()) continue;
            iterator.remove();
        }
    }

    private boolean updateEqClassesByState(DfaVariableValue value2) {
        if (DfaNullability.isNotNull(this.getVariableState((DfaVariableValue)value2).myFactMap)) {
            return this.applyRelation(value2, this.getFactory().getConstFactory().getNull(), true);
        }
        return true;
    }

    @Override
    public void dropFact(@NotNull DfaValue value2, @NotNull DfaFactType<?> factType) {
        DfaVariableValue var;
        DfaVariableState state;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        if (value2 instanceof DfaVariableValue && (state = this.getExistingVariableState(var = (DfaVariableValue)value2)) != null) {
            state = state.withoutFact(factType);
            this.setVariableState(var, state);
        }
    }

    @Override
    public <T> boolean applyFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType, @Nullable T factValue) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).getFacts().intersect(factType, factValue) != null;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value2;
            if (factValue != null) {
                DfaVariableState state = this.getVariableState(var);
                DfaVariableState newState = state.intersectFact(factType, factValue);
                if (newState == null) {
                    return false;
                }
                this.setVariableState(var, newState);
                this.updateEquivalentVariables(var, newState);
                return this.updateEqClassesByState(var);
            }
        }
        return true;
    }

    static DfaValue unwrap(DfaValue value2) {
        if (value2 instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value2).getWrappedValue();
        }
        return value2;
    }

    @Override
    public boolean applyContractCondition(DfaValue condition2) {
        DfaRelationValue relation;
        if (condition2 instanceof DfaRelationValue && (relation = (DfaRelationValue)condition2).isEquality() && relation.getRightOperand() == this.myFactory.getConstFactory().getNull() && (relation.getLeftOperand() instanceof DfaUnknownValue || relation.getLeftOperand() instanceof DfaVariableValue && this.getVariableState((DfaVariableValue)relation.getLeftOperand()).getNullability() == Nullability.UNKNOWN)) {
            this.markEphemeral();
        }
        return this.applyCondition(condition2);
    }

    @Override
    public boolean areEqual(@NotNull DfaValue value1, @NotNull DfaValue value2) {
        if (value1 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (!(value1 instanceof DfaConstValue) && !(value1 instanceof DfaVariableValue)) {
            return false;
        }
        if (!(value2 instanceof DfaConstValue) && !(value2 instanceof DfaVariableValue)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        int index1 = this.getEqClassIndex(value1);
        int index2 = this.getEqClassIndex(value2);
        return index1 != -1 && index1 == index2;
    }

    @Nullable
    private DfaRelationValue.RelationType getRelation(DfaValue left, DfaValue right) {
        int leftClass = this.getEqClassIndex(left);
        int rightClass = this.getEqClassIndex(right);
        if (leftClass == -1 || rightClass == -1) {
            return null;
        }
        if (leftClass == rightClass) {
            return DfaRelationValue.RelationType.EQ;
        }
        return this.myDistinctClasses.getRelation(leftClass, rightClass);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            DfaValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            if (dfaVar.getSource() == SpecialField.UNBOX) {
                dfaVar = dfaVar.getQualifier();
                dfaTrue = this.myFactory.getBoxedFactory().createBoxed(dfaTrue, null);
            }
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaVar, DfaRelationValue.RelationType.EQ, dfaTrue));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        DfaRelationValue.RelationType relationType = dfaRelation.getRelation();
        DfaConstValue sentinel = this.getFactory().getConstFactory().getSentinel();
        if (dfaLeft == sentinel || dfaRight == sentinel) {
            assert (relationType == DfaRelationValue.RelationType.EQ || relationType == DfaRelationValue.RelationType.NE);
            return dfaLeft == dfaRight == (relationType == DfaRelationValue.RelationType.EQ);
        }
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        LongRangeSet left = this.getValueFact(dfaLeft, DfaFactType.RANGE);
        LongRangeSet right = this.getValueFact(dfaRight, DfaFactType.RANGE);
        if (!(left == null || right == null || this.applyFact(dfaLeft, DfaFactType.RANGE, right.fromRelation(relationType)) && this.applyFact(dfaRight, DfaFactType.RANGE, left.fromRelation(relationType.getFlipped())))) {
            return false;
        }
        if (dfaRight instanceof DfaFactMapValue) {
            DfaFactMapValue factValue = (DfaFactMapValue)dfaRight;
            if ((relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) && DfaNullability.isNotNull(factValue.getFacts()) && !this.applyRelation(dfaLeft, this.getFactory().getConstFactory().getNull(), true)) {
                return false;
            }
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                switch (relationType) {
                    case IS: {
                        return this.applyFacts(dfaVar, factValue.getFacts());
                    }
                    case IS_NOT: {
                        Boolean optionalPresence = factValue.get(DfaFactType.OPTIONAL_PRESENCE);
                        if (optionalPresence != null) {
                            return this.applyFact(dfaVar, DfaFactType.OPTIONAL_PRESENCE, optionalPresence == false);
                        }
                        boolean isNotNull = DfaNullability.isNotNull(factValue.getFacts());
                        TypeConstraint constraint = factValue.get(DfaFactType.TYPE_CONSTRAINT);
                        if (constraint != null && constraint.getNotInstanceofValues().isEmpty()) {
                            DfaVariableState state = this.getVariableState(dfaVar);
                            for (DfaPsiType type2 : constraint.getInstanceofValues()) {
                                if ((state = state.withNotInstanceofValue(type2)) == null) {
                                    return isNotNull && !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                                }
                                this.setVariableState(dfaVar, state);
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
            if (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.EQ) {
                return this.getFactMap(dfaLeft).intersect(factValue.getFacts()) != null;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
            return relationType == DfaRelationValue.RelationType.NE;
        }
        if (this.canBeNaN(dfaLeft) && !this.isNull(dfaRight) || this.canBeNaN(dfaRight) && !this.isNull(dfaLeft)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(dfaLeft.getType() instanceof PsiPrimitiveType)) {
                return !dfaRelation.isNonEquality();
            }
            this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value2, boolean isNegated) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(21);
        }
        if (!(dfaVar.getType() instanceof PsiPrimitiveType)) {
            if (isNegated) {
                if (this.isNull(value2)) {
                    this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.NULLABILITY, DfaNullability.NOT_NULL));
                }
            } else {
                if (value2 instanceof DfaConstValue) {
                    Object constValue = ((DfaConstValue)value2).getValue();
                    if (constValue == null) {
                        this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.NULLABILITY, DfaNullability.NULLABLE));
                        return;
                    }
                    DfaPsiType dfaType = this.myFactory.createDfaType(((DfaConstValue)value2).getType());
                    DfaVariableState state = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
                    if (state != null) {
                        this.setVariableState(dfaVar, state);
                    }
                }
                if (this.isNotNull(value2) && !this.isNotNull(dfaVar)) {
                    this.setVariableState(dfaVar, this.getVariableState(dfaVar).withoutFact(DfaFactType.NULLABILITY));
                    this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
                }
            }
        }
    }

    private boolean applyEquivalenceRelation(DfaRelationValue.RelationType type2, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean isNegated;
        boolean bl = isNegated = type2 == DfaRelationValue.RelationType.NE || type2 == DfaRelationValue.RelationType.GT || type2 == DfaRelationValue.RelationType.LT;
        if (!isNegated && type2 != DfaRelationValue.RelationType.EQ) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return !isNegated || dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight, isNegated);
        }
        if (dfaRight instanceof DfaVariableValue) {
            this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft, isNegated);
        }
        if (type2 == DfaRelationValue.RelationType.LT) {
            if (!this.applyLessThanRelation(dfaLeft, dfaRight)) {
                return false;
            }
        } else if (type2 == DfaRelationValue.RelationType.GT) {
            if (!this.applyLessThanRelation(dfaRight, dfaLeft)) {
                return false;
            }
        } else {
            if (!isNegated && !this.applyDependentFieldsEquivalence(dfaLeft, dfaRight)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        return this.applyUnboxedRelation(dfaLeft, dfaRight, isNegated);
    }

    @NotNull
    private List<Couple<DfaValue>> getDependentPairs(DfaValue left, DfaValue right) {
        StreamEx stream = StreamEx.empty();
        if (left instanceof DfaVariableValue && right instanceof DfaConstValue) {
            stream = (StreamEx)stream.append((Stream)((StreamEx)StreamEx.of(new ArrayList<DfaVariableValue>(((DfaVariableValue)left).getDependentVariables())).filter(leftVar -> leftVar.getQualifier() == left && leftVar.getSource() == SpecialField.STRING_LENGTH)).map(leftVar -> Couple.of((Object)leftVar, (Object)((SpecialField)leftVar.getSource()).createValue(this.myFactory, right))));
        }
        if (right instanceof DfaVariableValue && left instanceof DfaConstValue) {
            stream = (StreamEx)stream.append((Stream)((StreamEx)StreamEx.of(new ArrayList<DfaVariableValue>(((DfaVariableValue)right).getDependentVariables())).filter(rightVar -> rightVar.getQualifier() == right && rightVar.getSource() == SpecialField.STRING_LENGTH)).map(rightVar -> Couple.of((Object)((SpecialField)rightVar.getSource()).createValue(this.myFactory, left), (Object)rightVar)));
        }
        List list = ((StreamEx)stream.distinct()).toList();
        if (list == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    private boolean applyDependentFieldsEquivalence(@NotNull DfaValue left, @NotNull DfaValue right) {
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        if (right == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(24);
        }
        List<Couple<DfaValue>> pairs = this.getDependentPairs(left, right);
        for (Couple<DfaValue> pair : pairs) {
            if (this.applyCondition(this.myFactory.createCondition((DfaValue)pair.getFirst(), DfaRelationValue.RelationType.EQ, (DfaValue)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean applyUnboxedRelation(@NotNull DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        if (!(dfaLeft instanceof DfaBoxedValue) && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaLeft.getType()) || !(dfaRight instanceof DfaBoxedValue) && !TypeConversionUtil.isPrimitiveWrapper((PsiType)dfaRight.getType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft, null);
        DfaValue unboxedRight = boxedFactory.createUnboxed(dfaRight, null);
        if (negated && (PsiType.FLOAT.equals((Object)unboxedLeft.getType()) || PsiType.DOUBLE.equals((Object)unboxedLeft.getType()))) {
            return true;
        }
        return this.applyRelation(unboxedLeft, unboxedRight, negated);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            boolean boolValue = (Boolean)constVal;
            return this.applyRelation(dfaLeft, this.myFactory.getBoolean(!boolValue), !negated) && this.applyRelation(dfaLeft, this.myFactory.getBoolean(boolValue), negated);
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        return dfa instanceof DfaConstValue && DfaUtil.isNaN(((DfaConstValue)dfa).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        ThreeState equalByConstants = this.equalByConstant(c1Index, c2Index);
        if (equalByConstants != ThreeState.UNSURE) {
            return equalByConstants.toBoolean() != isNegated;
        }
        if (!isNegated) {
            if (this.isUnstableValue(dfaLeft) || this.isUnstableValue(dfaRight)) {
                return true;
            }
            if (!this.uniteClasses(dfaLeft, dfaRight)) {
                return false;
            }
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator.next();
                DfaConstValue const1 = (DfaConstValue)pair.getFirst().findConstant(false);
                DfaConstValue const2 = (DfaConstValue)pair.getSecond().findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                iterator.remove();
            }
            this.myCachedNonTrivialEqClasses = null;
        } else {
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            if (this.applyBooleanInequality(dfaLeft, dfaRight) || this.applyBooleanInequality(dfaRight, dfaLeft)) {
                return true;
            }
            this.myDistinctClasses.addUnordered(c1Index, c2Index);
        }
        this.myCachedHash = null;
        return true;
    }

    private boolean applyBooleanInequality(DfaValue var, DfaValue value2) {
        if (!(var instanceof DfaVariableValue) || !PsiType.BOOLEAN.equals((Object)var.getType()) || ((DfaVariableValue)var).getSource() == SpecialField.UNBOX) {
            return false;
        }
        if (!(value2 instanceof DfaConstValue)) {
            return false;
        }
        Boolean constValue = (Boolean)ObjectUtils.tryCast((Object)((DfaConstValue)value2).getValue(), Boolean.class);
        return constValue != null && this.applyRelation(var, this.myFactory.getBoolean(constValue == false), false);
    }

    private boolean applyLessThanRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        ThreeState equalByConstants = this.equalByConstant(c1Index, c2Index);
        if (equalByConstants != ThreeState.UNSURE) {
            return !equalByConstants.toBoolean();
        }
        if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
            return true;
        }
        this.myCachedHash = null;
        return this.myDistinctClasses.addOrdered(c1Index, c2Index);
    }

    private boolean isUnstableValue(DfaValue value2) {
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)value2;
        PsiModifierListOwner owner2 = var.getPsiVariable();
        if (!(owner2 instanceof PsiMethod)) {
            return false;
        }
        if (var.getType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)owner2))) {
            return false;
        }
        return !this.isNull(var);
    }

    private static boolean isPrimitive(DfaValue value2) {
        return value2 instanceof DfaVariableValue && value2.getType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiVariable || c2 == null && c1 instanceof PsiVariable;
    }

    @NotNull
    private ThreeState equalByConstant(int i1, int i2) {
        if (i1 == i2) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(30);
            }
            return threeState;
        }
        EqClass ec1 = this.myEqClasses.get(i1);
        EqClass ec2 = this.myEqClasses.get(i2);
        if (ec1 == null || ec2 == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(31);
            }
            return threeState;
        }
        DfaValue constOrBox1 = ec1.findConstant(true);
        DfaValue constOrBox2 = ec2.findConstant(true);
        if (constOrBox1 == null || constOrBox2 == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(32);
            }
            return threeState;
        }
        if (constOrBox1 instanceof DfaConstValue && constOrBox2 instanceof DfaConstValue) {
            ThreeState threeState = DfaMemoryStateImpl.areConstantsEqual((DfaConstValue)constOrBox1, (DfaConstValue)constOrBox2);
            if (threeState == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(33);
            }
            return threeState;
        }
        if (constOrBox1 instanceof DfaBoxedValue && constOrBox2 instanceof DfaBoxedValue) {
            DfaValue wrapped1 = ((DfaBoxedValue)constOrBox1).getWrappedValue();
            DfaValue wrapped2 = ((DfaBoxedValue)constOrBox2).getWrappedValue();
            if (wrapped1 instanceof DfaConstValue && wrapped2 instanceof DfaConstValue && DfaMemoryStateImpl.areConstantsEqual((DfaConstValue)wrapped1, (DfaConstValue)wrapped2) == ThreeState.NO) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(34);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(35);
        }
        return threeState;
    }

    private static ThreeState areConstantsEqual(DfaConstValue const1, DfaConstValue const2) {
        Number value1 = (Number)ObjectUtils.tryCast((Object)const1.getValue(), Number.class);
        Number value2 = (Number)ObjectUtils.tryCast((Object)const2.getValue(), Number.class);
        if (value1 == null || value2 == null) {
            return ThreeState.UNSURE;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            return ThreeState.fromBoolean((boolean)value1.equals(value2));
        }
        return ThreeState.fromBoolean((value1.doubleValue() == value2.doubleValue() ? 1 : 0) != 0);
    }

    @Override
    public boolean checkNotNullable(DfaValue value2) {
        if (value2 == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value2 instanceof DfaFactMapValue && DfaNullability.isNullable(((DfaFactMapValue)value2).getFacts())) {
            return false;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value2;
            if (varValue.getType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            return this.getVariableState(varValue).getNullability() != Nullability.NULLABLE;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getValueFact(@NotNull DfaValue value2, @NotNull DfaFactType<T> factType) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(36);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(37);
        }
        if (value2 instanceof DfaVariableValue) {
            T fact;
            DfaVariableValue var = (DfaVariableValue)value2;
            DfaVariableState state = this.getExistingVariableState(var);
            if (state != null && (fact = state.getFact(factType)) != null) {
                return fact;
            }
            value2 = this.resolveVariableValue(var);
        }
        return factType.fromDfaValue(value2);
    }

    @Override
    public <T> void forceVariableFact(@NotNull DfaVariableValue var, @NotNull DfaFactType<T> factType, @Nullable T value2) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(38);
        }
        if (factType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(39);
        }
        DfaVariableState state = this.getVariableState(var);
        this.removeEquivalenceForVariableAndWrappers(var);
        this.setVariableState(var, state.withFact(factType, value2));
        this.updateEqClassesByState(var);
    }

    @NotNull
    private DfaValue resolveVariableValue(DfaVariableValue var) {
        DfaConstValue constValue = this.getConstantValue(var);
        if (constValue != null) {
            DfaConstValue dfaConstValue = constValue;
            if (dfaConstValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(40);
            }
            return dfaConstValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(41);
        }
        return dfaVariableValue;
    }

    DfaFactMap getFactMap(@NotNull DfaValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(42);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableState state = this.getExistingVariableState((DfaVariableValue)value2);
            if (state != null) {
                return state.myFactMap;
            }
            value2 = this.resolveVariableValue((DfaVariableValue)value2);
        }
        return DfaFactMap.fromDfaValue(value2);
    }

    void setVariableState(@NotNull DfaVariableValue dfaVar, @NotNull DfaVariableState state) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(43);
        }
        if (state == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(44);
        }
        if (state.equals(this.getDefaultState(dfaVar = this.canonicalize(dfaVar)))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    protected void updateEquivalentVariables(DfaVariableValue dfaVar, DfaVariableState state) {
        EqClass eqClass = this.getEqClass(dfaVar);
        if (eqClass != null) {
            for (DfaValue value2 : eqClass.getMemberValues()) {
                if (value2 == dfaVar || !(value2 instanceof DfaVariableValue)) continue;
                this.setVariableState((DfaVariableValue)value2, state);
            }
        }
    }

    @NotNull
    private DfaValue canonicalize(@NotNull DfaValue value2) {
        DfaBoxedValue boxedValue;
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(45);
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue dfaVariableValue = this.canonicalize((DfaVariableValue)value2);
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(46);
            }
            return dfaVariableValue;
        }
        if (value2 instanceof DfaBoxedValue && (boxedValue = (DfaBoxedValue)value2).getWrappedValue() instanceof DfaVariableValue) {
            DfaValue canonicalized = this.canonicalize(boxedValue.getWrappedValue());
            DfaValue dfaValue = Objects.requireNonNull(this.myFactory.getBoxedFactory().createBoxed(canonicalized, boxedValue.getType()));
            if (dfaValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(47);
            }
            return dfaValue;
        }
        if (value2 instanceof DfaConstValue) {
            Object constant = ((DfaConstValue)value2).getValue();
            if (Double.valueOf(-0.0).equals(constant)) {
                DfaConstValue dfaConstValue = this.myFactory.getConstFactory().createFromValue(0.0, (PsiType)PsiType.DOUBLE);
                if (dfaConstValue == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(48);
                }
                return dfaConstValue;
            }
        }
        DfaValue dfaValue = value2;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(49);
        }
        return dfaValue;
    }

    @NotNull
    private DfaVariableValue canonicalize(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            EqClass eqClass = this.getEqClass(qualifier);
            DfaVariableValue dfaVariableValue = var.withQualifier(eqClass == null ? this.canonicalize(qualifier) : Objects.requireNonNull(eqClass.getCanonicalVariable()));
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(50);
            }
            return dfaVariableValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(51);
        }
        return dfaVariableValue;
    }

    private DfaVariableState getExistingVariableState(DfaVariableValue var) {
        DfaVariableState state = this.myVariableStates.get(var);
        if (state != null) {
            return state;
        }
        DfaVariableValue canonicalized = this.canonicalize(var);
        return canonicalized == var ? null : this.myVariableStates.get(canonicalized);
    }

    @NotNull
    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.getExistingVariableState(dfaVar);
        DfaVariableState dfaVariableState = state != null ? state : this.getDefaultState(dfaVar);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(52);
        }
        return dfaVariableState;
    }

    @NotNull
    private DfaVariableState getDefaultState(DfaVariableValue dfaVar) {
        DfaVariableState dfaVariableState = this.myDefaultVariableStates.computeIfAbsent(dfaVar, this::createVariableState);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(53);
        }
        return dfaVariableState;
    }

    void forVariableStates(BiConsumer<? super DfaVariableValue, ? super DfaVariableState> consumer) {
        this.myVariableStates.forEach(consumer);
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(54);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(55);
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value2 : vars) {
            DfaVariableValue qualifier;
            if (!value2.isFlushableByCalls() || (qualifier = value2.getQualifier()) != null && (this.getValueFact(qualifier, DfaFactType.MUTABILITY) == Mutability.UNMODIFIABLE || Boolean.TRUE.equals(this.getValueFact(qualifier, DfaFactType.LOCALITY)))) continue;
            this.doFlush(value2, this.shouldMarkFlushed(value2));
        }
    }

    private boolean shouldMarkFlushed(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(56);
        }
        if (value2.getInherentNullability() != Nullability.NULLABLE) {
            return false;
        }
        return this.getVariableState(value2).getFact(DfaFactType.NULLABILITY) == DfaNullability.FLUSHED || this.isNull(value2) || this.isNotNull(value2);
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set = this.myVariableStates.keySet();
        if (set == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(57);
        }
        return set;
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(58);
        }
        EqClass eqClass = variable.getDependentVariables().isEmpty() ? null : this.getEqClass(variable);
        DfaVariableValue newCanonical = eqClass == null ? null : (DfaVariableValue)StreamEx.of(eqClass.getVariables(false)).without((Object)variable).min(EqClass.CANONICAL_VARIABLE_COMPARATOR).orElse(null);
        this.myStack.replaceAll(value2 -> {
            if (variable == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(65);
            }
            return this.handleStackValueOnVariableFlush((DfaValue)value2, variable, newCanonical);
        });
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(59);
        }
        for (DfaVariableValue dependent : variable.getDependentVariables().toArray(new DfaVariableValue[0])) {
            this.doFlush(dependent, false);
        }
    }

    private void flushQualifiedMethods(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(60);
        }
        PsiModifierListOwner psiVariable = variable.getPsiVariable();
        DfaVariableValue qualifier = variable.getQualifier();
        if (psiVariable instanceof PsiField && qualifier != null) {
            List<DfaVariableValue> toFlush = qualifier.getDependentVariables().stream().filter(DfaVariableValue::containsCalls).collect(Collectors.toList());
            toFlush.forEach(val -> this.doFlush((DfaVariableValue)val, this.shouldMarkFlushed((DfaVariableValue)val)));
        }
    }

    void doFlush(@NotNull DfaVariableValue var, boolean markFlushed) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(61);
        }
        if (this.isNull(var)) {
            this.myStack.replaceAll(val -> {
                if (var == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(64);
                }
                return val == var ? this.myFactory.getConstFactory().getNull() : val;
            });
        }
        this.removeEquivalenceForVariableAndWrappers(var);
        this.myVariableStates.remove(var);
        if (markFlushed) {
            this.setVariableState(var, this.getVariableState(var).withFact(DfaFactType.NULLABILITY, DfaNullability.FLUSHED));
        }
        this.myCachedHash = null;
    }

    private void removeEquivalence(DfaValue var) {
        int varID = var.getID();
        Integer varClassIndex = (Integer)this.myIdToEqClassesIndices.get(varID);
        if (varClassIndex == null) {
            return;
        }
        EqClass varClass = this.myEqClasses.get(varClassIndex);
        varClass = new EqClass(varClass);
        DfaVariableValue previousCanonical = varClass.getCanonicalVariable();
        this.myEqClasses.set(varClassIndex, varClass);
        varClass.removeValue(varID);
        this.myIdToEqClassesIndices.remove(varID);
        this.checkInvariants();
        if (varClass.isEmpty()) {
            this.myEqClasses.set(varClassIndex, null);
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator.next();
                if (pair.getOtherClass(varClassIndex) == null) continue;
                iterator.remove();
            }
        } else if (varClass.containsConstantsOnly()) {
            Iterator<DistinctPairSet.DistinctPair> iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator.next();
                EqClass other = pair.getOtherClass(varClassIndex);
                if (other == null || !other.containsConstantsOnly()) continue;
                iterator.remove();
            }
        } else {
            DfaVariableValue newCanonical = varClass.getCanonicalVariable();
            if (newCanonical != null && previousCanonical != null && previousCanonical != newCanonical && newCanonical.getDepth() <= previousCanonical.getDepth()) {
                boolean successfullyConverted = this.convertQualifiers(previousCanonical, newCanonical);
                assert (successfullyConverted);
            }
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
    }

    void removeEquivalenceForVariableAndWrappers(@NotNull DfaVariableValue var) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(62);
        }
        this.removeEquivalence(var);
        DfaValue wrapped = this.myFactory.getBoxedFactory().getBoxedIfExists(var);
        if (wrapped != null) {
            this.removeEquivalence(wrapped);
        }
    }

    Object getMergeabilityKey() {
        return StreamEx.of(this.myStack).mapLastOrElse(val -> (DfaControlTransferValue)ObjectUtils.tryCast((Object)val, DfaControlTransferValue.class), Function.identity()).append((Object)this.isEphemeral()).toImmutableList();
    }

    void merge(DfaMemoryStateImpl other) {
        assert (other.isEphemeral() == this.isEphemeral());
        assert (other.myStack.size() == this.myStack.size());
        ProgressManager.checkCanceled();
        this.retainEquivalences(other);
        this.mergeDistinctPairs(other);
        this.mergeVariableStates(other);
        this.mergeStacks(other);
        this.myCachedHash = null;
        this.myCachedNonTrivialEqClasses = null;
    }

    private void mergeStacks(DfaMemoryStateImpl other) {
        List values = StreamEx.zip(this.myStack, other.myStack, DfaValue::unite).toList();
        this.myStack.clear();
        values.forEach(arg_0 -> this.myStack.push(arg_0));
    }

    private void mergeDistinctPairs(DfaMemoryStateImpl other) {
        ArrayList<DistinctPairSet.DistinctPair> pairs = new ArrayList<DistinctPairSet.DistinctPair>(this.myDistinctClasses);
        for (DistinctPairSet.DistinctPair pair : pairs) {
            EqClass first = pair.getFirst();
            EqClass second = pair.getSecond();
            DfaRelationValue.RelationType relation = other.getRelation(this.myFactory.getValue(first.get(0)), this.myFactory.getValue(second.get(0)));
            if (relation == null || relation == DfaRelationValue.RelationType.EQ) {
                this.myDistinctClasses.remove(pair);
                continue;
            }
            if (!pair.isOrdered() || relation == DfaRelationValue.RelationType.LT) continue;
            this.myDistinctClasses.dropOrder(pair);
        }
    }

    private void mergeVariableStates(DfaMemoryStateImpl other) {
        Set vars = (Set)StreamEx.of((Object[])new LinkedHashMap[]{this.myVariableStates, other.myVariableStates}).toFlatCollection(Map::keySet, HashSet::new);
        for (DfaVariableValue var : vars) {
            DfaVariableState state = this.getVariableState(var);
            DfaVariableState otherState = other.getVariableState(var);
            this.setVariableState(var, state.withFacts(state.myFactMap.unite(otherState.myFactMap)));
        }
    }

    private void retainEquivalences(DfaMemoryStateImpl other) {
        boolean needRestart = true;
        block0: while (needRestart) {
            ProgressManager.checkCanceled();
            needRestart = false;
            for (EqClass eqClass : new ArrayList<EqClass>(this.myEqClasses)) {
                if (eqClass == null || !this.retainEquivalences(eqClass, other)) continue;
                needRestart = true;
                continue block0;
            }
        }
    }

    private boolean retainEquivalences(EqClass eqClass, DfaMemoryStateImpl other) {
        if (eqClass.size() <= 1) {
            return false;
        }
        List<EqClass> groups = this.splitEqClass(eqClass, other);
        if (groups.size() == 1) {
            return false;
        }
        TIntArrayList addedClasses = new TIntArrayList();
        int origIndex = (Integer)this.myIdToEqClassesIndices.get(eqClass.get(0));
        for (EqClass group : groups) {
            addedClasses.add(this.storeClass(group));
        }
        int[] addedClassesArray = addedClasses.toNativeArray();
        this.myDistinctClasses.splitClass(origIndex, addedClassesArray);
        this.myEqClasses.set(origIndex, null);
        DfaVariableValue from = eqClass.getCanonicalVariable();
        boolean otherClassChanged = false;
        if (from != null && !from.getDependentVariables().isEmpty()) {
            ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableStates.keySet());
            for (int classIndex : addedClassesArray) {
                DfaVariableValue to = this.myEqClasses.get(classIndex).getCanonicalVariable();
                if (to == null || to == from || to.getDepth() > from.getDepth()) continue;
                for (DfaVariableValue var : vars) {
                    DfaVariableValue target = DfaMemoryStateImpl.replaceQualifier(var, from, to);
                    if (target == var) continue;
                    this.setVariableState(target, this.getVariableState(var));
                }
                for (Object valueId : (Object)this.myIdToEqClassesIndices.keys()) {
                    DfaValue value2 = this.myFactory.getValue((int)valueId);
                    DfaVariableValue var = (DfaVariableValue)ObjectUtils.tryCast((Object)value2, DfaVariableValue.class);
                    if (var == null || var.getQualifier() != from) continue;
                    DfaVariableValue target = var.withQualifier(to);
                    boolean united = this.uniteClasses(var, target);
                    assert (united);
                    otherClassChanged = true;
                }
            }
        }
        this.checkInvariants();
        return otherClassChanged;
    }

    @NotNull
    private List<EqClass> splitEqClass(EqClass eqClass, DfaMemoryStateImpl other) {
        TIntObjectHashMap groupsInClasses = new TIntObjectHashMap();
        ArrayList<EqClass> groups = new ArrayList<EqClass>();
        for (DfaValue value2 : eqClass.getMemberValues()) {
            EqClass list;
            int otherClass = other.getEqClassIndex(value2);
            if (otherClass == -1) {
                list = new EqClass(this.myFactory);
                groups.add(list);
            } else {
                list = (EqClass)groupsInClasses.get(otherClass);
                if (list == null) {
                    list = new EqClass(this.myFactory);
                    groupsInClasses.put(otherClass, (Object)list);
                }
            }
            list.add(value2.getID());
        }
        groupsInClasses.forEachValue(groups::add);
        ArrayList<EqClass> arrayList = groups;
        if (arrayList == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 36: 
            case 42: 
            case 45: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 17: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 21: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 38: 
            case 54: 
            case 61: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquivalentValues";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPairs";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "equalByConstant";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariableValue";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableState";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableState";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedVariables";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "splitEqClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeInRelation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEquivalentValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canBeNaN";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyNaN";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "castTopOfStack";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "dropFact";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyFact";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateVarStateOnComparison";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyDependentFieldsEquivalence";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "applyUnboxedRelation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyLessThanRelation";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getValueFact";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "forceVariableFact";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFactMap";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setVariableState";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createVariableState";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkFlushed";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "flushQualifiedMethods";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeEquivalenceForVariableAndWrappers";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFlush$12";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flushVariable$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIdMap
    extends TIntObjectHashMap<Integer> {
        private MyIdMap() {
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Integer>(){

                public boolean execute(int id, Integer index) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(index).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

