/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.InferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodDataExternalizer;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\"4\u0010\u0000\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"gist", "Lcom/intellij/util/gist/PsiFileGist;", "", "", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "kotlin.jvm.PlatformType", "getIndexedData", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "indexFile", "tree", "Lcom/intellij/lang/LighterAST;", "intellij.java.analysis.impl"})
public final class ContractInferenceIndexKt {
    private static final PsiFileGist<Map<Integer, MethodData>> gist = GistManager.getInstance().newPsiFileGist("contractInference", 10, (DataExternalizer)MethodDataExternalizer.INSTANCE, (NullableFunction)gist.1.INSTANCE);

    private static final Map<Integer, MethodData> indexFile(LighterAST tree) {
        InferenceVisitor visitor = new InferenceVisitor(tree);
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"tree.root");
        visitor.visitNode(lighterASTNode);
        return visitor.getResult();
    }

    @Nullable
    public static final MethodData getIndexedData(@NotNull PsiMethodImpl method) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Map map = (Map)gist.getFileData(method.getContainingFile());
        return map != null ? (MethodData)map.get(JavaStubImplUtil.getMethodStubIndex(method)) : null;
    }

    @NotNull
    public static final /* synthetic */ Map access$indexFile(@NotNull LighterAST tree) {
        return ContractInferenceIndexKt.indexFile(tree);
    }
}

