/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReturnInferenceVisitor {
    private final LighterAST tree;
    private final LighterASTNode body;
    private boolean hasErrors;
    private boolean hasNotNulls;
    private boolean hasNulls;
    private boolean hasUnknowns;
    private boolean hasSystemExit;
    MultiMap<String, ExpressionRange> delegates = MultiMap.create();
    Set<String> assignments = ContainerUtil.newHashSet();
    Set<String> returnedCheckedVars = ContainerUtil.newHashSet();

    MethodReturnInferenceVisitor(LighterAST tree, LighterASTNode body2) {
        this.tree = tree;
        this.body = body2;
    }

    void visitNode(LighterASTNode element) {
        LighterASTNode qualifier;
        LighterASTNode reference;
        IElementType type2 = element.getTokenType();
        if (type2 == TokenType.ERROR_ELEMENT) {
            this.hasErrors = true;
        } else if (type2 == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode value2 = JavaLightTreeUtil.findExpressionChild(this.tree, element);
            if (value2 == null) {
                this.hasErrors = true;
            } else {
                this.visitReturnedValue(value2);
            }
        } else if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            ContainerUtil.addIfNotNull(this.assignments, (Object)JavaLightTreeUtil.getNameIdentifierText(this.tree, JavaLightTreeUtil.findExpressionChild(this.tree, element)));
        } else if (type2 == JavaElementType.METHOD_CALL_EXPRESSION && "exit".equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, reference = JavaLightTreeUtil.findExpressionChild(this.tree, element))) && "System".equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, qualifier = JavaLightTreeUtil.findExpressionChild(this.tree, reference))) && JavaLightTreeUtil.findExpressionChild(this.tree, qualifier) == null) {
            this.hasSystemExit = true;
        }
    }

    private void visitReturnedValue(@Nullable LighterASTNode expr) {
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null) {
            this.hasErrors = true;
            return;
        }
        IElementType type2 = expr.getTokenType();
        if (this.isNullLiteral(expr)) {
            this.hasNulls = true;
        } else if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.METHOD_REF_EXPRESSION || type2 == JavaElementType.LITERAL_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION || type2 == JavaElementType.POLYADIC_EXPRESSION) {
            this.hasNotNulls = true;
        } else if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            String calledMethod = JavaLightTreeUtil.getNameIdentifierText(this.tree, (LighterASTNode)this.tree.getChildren(expr).get(0));
            if (calledMethod != null) {
                this.delegates.putValue((Object)calledMethod, (Object)ExpressionRange.create(expr, this.body.getStartOffset()));
            }
        } else if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> expressionChildren = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
            if (expressionChildren.size() == 3) {
                this.visitReturnedValue(expressionChildren.get(1));
                this.visitReturnedValue(expressionChildren.get(2));
            } else {
                this.hasUnknowns = true;
            }
        } else if (type2 == JavaElementType.REFERENCE_EXPRESSION) {
            LighterASTNode target = new FileLocalResolver(this.tree).resolveLocally(expr).getTarget();
            if (target != null && (target.getTokenType() == JavaElementType.LOCAL_VARIABLE || target.getTokenType() == JavaElementType.PARAMETER) && this.isCheckedForNotNull(target, expr)) {
                ContainerUtil.addIfNotNull(this.returnedCheckedVars, (Object)JavaLightTreeUtil.getNameIdentifierText(this.tree, target));
            } else {
                this.hasUnknowns = true;
            }
        } else {
            this.hasUnknowns = true;
        }
    }

    private boolean isCheckedForNotNull(LighterASTNode var, LighterASTNode ref) {
        JBIterable hierarchy = JBIterable.generate((Object)ref, arg_0 -> ((LighterAST)this.tree).getParent(arg_0));
        for (Pair pair : ContainerUtil.zip((Iterable)hierarchy, (Iterable)hierarchy.skip(1))) {
            List<LighterASTNode> operands2;
            LighterASTNode eachParent = (LighterASTNode)pair.second;
            LighterASTNode prevParent = (LighterASTNode)pair.first;
            IElementType type2 = eachParent.getTokenType();
            if (type2 == JavaElementType.IF_STATEMENT && prevParent.equals(ContainerUtil.getFirstItem(ContractInferenceInterpreter.getStatements(eachParent, this.tree))) && this.isNonNullCondition(JavaLightTreeUtil.findExpressionChild(this.tree, eachParent), var)) {
                return true;
            }
            if (type2 != JavaElementType.CONDITIONAL_EXPRESSION || (operands2 = JavaLightTreeUtil.getExpressionChildren(this.tree, eachParent)).size() != 3 || !prevParent.equals(operands2.get(1)) || !this.isNonNullCondition(operands2.get(0), var)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonNullCondition(@Nullable LighterASTNode expr, LighterASTNode var) {
        if ((expr = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, expr)) == null) {
            return false;
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.BINARY_EXPRESSION || type2 == JavaElementType.POLYADIC_EXPRESSION) {
            List<LighterASTNode> operands2 = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
            if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)JavaTokenType.NE) != null) {
                return operands2.size() == 2 && this.isNullLiteral(operands2.get(1)) && this.isReferenceTo(operands2.get(0), var);
            }
            return LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)expr, (IElementType)JavaTokenType.ANDAND) != null && ContainerUtil.exists(operands2, e -> this.isNonNullCondition((LighterASTNode)e, var));
        }
        return type2 == JavaElementType.INSTANCE_OF_EXPRESSION && this.isReferenceTo(expr, var);
    }

    private boolean isReferenceTo(@NotNull LighterASTNode expr, @NotNull LighterASTNode var) {
        LighterASTNode operand2;
        if (expr == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(0);
        }
        if (var == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(1);
        }
        if ((operand2 = JavaLightTreeUtil.skipParenthesesCastsDown(this.tree, JavaLightTreeUtil.findExpressionChild(this.tree, expr))) == null || operand2.getTokenType() != JavaElementType.REFERENCE_EXPRESSION || !Objects.equals(JavaLightTreeUtil.getNameIdentifierText(this.tree, operand2), JavaLightTreeUtil.getNameIdentifierText(this.tree, operand2))) {
            return false;
        }
        return var.equals(new FileLocalResolver(this.tree).resolveLocally(operand2).getTarget());
    }

    private boolean isNullLiteral(@NotNull LighterASTNode value2) {
        if (value2 == null) {
            MethodReturnInferenceVisitor.$$$reportNull$$$0(2);
        }
        return value2.getTokenType() == JavaElementType.LITERAL_EXPRESSION && ((LighterASTNode)this.tree.getChildren(value2).get(0)).getTokenType() == JavaTokenType.NULL_KEYWORD;
    }

    @Nullable
    MethodReturnInferenceResult getResult() {
        if (!this.returnedCheckedVars.isEmpty()) {
            if (ContainerUtil.exists(this.returnedCheckedVars, name2 -> !this.assignments.contains(name2))) {
                this.hasNotNulls = true;
            } else {
                this.hasUnknowns = true;
            }
        }
        ArrayList delegateCalls = null;
        if (this.delegates.size() == 1) {
            delegateCalls = ContainerUtil.newArrayList((Iterable)this.delegates.get(this.delegates.keySet().iterator().next()));
        }
        if (this.hasNulls) {
            if (this.hasSystemExit) {
                return new MethodReturnInferenceResult.Predefined(Nullability.UNKNOWN);
            }
            return delegateCalls == null || this.hasNotNulls || this.hasErrors || this.hasUnknowns ? new MethodReturnInferenceResult.Predefined(Nullability.NULLABLE) : new MethodReturnInferenceResult.FromDelegate(Nullability.NULLABLE, delegateCalls);
        }
        if (this.hasErrors || this.hasUnknowns || this.delegates.size() > 1) {
            return null;
        }
        if (delegateCalls != null) {
            return new MethodReturnInferenceResult.FromDelegate(this.hasNotNulls ? Nullability.NOT_NULL : Nullability.UNKNOWN, delegateCalls);
        }
        if (this.hasNotNulls) {
            return new MethodReturnInferenceResult.Predefined(Nullability.NOT_NULL);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNullLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

