/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CFGBuilder;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MapUpdateInliner
implements CallInliner {
    private static final CallMatcher MAP_COMPUTE = CallMatcher.instanceCall("java.util.Map", "computeIfAbsent", "computeIfPresent", "compute").parameterCount(2);
    private static final CallMatcher MAP_MERGE = CallMatcher.instanceCall("java.util.Map", "merge").parameterCount(3);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            MapUpdateInliner.$$$reportNull$$$0(1);
        }
        if (MAP_COMPUTE.test(call)) {
            String name2;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type2 = call.getType();
            if (type2 == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key2 = args[0];
            PsiExpression function = args[1];
            builder.pushExpression(qualifier).checkNotNull(call, NullabilityProblemKind.callNPE).pop();
            switch (name2 = Objects.requireNonNull(call.getMethodExpression().getReferenceName())) {
                case "computeIfAbsent": {
                    MapUpdateInliner.inlineComputeIfAbsent(builder, qualifier, key2, function, type2);
                    break;
                }
                case "computeIfPresent": {
                    MapUpdateInliner.inlineComputeIfPresent(builder, qualifier, key2, function, type2);
                    break;
                }
                case "compute": {
                    MapUpdateInliner.inlineCompute(builder, qualifier, key2, function, type2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported name: " + name2);
                }
            }
            builder.resultOf((PsiExpression)call);
            return true;
        }
        if (MAP_MERGE.test(call)) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type3 = call.getType();
            if (type3 == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key3 = args[0];
            PsiExpression value2 = args[1];
            PsiExpression function = args[2];
            builder.pushExpression(qualifier).checkNotNull(call, NullabilityProblemKind.callNPE).pop().pushExpression(key3).pop().pushExpression(value2).boxUnbox(value2, ExpectedTypeUtils.findExpectedType(value2, false)).checkNotNull(value2, NullabilityProblemKind.passingNullableToNotNullParameter).evaluateFunction(function).pushUnknown().ifNotNull().push(builder.getFactory().createTypeValue(type3, Nullability.NOT_NULL)).swap().invokeFunction(2, function).end().chain(b -> MapUpdateInliner.flushSize(qualifier, b)).resultOf((PsiExpression)call);
            return true;
        }
        return false;
    }

    private static void flushSize(PsiExpression qualifier, CFGBuilder builder) {
        DfaValueFactory factory = builder.getFactory();
        DfaValue value2 = factory.createValue(qualifier);
        DfaValue size = SpecialField.MAP_SIZE.createValue(factory, value2);
        builder.assignAndPop(size, DfaUnknownValue.getInstance());
    }

    private static void inlineComputeIfAbsent(@NotNull CFGBuilder builder, PsiExpression qualifier, PsiExpression key2, PsiExpression function, PsiType type2) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(2);
        }
        builder.pushExpression(key2).evaluateFunction(function).pushUnknown().ifNull().invokeFunction(1, function).chain(b -> MapUpdateInliner.flushSize(qualifier, b)).elseBranch().pop().push(builder.getFactory().createTypeValue(type2, Nullability.NOT_NULL)).end();
    }

    private static void inlineComputeIfPresent(@NotNull CFGBuilder builder, PsiExpression qualifier, PsiExpression key2, PsiExpression function, PsiType type2) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(3);
        }
        builder.pushExpression(key2).evaluateFunction(function).pushUnknown().ifNotNull().push(builder.getFactory().createTypeValue(type2, Nullability.NOT_NULL)).invokeFunction(2, function).chain(b -> MapUpdateInliner.flushSize(qualifier, b)).elseBranch().pop().pushNull().end();
    }

    private static void inlineCompute(@NotNull CFGBuilder builder, PsiExpression qualifier, PsiExpression key2, PsiExpression function, PsiType type2) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(4);
        }
        builder.pushExpression(key2).evaluateFunction(function).push(builder.getFactory().createTypeValue(type2, Nullability.NULLABLE)).invokeFunction(2, function).chain(b -> MapUpdateInliner.flushSize(qualifier, b));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inliner/MapUpdateInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfPresent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCompute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

