/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.JumpInstruction;
import com.intellij.psi.PsiElement;

public class ConditionalGotoInstruction
extends BranchingInstruction
implements JumpInstruction {
    private ControlFlow.ControlFlowOffset myOffset;
    private final boolean myIsNegated;

    public ConditionalGotoInstruction(ControlFlow.ControlFlowOffset myOffset, boolean isNegated, PsiElement psiAnchor) {
        super(psiAnchor);
        this.myOffset = myOffset;
        this.myIsNegated = isNegated;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitConditionalGoto(this, runner, stateBefore);
    }

    public String toString() {
        return "IF_" + (this.isNegated() ? "NE" : "EQ") + " " + this.getOffset();
    }

    @Override
    public int getOffset() {
        return this.myOffset.getInstructionOffset();
    }

    @Override
    public void setOffset(int offset) {
        this.myOffset = new ControlFlow.FixedOffset(offset);
    }
}

