/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaFactMapValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LongRangeSet {
    private static final String JETBRAINS_RANGE = "org.jetbrains.annotations.Range";
    private static final String CHECKER_RANGE = "org.checkerframework.common.value.qual.IntRange";
    private static final String CHECKER_GTE_NEGATIVE_ONE = "org.checkerframework.checker.index.qual.GTENegativeOne";
    private static final String CHECKER_NON_NEGATIVE = "org.checkerframework.checker.index.qual.NonNegative";
    private static final String CHECKER_POSITIVE = "org.checkerframework.checker.index.qual.Positive";
    private static final String JSR305_NONNEGATIVE = "javax.annotation.Nonnegative";
    private static final String VALIDATION_MIN = "javax.validation.constraints.Min";
    private static final String VALIDATION_MAX = "javax.validation.constraints.Max";
    private static final List<String> ANNOTATIONS = Arrays.asList("org.checkerframework.common.value.qual.IntRange", "org.checkerframework.checker.index.qual.GTENegativeOne", "org.checkerframework.checker.index.qual.NonNegative", "org.checkerframework.checker.index.qual.Positive", "javax.annotation.Nonnegative", "javax.validation.constraints.Min", "javax.validation.constraints.Max");

    LongRangeSet() {
    }

    public abstract LongRangeSet subtract(LongRangeSet var1);

    public LongRangeSet without(long value2) {
        return this.subtract(LongRangeSet.point(value2));
    }

    public boolean isEmpty() {
        return this == Empty.EMPTY;
    }

    public abstract LongRangeSet intersect(LongRangeSet var1);

    public LongRangeSet unite(LongRangeSet other) {
        if (other.isEmpty() || other == this) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        return Range.LONG_RANGE.subtract(Range.LONG_RANGE.subtract(this).intersect(Range.LONG_RANGE.subtract(other)));
    }

    public abstract long min();

    public abstract long max();

    public abstract boolean intersects(LongRangeSet var1);

    public abstract boolean contains(long var1);

    public abstract boolean contains(LongRangeSet var1);

    public LongRangeSet fromRelation(@Nullable DfaRelationValue.RelationType relation) {
        if (this.isEmpty() || relation == null) {
            return null;
        }
        switch (relation) {
            case EQ: {
                return this;
            }
            case NE: {
                long min = this.min();
                if (min == this.max()) {
                    return LongRangeSet.all().without(min);
                }
                return LongRangeSet.all();
            }
            case GT: {
                long min = this.min();
                return min == Long.MAX_VALUE ? LongRangeSet.empty() : LongRangeSet.range(min + 1L, Long.MAX_VALUE);
            }
            case GE: {
                return LongRangeSet.range(this.min(), Long.MAX_VALUE);
            }
            case LE: {
                return LongRangeSet.range(Long.MIN_VALUE, this.max());
            }
            case LT: {
                long max = this.max();
                return max == Long.MIN_VALUE ? LongRangeSet.empty() : LongRangeSet.range(Long.MIN_VALUE, max - 1L);
            }
        }
        return null;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public final LongRangeSet binOpFromToken(IElementType token, LongRangeSet right, boolean isLong) {
        if (token == null) {
            return null;
        }
        if (token.equals(JavaTokenType.PLUS)) {
            return this.plus(right, isLong);
        }
        if (token.equals(JavaTokenType.MINUS)) {
            return this.minus(right, isLong);
        }
        if (token.equals(JavaTokenType.AND)) {
            return this.bitwiseAnd(right);
        }
        if (token.equals(JavaTokenType.PERC)) {
            return this.mod(right);
        }
        if (token.equals(JavaTokenType.DIV)) {
            return this.div(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGT)) {
            return this.shiftRight(right, isLong);
        }
        if (token.equals(JavaTokenType.GTGTGT)) {
            return this.unsignedShiftRight(right, isLong);
        }
        return null;
    }

    @NotNull
    public abstract LongRangeSet abs(boolean var1);

    @NotNull
    public abstract LongRangeSet negate(boolean var1);

    @NotNull
    public abstract LongRangeSet plus(LongRangeSet var1, boolean var2);

    @NotNull
    public LongRangeSet minus(LongRangeSet other, boolean isLong) {
        LongRangeSet longRangeSet = this.plus(other.negate(isLong), isLong);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(0);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet bitwiseAnd(LongRangeSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(other.asRanges());
        if (left.length > 6) {
            left = LongRangeSet.splitAtZero(new long[]{left[0], left[left.length - 1]});
        }
        if (right.length > 6) {
            right = LongRangeSet.splitAtZero(new long[]{right[0], right[right.length - 1]});
        }
        LongRangeSet result = LongRangeSet.all();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.subtract(LongRangeSet.bitwiseAnd(left[i], left[i + 1], right[j], right[j + 1]));
            }
        }
        LongRangeSet longRangeSet = LongRangeSet.all().subtract(result);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(2);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet div(LongRangeSet divisor, boolean isLong) {
        if (divisor.isEmpty() || divisor.equals(new Point(0L))) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }
        long[] left = LongRangeSet.splitAtZero(this.asRanges());
        long[] right = LongRangeSet.splitAtZero(new long[]{divisor.min(), divisor.max()});
        LongRangeSet result = LongRangeSet.empty();
        for (int i = 0; i < left.length; i += 2) {
            for (int j = 0; j < right.length; j += 2) {
                result = result.unite(LongRangeSet.divide(left[i], left[i + 1], right[j], right[j + 1], isLong));
            }
        }
        LongRangeSet longRangeSet = result;
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(4);
        }
        return longRangeSet;
    }

    @NotNull
    private static LongRangeSet divide(long dividendMin, long dividendMax, long divisorMin, long divisorMax, boolean isLong) {
        if (divisorMin == 0L) {
            if (divisorMax == 0L) {
                LongRangeSet longRangeSet = LongRangeSet.empty();
                if (longRangeSet == null) {
                    LongRangeSet.$$$reportNull$$$0(5);
                }
                return longRangeSet;
            }
            divisorMin = 1L;
        }
        if (dividendMin >= 0L) {
            LongRangeSet longRangeSet = divisorMin > 0L ? LongRangeSet.range(dividendMin / divisorMax, dividendMax / divisorMin) : LongRangeSet.range(dividendMax / divisorMax, dividendMin / divisorMin);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(6);
            }
            return longRangeSet;
        }
        if (divisorMin > 0L) {
            LongRangeSet longRangeSet = LongRangeSet.range(dividendMin / divisorMin, dividendMax / divisorMax);
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(7);
            }
            return longRangeSet;
        }
        long minValue = LongRangeSet.minValue(isLong);
        if (dividendMin == minValue && divisorMax == -1L) {
            LongRangeSet longRangeSet = LongRangeSet.point(minValue).unite(divisorMin == -1L ? LongRangeSet.empty() : LongRangeSet.range(dividendMin / divisorMin, dividendMin / (divisorMax - 1L))).unite(dividendMax == minValue ? LongRangeSet.empty() : LongRangeSet.range(dividendMax / divisorMin, (dividendMin + 1L) / divisorMax));
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(8);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = LongRangeSet.range(dividendMax / divisorMin, dividendMin / divisorMax);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(9);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet shiftRight(LongRangeSet shiftSize, boolean isLong) {
        if (this.isEmpty() || shiftSize.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(10);
            }
            return longRangeSet;
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (shiftSize.min() < 0L || shiftSize.max() > (long)maxShift) {
            shiftSize = shiftSize.bitwiseAnd(LongRangeSet.point(maxShift));
        }
        long min = shiftSize.min();
        long max = shiftSize.max();
        LongRangeSet negative = this.intersect(LongRangeSet.range(LongRangeSet.minValue(isLong), -1L));
        LongRangeSet positive = this.intersect(LongRangeSet.range(0L, LongRangeSet.maxValue(isLong)));
        LongRangeSet longRangeSet = positive.shrPositive(min, max, isLong).unite(LongRangeSet.point(-1L).minus(LongRangeSet.point(-1L).minus(negative, isLong).shrPositive(min, max, isLong), isLong));
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(11);
        }
        return longRangeSet;
    }

    @NotNull
    public LongRangeSet unsignedShiftRight(LongRangeSet shiftSize, boolean isLong) {
        if (this.isEmpty() || shiftSize.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(12);
            }
            return longRangeSet;
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (shiftSize.min() < 0L || shiftSize.max() > (long)maxShift) {
            shiftSize = shiftSize.bitwiseAnd(LongRangeSet.point(maxShift));
        }
        long min = shiftSize.min();
        long max = shiftSize.max();
        LongRangeSet negative = this.intersect(LongRangeSet.range(LongRangeSet.minValue(isLong), -1L));
        LongRangeSet positive = this.intersect(LongRangeSet.range(0L, LongRangeSet.maxValue(isLong)));
        LongRangeSet result = positive.shrPositive(min, max, isLong);
        if (min == 0L) {
            result = result.unite(negative);
            if (max == 0L) {
                LongRangeSet longRangeSet = result;
                if (longRangeSet == null) {
                    LongRangeSet.$$$reportNull$$$0(13);
                }
                return longRangeSet;
            }
            ++min;
        }
        LongRangeSet longRangeSet = result.unite(LongRangeSet.point(LongRangeSet.maxValue(isLong)).minus(LongRangeSet.point(-1L).minus(negative, isLong).shrPositive(1L, 1L, isLong), isLong).shrPositive(min - 1L, max - 1L, isLong));
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(14);
        }
        return longRangeSet;
    }

    private LongRangeSet shrPositive(long min, long max, boolean isLong) {
        if (this.isEmpty()) {
            return LongRangeSet.empty();
        }
        int maxShift = (isLong ? 64 : 32) - 1;
        if (max == (long)maxShift) {
            return min == max ? LongRangeSet.point(0L) : LongRangeSet.point(0L).unite(this.div(LongRangeSet.range(1L << (int)min, 1L << (int)(max - 1L)), isLong));
        }
        return this.div(LongRangeSet.range(1L << (int)min, 1L << (int)max), isLong);
    }

    @NotNull
    public abstract LongRangeSet mod(LongRangeSet var1);

    private static long[] splitAtZero(long[] ranges) {
        for (int i = 0; i < ranges.length; i += 2) {
            if (ranges[i] >= 0L || ranges[i + 1] < 0L) continue;
            long[] result = new long[ranges.length + 2];
            System.arraycopy(ranges, 0, result, 0, i + 1);
            result[i + 1] = -1L;
            System.arraycopy(ranges, i + 1, result, i + 3, ranges.length - i - 1);
            return result;
        }
        return ranges;
    }

    private static LongRangeSet bitwiseAnd(long leftFrom, long leftTo, long rightFrom, long rightTo) {
        if (leftFrom == leftTo && rightFrom == rightTo) {
            return LongRangeSet.point(leftFrom & rightFrom);
        }
        ThreeState[] leftBits = LongRangeSet.bits(leftFrom, leftTo);
        ThreeState[] rightBits = LongRangeSet.bits(rightFrom, rightTo);
        ThreeState[] resultBits = new ThreeState[64];
        for (int i = 0; i < 64; ++i) {
            resultBits[i] = leftBits[i] == ThreeState.NO || rightBits[i] == ThreeState.NO ? ThreeState.NO : (leftBits[i] == ThreeState.UNSURE || rightBits[i] == ThreeState.UNSURE ? ThreeState.UNSURE : ThreeState.YES);
        }
        return LongRangeSet.fromBits(resultBits);
    }

    private static LongRangeSet fromBits(ThreeState[] bits) {
        int j;
        int i;
        long from = 0L;
        for (i = 0; i < 64 && bits[i] != ThreeState.UNSURE; ++i) {
            if (bits[i] != ThreeState.YES) continue;
            from |= 1L << 63 - i;
        }
        long to = (1L << 64 - i) - 1L | from;
        for (j = 63; j > i && bits[j] != ThreeState.UNSURE; --j) {
            if (bits[j] != ThreeState.NO) continue;
            to &= 1L << 63 - j ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (i == j) {
            return LongRangeSet.point(from).unite(LongRangeSet.point(to));
        }
        return from < to ? LongRangeSet.range(from, to) : LongRangeSet.range(to, from);
    }

    private static ThreeState[] bits(long from, long to) {
        Object[] bits = new ThreeState[64];
        Arrays.fill(bits, ThreeState.NO);
        while (true) {
            int toBit;
            int fromBit;
            if ((fromBit = Long.numberOfLeadingZeros(from)) != (toBit = Long.numberOfLeadingZeros(to))) {
                for (int i = Math.min(fromBit, toBit); i < 64; ++i) {
                    bits[i] = ThreeState.UNSURE;
                }
                break;
            }
            if (fromBit == 64) break;
            bits[fromBit] = ThreeState.YES;
            long clearMask = 1L << 63 - fromBit ^ 0xFFFFFFFFFFFFFFFFL;
            from &= clearMask;
            to &= clearMask;
        }
        return bits;
    }

    private static String formatNumber(long value2) {
        if (value2 == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFFFFFFFFFEL) {
            return "Long.MAX_VALUE-1";
        }
        if (value2 == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        if (value2 == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value2 == 0x7FFFFFFEL) {
            return "Integer.MAX_VALUE-1";
        }
        if (value2 == Integer.MIN_VALUE) {
            return "Integer.MIN_VALUE";
        }
        return String.valueOf(value2);
    }

    public abstract LongStream stream();

    public static LongRangeSet empty() {
        return Empty.EMPTY;
    }

    public static LongRangeSet all() {
        return Range.LONG_RANGE;
    }

    public static LongRangeSet point(long value2) {
        return new Point(value2);
    }

    @Nullable
    public static LongRangeSet fromConstant(Object val) {
        if (val instanceof Byte || val instanceof Short || val instanceof Integer || val instanceof Long) {
            return LongRangeSet.point(((Number)val).longValue());
        }
        if (val instanceof Character) {
            return LongRangeSet.point(((Character)val).charValue());
        }
        return null;
    }

    @Nullable
    public static LongRangeSet fromDfaValue(DfaValue value2) {
        if (value2 instanceof DfaFactMapValue) {
            return ((DfaFactMapValue)value2).get(DfaFactType.RANGE);
        }
        if (value2 instanceof DfaConstValue) {
            return LongRangeSet.fromConstant(((DfaConstValue)value2).getValue());
        }
        if (value2 instanceof DfaVariableValue) {
            return LongRangeSet.fromType(value2.getType());
        }
        return null;
    }

    public static LongRangeSet range(long from, long to) {
        return from == to ? new Point(from) : new Range(from, to);
    }

    abstract long[] asRanges();

    static String toString(long from, long to) {
        return LongRangeSet.formatNumber(from) + (from == to ? "" : (to - from == 1L ? ", " : "..") + LongRangeSet.formatNumber(to));
    }

    static long minValue(boolean isLong) {
        return isLong ? Long.MIN_VALUE : Integer.MIN_VALUE;
    }

    static long maxValue(boolean isLong) {
        return isLong ? Long.MAX_VALUE : Integer.MAX_VALUE;
    }

    public static LongRangeSet indexRange() {
        return Range.INDEX_RANGE;
    }

    @Nullable
    public static LongRangeSet fromType(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        if ((type2 = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type2)) != null) {
            if (type2.equals(PsiType.BYTE)) {
                return Range.BYTE_RANGE;
            }
            if (type2.equals(PsiType.CHAR)) {
                return Range.CHAR_RANGE;
            }
            if (type2.equals(PsiType.SHORT)) {
                return Range.SHORT_RANGE;
            }
            if (type2.equals(PsiType.INT)) {
                return Range.INT_RANGE;
            }
            if (type2.equals(PsiType.LONG)) {
                return LongRangeSet.all();
            }
        }
        return null;
    }

    @NotNull
    public static LongRangeSet fromPsiElement(PsiModifierListOwner owner2) {
        if (owner2 == null) {
            LongRangeSet longRangeSet = LongRangeSet.all();
            if (longRangeSet == null) {
                LongRangeSet.$$$reportNull$$$0(15);
            }
            return longRangeSet;
        }
        LongRangeSet longRangeSet = (LongRangeSet)StreamEx.ofNullable((Object)AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])new String[]{JETBRAINS_RANGE})).append((Object[])AnnotationUtil.findAnnotations((PsiModifierListOwner)owner2, ANNOTATIONS)).map(LongRangeSet::fromAnnotation).foldLeft((Object)LongRangeSet.all(), LongRangeSet::intersect);
        if (longRangeSet == null) {
            LongRangeSet.$$$reportNull$$$0(16);
        }
        return longRangeSet;
    }

    private static LongRangeSet fromAnnotation(PsiAnnotation annotation) {
        switch (Objects.requireNonNull(annotation.getQualifiedName())) {
            case "org.jetbrains.annotations.Range": 
            case "org.checkerframework.common.value.qual.IntRange": {
                Long from = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"from");
                Long to = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"to");
                if (from == null || to == null || to < from) break;
                return LongRangeSet.range(from, to);
            }
            case "javax.validation.constraints.Min": {
                Long minValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (minValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(minValue, Long.MAX_VALUE);
            }
            case "javax.validation.constraints.Max": {
                Long maxValue = AnnotationUtil.getLongAttributeValue((PsiAnnotation)annotation, (String)"value");
                if (maxValue == null || annotation.findDeclaredAttributeValue("groups") != null) break;
                return LongRangeSet.range(Long.MIN_VALUE, maxValue);
            }
            case "org.checkerframework.checker.index.qual.GTENegativeOne": {
                return LongRangeSet.range(-1L, Long.MAX_VALUE);
            }
            case "javax.annotation.Nonnegative": 
            case "org.checkerframework.checker.index.qual.NonNegative": {
                return LongRangeSet.range(0L, Long.MAX_VALUE);
            }
            case "org.checkerframework.checker.index.qual.Positive": {
                return LongRangeSet.range(1L, Long.MAX_VALUE);
            }
        }
        return LongRangeSet.all();
    }

    static LongRangeSet fromRanges(long[] ranges, int bound) {
        if (bound == 0) {
            return Empty.EMPTY;
        }
        if (bound == 2) {
            return LongRangeSet.range(ranges[0], ranges[1]);
        }
        return new RangeSet(Arrays.copyOfRange(ranges, 0, bound));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "bitwiseAnd";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "divide";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftRight";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unsignedShiftRight";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPsiElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static final class RangeSet
    extends LongRangeSet {
        final long[] myRanges;

        RangeSet(long[] ranges) {
            if (ranges.length < 4 || ranges.length % 2 != 0) {
                throw new IllegalArgumentException("Bad length: " + ranges.length + " " + Arrays.toString(ranges));
            }
            for (int i = 0; i < ranges.length; i += 2) {
                if (ranges[i + 1] < ranges[i]) {
                    throw new IllegalArgumentException("Bad sub-range #" + i / 2 + " " + Arrays.toString(ranges));
                }
                if (i <= 0 || ranges[i - 1] != Long.MAX_VALUE && 1L + ranges[i - 1] <= ranges[i]) continue;
                throw new IllegalArgumentException("Bad sub-ranges #" + (i / 2 - 1) + " and #" + i / 2 + " " + Arrays.toString(ranges));
            }
            this.myRanges = ranges;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            long[] result = new long[this.myRanges.length + other.asRanges().length];
            int index = 0;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                LongRangeSet res = RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).subtract(other);
                long[] ranges = res.asRanges();
                System.arraycopy(ranges, 0, result, index, ranges.length);
                index += ranges.length;
            }
            return RangeSet.fromRanges(result, index);
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point || other instanceof Range) {
                return other.intersect(this);
            }
            return this.subtract(RangeSet.all().subtract(other));
        }

        @Override
        public long min() {
            return this.myRanges[0];
        }

        @Override
        public long max() {
            return this.myRanges[this.myRanges.length - 1];
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            long bTo;
            long aFrom;
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            long[] otherRanges = other.asRanges();
            int a = 0;
            int b = 0;
            do {
                aFrom = this.myRanges[a];
                long aTo = this.myRanges[a + 1];
                long bFrom = otherRanges[b];
                bTo = otherRanges[b + 1];
                if (aFrom > bTo || bFrom > aTo) continue;
                return true;
            } while (!(aFrom > bTo ? (b += 2) >= otherRanges.length : (a += 2) >= this.myRanges.length));
            return false;
        }

        @Override
        public boolean contains(long value2) {
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (value2 < this.myRanges[i] || value2 > this.myRanges[i + 1]) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            if (other.isEmpty() || other == this) {
                return true;
            }
            if (other instanceof Point) {
                return this.contains(((Point)other).myValue);
            }
            LongRangeSet result = other;
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (!(result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]))).isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet result = RangeSet.all();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).abs(isLong));
            }
            LongRangeSet longRangeSet = RangeSet.all().subtract(result);
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(0);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet result = RangeSet.all();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.subtract(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).negate(isLong));
            }
            LongRangeSet longRangeSet = RangeSet.all().subtract(result);
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (this.myRanges.length > 6) {
                LongRangeSet longRangeSet = RangeSet.range(this.min(), this.max()).plus(other, isLong);
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).plus(other, isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            if (divisor.isEmpty()) {
                LongRangeSet longRangeSet = RangeSet.empty();
                if (longRangeSet == null) {
                    RangeSet.$$$reportNull$$$0(4);
                }
                return longRangeSet;
            }
            LongRangeSet result = RangeSet.empty();
            for (int i = 0; i < this.myRanges.length; i += 2) {
                result = result.unite(RangeSet.range(this.myRanges[i], this.myRanges[i + 1]).mod(divisor));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                RangeSet.$$$reportNull$$$0(5);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return IntStream.range(0, this.myRanges.length / 2).mapToObj(idx -> LongStream.rangeClosed(this.myRanges[idx * 2], this.myRanges[idx * 2 + 1])).reduce(LongStream::concat).orElseGet(LongStream::empty);
        }

        @Override
        long[] asRanges() {
            return this.myRanges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.myRanges);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof RangeSet && Arrays.equals(this.myRanges, ((RangeSet)o).myRanges);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < this.myRanges.length; i += 2) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(LongRangeSet.toString(this.myRanges[i], this.myRanges[i + 1]));
            }
            sb.append("}");
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$RangeSet";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static final class Range
    extends LongRangeSet {
        static final Range BYTE_RANGE = new Range(-128L, 127L);
        static final Range CHAR_RANGE = new Range(0L, 65535L);
        static final Range SHORT_RANGE = new Range(-32768L, 32767L);
        static final Range INT_RANGE = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
        static final Range LONG_RANGE = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
        static final Range INDEX_RANGE = new Range(0L, Integer.MAX_VALUE);
        final long myFrom;
        final long myTo;

        Range(long from, long to) {
            if (to <= from) {
                throw new IllegalArgumentException(to + "<=" + from);
            }
            this.myFrom = from;
            this.myTo = to;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            if (other.isEmpty()) {
                return this;
            }
            if (other == this) {
                return Empty.EMPTY;
            }
            if (other instanceof Point) {
                long value2 = ((Point)other).myValue;
                if (value2 < this.myFrom || value2 > this.myTo) {
                    return this;
                }
                if (value2 == this.myFrom) {
                    return Range.range(this.myFrom + 1L, this.myTo);
                }
                if (value2 == this.myTo) {
                    return Range.range(this.myFrom, this.myTo - 1L);
                }
                return new RangeSet(new long[]{this.myFrom, value2 - 1L, value2 + 1L, this.myTo});
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (to < this.myFrom || from > this.myTo) {
                    return this;
                }
                if (from <= this.myFrom && to >= this.myTo) {
                    return Empty.EMPTY;
                }
                if (from > this.myFrom && to < this.myTo) {
                    return new RangeSet(new long[]{this.myFrom, from - 1L, to + 1L, this.myTo});
                }
                if (from <= this.myFrom) {
                    return Range.range(to + 1L, this.myTo);
                }
                if (to >= this.myTo) {
                    return Range.range(this.myFrom, from - 1L);
                }
                throw new InternalError("Impossible: " + this + ":" + other);
            }
            long[] ranges = ((RangeSet)other).myRanges;
            LongRangeSet result = this;
            for (int i = 0; i < ranges.length; i += 2) {
                if (!(result = result.subtract(Range.range(ranges[i], ranges[i + 1]))).isEmpty()) continue;
                return result;
            }
            return result;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            if (other == this) {
                return this;
            }
            if (other.isEmpty()) {
                return other;
            }
            if (other instanceof Point) {
                return other.intersect(this);
            }
            if (other instanceof Range) {
                long from = ((Range)other).myFrom;
                long to = ((Range)other).myTo;
                if (from <= this.myFrom && to >= this.myTo) {
                    return this;
                }
                if (from >= this.myFrom && to <= this.myTo) {
                    return other;
                }
                if (from < this.myFrom) {
                    from = this.myFrom;
                }
                if (to > this.myTo) {
                    to = this.myTo;
                }
                return from <= to ? Range.range(from, to) : Empty.EMPTY;
            }
            long[] ranges = ((RangeSet)other).myRanges;
            long[] result = new long[ranges.length];
            int index = 0;
            for (int i = 0; i < ranges.length; i += 2) {
                long[] res = this.intersect(Range.range(ranges[i], ranges[i + 1])).asRanges();
                System.arraycopy(res, 0, result, index, res.length);
                index += res.length;
            }
            return Range.fromRanges(result, index);
        }

        @Override
        public long min() {
            return this.myFrom;
        }

        @Override
        public long max() {
            return this.myTo;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            if (other.isEmpty()) {
                return false;
            }
            if (other instanceof RangeSet) {
                return other.intersects(this);
            }
            return this.myTo >= other.min() && this.myFrom <= other.max();
        }

        @Override
        public boolean contains(long value2) {
            return this.myFrom <= value2 && this.myTo >= value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || other.min() >= this.myFrom && other.max() <= this.myTo;
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            if (this.myFrom >= 0L) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(0);
                }
                return range;
            }
            long minValue = Range.minValue(isLong);
            long low = this.myFrom;
            long hi = this.myTo;
            if (low <= minValue) {
                low = minValue + 1L;
            }
            if (this.myTo <= 0L) {
                hi = -low;
                low = -this.myTo;
            } else {
                hi = Math.max(-low, hi);
                low = 0L;
            }
            if (this.myFrom <= minValue) {
                RangeSet rangeSet = new RangeSet(new long[]{minValue, minValue, low, hi});
                if (rangeSet == null) {
                    Range.$$$reportNull$$$0(1);
                }
                return rangeSet;
            }
            Range range = new Range(low, hi);
            if (range == null) {
                Range.$$$reportNull$$$0(2);
            }
            return range;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            long minValue = Range.minValue(isLong);
            if (this.myFrom <= minValue) {
                if (this.myTo >= Range.maxValue(isLong)) {
                    Range range = isLong ? LONG_RANGE : INT_RANGE;
                    if (range == null) {
                        Range.$$$reportNull$$$0(3);
                    }
                    return range;
                }
                RangeSet rangeSet = new RangeSet(new long[]{minValue, minValue, -this.myTo, -(minValue + 1L)});
                if (rangeSet == null) {
                    Range.$$$reportNull$$$0(4);
                }
                return rangeSet;
            }
            Range range = new Range(-this.myTo, -this.myFrom);
            if (range == null) {
                Range.$$$reportNull$$$0(5);
            }
            return range;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(6);
                }
                return longRangeSet;
            }
            if (isLong && this.equals(LONG_RANGE) || !isLong && this.equals(INT_RANGE)) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(7);
                }
                return range;
            }
            if (other instanceof Point || other instanceof Range || other instanceof RangeSet && ((RangeSet)other).myRanges.length > 6) {
                LongRangeSet longRangeSet = Range.plus(this.myFrom, this.myTo, other.min(), other.max(), isLong);
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(8);
                }
                return longRangeSet;
            }
            long[] ranges = other.asRanges();
            LongRangeSet result = Range.empty();
            for (int i = 0; i < ranges.length; i += 2) {
                result = result.unite(Range.plus(this.myFrom, this.myTo, ranges[i], ranges[i + 1], isLong));
            }
            LongRangeSet longRangeSet = result;
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(9);
            }
            return longRangeSet;
        }

        @NotNull
        private static LongRangeSet plus(long from1, long to1, long from2, long to2, boolean isLong) {
            long len1 = to1 - from1;
            long len2 = to2 - from2;
            if ((len1 < 0L || len2 < 0L) && len1 + len2 + 1L >= 0L) {
                Range range = isLong ? LONG_RANGE : INT_RANGE;
                if (range == null) {
                    Range.$$$reportNull$$$0(10);
                }
                return range;
            }
            long from = from1 + from2;
            long to = to1 + to2;
            if (!isLong) {
                if (to - from + 1L >= 0x100000000L) {
                    Range range = INT_RANGE;
                    if (range == null) {
                        Range.$$$reportNull$$$0(11);
                    }
                    return range;
                }
                from = (int)from;
                to = (int)to;
            }
            if (to < from) {
                RangeSet rangeSet = new RangeSet(new long[]{Range.minValue(isLong), to, from, Range.maxValue(isLong)});
                if (rangeSet == null) {
                    Range.$$$reportNull$$$0(12);
                }
                return rangeSet;
            }
            LongRangeSet longRangeSet = Range.range(from, to);
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(13);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long minDivisor;
            if (divisor.isEmpty() || divisor.equals(Range.point(0L))) {
                LongRangeSet longRangeSet = Range.empty();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(14);
                }
                return longRangeSet;
            }
            if (divisor instanceof Point && ((Point)divisor).myValue == Long.MIN_VALUE) {
                LongRangeSet longRangeSet = this.contains(Long.MIN_VALUE) ? this.subtract(divisor).unite(Range.point(0L)) : this;
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(15);
                }
                return longRangeSet;
            }
            if (divisor.contains(Long.MIN_VALUE)) {
                LongRangeSet longRangeSet = this.possibleMod();
                if (longRangeSet == null) {
                    Range.$$$reportNull$$$0(16);
                }
                return longRangeSet;
            }
            long min = divisor.min();
            long max = divisor.max();
            long maxDivisor = Math.max(Math.abs(min), Math.abs(max));
            long l = min > 0L ? min : (minDivisor = max < 0L ? Math.abs(max) : 0L);
            if (!this.intersects(LongRangeSet.range(Long.MIN_VALUE, -minDivisor)) && !this.intersects(LongRangeSet.range(minDivisor, Long.MAX_VALUE))) {
                Range range = this;
                if (range == null) {
                    Range.$$$reportNull$$$0(17);
                }
                return range;
            }
            LongRangeSet longRangeSet = this.possibleMod().intersect(Range.range(-maxDivisor + 1L, maxDivisor - 1L));
            if (longRangeSet == null) {
                Range.$$$reportNull$$$0(18);
            }
            return longRangeSet;
        }

        private LongRangeSet possibleMod() {
            if (this.contains(0L)) {
                return this;
            }
            if (this.min() > 0L) {
                return Range.range(0L, this.max());
            }
            return Range.range(this.min(), 0L);
        }

        @Override
        public LongStream stream() {
            return LongStream.rangeClosed(this.myFrom, this.myTo);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myFrom, this.myTo};
        }

        public int hashCode() {
            return Long.hashCode(this.myFrom) * 1337 + Long.hashCode(this.myTo);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Range && this.myFrom == ((Range)o).myFrom && this.myTo == ((Range)o).myTo;
        }

        public String toString() {
            return "{" + Range.toString(this.myFrom, this.myTo) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Range";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static final class Point
    extends LongRangeSet {
        final long myValue;

        Point(long value2) {
            this.myValue = value2;
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return other.contains(this.myValue) ? Empty.EMPTY : this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return other.contains(this.myValue) ? this : Empty.EMPTY;
        }

        @Override
        public long min() {
            return this.myValue;
        }

        @Override
        public long max() {
            return this.myValue;
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return other.contains(this.myValue);
        }

        @Override
        public boolean contains(long value2) {
            return this.myValue == value2;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty() || this.equals(other);
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            LongRangeSet longRangeSet = this.myValue >= 0L || this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(0);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            LongRangeSet longRangeSet = this.myValue == Point.minValue(isLong) ? this : Point.point(-this.myValue);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(1);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            if (other.isEmpty()) {
                LongRangeSet longRangeSet = other;
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(2);
                }
                return longRangeSet;
            }
            if (other instanceof Point) {
                long res = this.myValue + ((Point)other).myValue;
                LongRangeSet longRangeSet = Point.point(isLong ? res : (long)((int)res));
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(3);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = other.plus(this, isLong);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(4);
            }
            return longRangeSet;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            long abs;
            if (divisor.isEmpty() || divisor.equals(Point.point(0L))) {
                LongRangeSet longRangeSet = Point.empty();
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(5);
                }
                return longRangeSet;
            }
            if (this.myValue == 0L) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(6);
                }
                return point;
            }
            if (divisor instanceof Point) {
                LongRangeSet longRangeSet = LongRangeSet.point(this.myValue % ((Point)divisor).myValue);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(7);
                }
                return longRangeSet;
            }
            if (this.myValue != Long.MIN_VALUE && !divisor.intersects(LongRangeSet.range(-(abs = Math.abs(this.myValue)), abs))) {
                Point point = this;
                if (point == null) {
                    Point.$$$reportNull$$$0(8);
                }
                return point;
            }
            LongRangeSet addend = Point.empty();
            if (divisor.contains(Long.MIN_VALUE)) {
                divisor = divisor.subtract(Point.point(Long.MIN_VALUE));
                addend = Point.point(this.myValue);
            }
            long max = Math.max(0L, Math.max(Math.abs(divisor.min()), Math.abs(divisor.max())) - 1L);
            if (this.myValue < 0L) {
                LongRangeSet longRangeSet = LongRangeSet.range(Math.max(this.myValue, -max), 0L).unite(addend);
                if (longRangeSet == null) {
                    Point.$$$reportNull$$$0(9);
                }
                return longRangeSet;
            }
            LongRangeSet longRangeSet = LongRangeSet.range(0L, Math.min(this.myValue, max)).unite(addend);
            if (longRangeSet == null) {
                Point.$$$reportNull$$$0(10);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.of(this.myValue);
        }

        @Override
        long[] asRanges() {
            return new long[]{this.myValue, this.myValue};
        }

        public int hashCode() {
            return Long.hashCode(this.myValue);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Point && this.myValue == ((Point)o).myValue;
        }

        public String toString() {
            return "{" + LongRangeSet.formatNumber(this.myValue) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Point";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static final class Empty
    extends LongRangeSet {
        static final LongRangeSet EMPTY = new Empty();

        Empty() {
        }

        @Override
        public LongRangeSet subtract(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet intersect(LongRangeSet other) {
            return this;
        }

        @Override
        public LongRangeSet unite(LongRangeSet other) {
            return other;
        }

        @Override
        public long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean intersects(LongRangeSet other) {
            return false;
        }

        @Override
        public boolean contains(long value2) {
            return false;
        }

        @Override
        public boolean contains(LongRangeSet other) {
            return other.isEmpty();
        }

        @Override
        @NotNull
        public LongRangeSet abs(boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(0);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet negate(boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(1);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet plus(LongRangeSet other, boolean isLong) {
            Empty empty = this;
            if (empty == null) {
                Empty.$$$reportNull$$$0(2);
            }
            return empty;
        }

        @Override
        @NotNull
        public LongRangeSet mod(LongRangeSet divisor) {
            LongRangeSet longRangeSet = Empty.empty();
            if (longRangeSet == null) {
                Empty.$$$reportNull$$$0(3);
            }
            return longRangeSet;
        }

        @Override
        public LongStream stream() {
            return LongStream.empty();
        }

        @Override
        long[] asRanges() {
            return new long[0];
        }

        public int hashCode() {
            return 2154231;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "{}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeSet$Empty";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "abs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "negate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "plus";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mod";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

