/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Collection;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPseudoFunctionalStyleMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StaticPseudoFunctionalStyleMethodInspection.class);
    private final StaticPseudoFunctionalStyleMethodOptions myOptions = new StaticPseudoFunctionalStyleMethodOptions();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            StaticPseudoFunctionalStyleMethodInspection.$$$reportNull$$$0(0);
        }
        this.myOptions.readExternal(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            StaticPseudoFunctionalStyleMethodInspection.$$$reportNull$$$0(1);
        }
        this.myOptions.writeExternal(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.myOptions.createPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StaticPseudoFunctionalStyleMethodInspection.$$$reportNull$$$0(2);
        }
        if (!JavaFeature.STREAMS.isFeatureSupported(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StaticPseudoFunctionalStyleMethodInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
                String qName = methodCallExpression.getMethodExpression().getQualifiedName();
                if (qName == null) {
                    return;
                }
                qName = StringUtil.getShortName((String)qName);
                Collection<StaticPseudoFunctionalStyleMethodOptions.PipelineElement> handlerInfos = StaticPseudoFunctionalStyleMethodInspection.this.myOptions.findElementsByMethodName(qName);
                if (handlerInfos.isEmpty()) {
                    return;
                }
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String classQualifiedName = aClass.getQualifiedName();
                if (classQualifiedName == null) {
                    return;
                }
                StaticPseudoFunctionalStyleMethodOptions.PipelineElement suitableHandler = null;
                for (StaticPseudoFunctionalStyleMethodOptions.PipelineElement h : handlerInfos) {
                    if (!h.getHandlerClass().equals(classQualifiedName)) continue;
                    suitableHandler = h;
                    break;
                }
                if (suitableHandler == null) {
                    return;
                }
                PseudoLambdaReplaceTemplate.ValidationInfo validationInfo = suitableHandler.getTemplate().validate(methodCallExpression);
                if (validationInfo != null) {
                    holder.registerProblem((PsiElement)methodCallExpression.getMethodExpression(), "Pseudo functional style code", new LocalQuickFix[]{new ReplacePseudoLambdaWithLambda(suitableHandler)});
                }
            }
        };
        if (javaElementVisitor == null) {
            StaticPseudoFunctionalStyleMethodInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ReplacePseudoLambdaWithLambda
    implements LocalQuickFix {
        private final StaticPseudoFunctionalStyleMethodOptions.PipelineElement myHandler;

        private ReplacePseudoLambdaWithLambda(StaticPseudoFunctionalStyleMethodOptions.PipelineElement handler) {
            this.myHandler = handler;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with Java Stream API pipeline" == null) {
                ReplacePseudoLambdaWithLambda.$$$reportNull$$$0(0);
            }
            return "Replace with Java Stream API pipeline";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement parent;
            PsiElement psiElement;
            if (project == null) {
                ReplacePseudoLambdaWithLambda.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplacePseudoLambdaWithLambda.$$$reportNull$$$0(2);
            }
            if ((psiElement = descriptor2.getPsiElement()) instanceof PsiReferenceExpression && (parent = psiElement.getParent()) instanceof PsiMethodCallExpression) {
                this.myHandler.getTemplate().convertToStream((PsiMethodCallExpression)parent, null, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

