/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalGetWithoutIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OptionalGetWithoutIsPresentInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                CommonDataflow.DataflowResult result;
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                String methodName = nameElement.getText();
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                if (qualifier == null) {
                    return;
                }
                PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (optionalClass == null) {
                    return;
                }
                if (DfaOptionalSupport.isOptionalGetMethodName(methodName) && call.getArgumentList().isEmpty() && TypeUtils.isOptional(optionalClass) && (result = CommonDataflow.getDataflowResult(qualifier)) != null && result.expressionWasAnalyzed(qualifier) && result.getExpressionFact(qualifier, DfaFactType.OPTIONAL_PRESENCE) == null && !this.isPresentCallWithSameQualifierExists(qualifier)) {
                    holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.optional.get.without.is.present.message", (Object[])new Object[]{optionalClass.getName()}), new LocalQuickFix[]{OptionalGetWithoutIsPresentInspection.tryCreateFix(call)});
                }
            }

            public boolean isPresentCallWithSameQualifierExists(PsiExpression qualifier) {
                PsiElement context;
                if (qualifier instanceof PsiMethodCallExpression && (context = PsiTreeUtil.getParentOfType((PsiElement)qualifier, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                    return !PsiTreeUtil.processElements((PsiElement)context, e -> {
                        if (e == qualifier || !(e instanceof PsiMethodCallExpression)) {
                            return true;
                        }
                        PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                        if (!"isPresent".equals(call.getMethodExpression().getReferenceName()) || !call.getArgumentList().isEmpty()) {
                            return true;
                        }
                        PsiExpression isPresentQualifier = call.getMethodExpression().getQualifierExpression();
                        return isPresentQualifier == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)isPresentQualifier);
                    });
                }
                return false;
            }
        };
        if (javaElementVisitor == null) {
            OptionalGetWithoutIsPresentInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static LocalQuickFix tryCreateFix(PsiMethodCallExpression call) {
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
        if (optionalClass == null || !"java.util.Optional".equals(optionalClass.getQualifiedName())) {
            return null;
        }
        PsiType optionalElementType = OptionalUtil.getOptionalElementType(qualifier.getType());
        if (optionalElementType == null) {
            return null;
        }
        PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        if (nextCall != null && optionalClass.equals(PsiUtil.resolveClassInClassTypeOnly((PsiType)nextCall.getType()))) {
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nextCall)) {
                PsiMethodCallExpression copy = (PsiMethodCallExpression)nextCall.copy();
                PsiExpression copyQualifier = Objects.requireNonNull(copy.getMethodExpression().getQualifierExpression());
                try {
                    copyQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)call.getProject()).createExpressionFromText("((" + optionalElementType.getCanonicalText() + ")null)", (PsiElement)copyQualifier));
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)copy)) {
                    return null;
                }
            }
            return new UseFlatMapFix();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UseFlatMapFix
    implements LocalQuickFix {
        private UseFlatMapFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            if ("Use 'flatMap'" == null) {
                UseFlatMapFix.$$$reportNull$$$0(0);
            }
            return "Use 'flatMap'";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiMethodCallExpression call;
            if (project == null) {
                UseFlatMapFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                UseFlatMapFix.$$$reportNull$$$0(2);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType elementType = OptionalUtil.getOptionalElementType(qualifier.getType());
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (nextCall == null) {
                return;
            }
            JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project);
            SuggestedNameInfo info = manager.suggestVariableName(VariableKind.PARAMETER, null, qualifier, elementType, true);
            String name2 = info.names.length == 0 ? "value" : info.names[0];
            name2 = manager.suggestUniqueVariableName(name2, (PsiElement)call, true);
            CommentTracker ct = new CommentTracker();
            PsiReferenceExpression methodExpression = nextCall.getMethodExpression();
            ct.markRangeUnchanged(Objects.requireNonNull(methodExpression.getQualifierExpression()).getNextSibling(), methodExpression.getLastChild());
            ct.markRangeUnchanged(methodExpression.getNextSibling(), nextCall.getLastChild());
            PsiMethodCallExpression newNextCall = (PsiMethodCallExpression)nextCall.copy();
            PsiExpression newQualifier = Objects.requireNonNull(newNextCall.getMethodExpression().getQualifierExpression());
            newQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(name2, (PsiElement)newNextCall));
            String lambda2 = name2 + "->" + newNextCall.getText();
            String replacement = ct.text((PsiElement)qualifier) + ".flatMap(" + lambda2 + ")";
            PsiMethodCallExpression result = (PsiMethodCallExpression)ct.replaceAndRestoreComments((PsiElement)nextCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)result.getArgumentList().getExpressions()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection$UseFlatMapFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/OptionalGetWithoutIsPresentInspection$UseFlatMapFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

