/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class RefFieldImpl
extends RefJavaElementImpl
implements RefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;

    RefFieldImpl(@NotNull RefClass ownerClass, UField field, PsiElement psi, RefManager manager) {
        if (ownerClass == null) {
            RefFieldImpl.$$$reportNull$$$0(0);
        }
        super((UDeclaration)field, psi, manager);
        ((RefClassImpl)ownerClass).add((RefEntity)this);
        if (ownerClass.isInterface()) {
            this.setIsStatic(true);
            this.setIsFinal(true);
        }
        if (field instanceof UEnumConstant) {
            this.putUserData(ENUM_CONSTANT, true);
        }
    }

    @Deprecated
    public PsiField getElement() {
        return (PsiField)super.getPsiElement();
    }

    public UField getUastElement() {
        return (UField)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UField.class);
    }

    @Override
    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, UExpression expressionFrom) {
        UClassInitializer initializer;
        this.addInReference((RefElement)refFrom);
        boolean referencedFromClassInitializer = false;
        if (forWriting && expressionFrom != null && (initializer = (UClassInitializer)UastUtils.getParentOfType((UElement)expressionFrom, UClassInitializer.class)) != null && psiFrom == UastUtils.getParentOfType((UElement)initializer, UClass.class).getSourcePsi()) {
            UExpression qualifierExpression2;
            UExpression uExpression = qualifierExpression2 = expressionFrom instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)expressionFrom).getReceiver() : null;
            if (qualifierExpression2 == null || qualifierExpression2 instanceof UThisExpression) {
                referencedFromClassInitializer = true;
            }
        }
        if (forWriting) {
            this.setUsedForWriting(true);
        }
        if (forReading) {
            this.setUsedForReading(true);
        }
        this.setUsedQualifiedOutsidePackageFlag(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)refFrom, referencedFromClassInitializer, forReading, forWriting, expressionFrom == null ? null : expressionFrom.getSourcePsi());
    }

    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading(boolean usedForReading) {
        this.setFlag(usedForReading, 65536L);
    }

    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting(boolean usedForWriting) {
        this.setFlag(false, 262144L);
        this.setFlag(usedForWriting, 131072L);
    }

    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefFieldImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    RefFieldImpl.$$$reportNull$$$0(2);
                }
                ((RefJavaVisitor)visitor).visitField((RefField)this);
            });
        } else {
            super.accept(visitor);
        }
    }

    public void buildReferences() {
        UField uField = this.getUastElement();
        if (uField != null) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            refUtil.addReferencesTo((UDeclaration)uField, (RefJavaElement)this, new UElement[]{uField.getUastInitializer()});
            refUtil.addReferencesTo((UDeclaration)uField, (RefJavaElement)this, uField.getAnnotations().toArray(UElementKt.EMPTY_ARRAY));
            if (uField instanceof UEnumConstant) {
                refUtil.addReferencesTo((UDeclaration)uField, (RefJavaElement)this, new UElement[]{uField});
            }
            if (uField.getUastInitializer() != null || uField instanceof UEnumConstant) {
                this.setInitializerMasks();
            } else if (RefUtil.isImplicitWrite((PsiElement)uField.getJavaPsi())) {
                this.putUserData(IMPLICITLY_WRITTEN, true);
                this.setInitializerMasks();
            }
            if (RefUtil.isImplicitRead((PsiElement)uField.getJavaPsi())) {
                this.putUserData(IMPLICITLY_READ, true);
            }
            refUtil.addTypeReference((UElement)uField, uField.getType(), (RefManager)this.getRefManager(), (RefJavaElement)this);
            this.getRefManager().fireBuildReferences((RefElement)this);
        }
    }

    private void setInitializerMasks() {
        if (!this.checkFlag(131072L)) {
            this.setFlag(true, 262144L);
            this.setFlag(true, 131072L);
        }
    }

    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UField uField = this.getUastElement();
            return uField != null ? PsiFormatUtil.getExternalName((PsiModifierListOwner)((PsiModifierListOwner)uField.getJavaPsi())) : null;
        });
    }

    @Nullable
    static RefField fieldFromExternalName(RefManager manager, String externalName) {
        return (RefField)manager.getReference((PsiElement)RefFieldImpl.findPsiField(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiField findPsiField(PsiManager manager, String externalName) {
        String className;
        PsiClass psiClass;
        int classNameDelimiter = externalName.lastIndexOf(32);
        if (classNameDelimiter > 0 && classNameDelimiter < externalName.length() - 1 && (psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)(className = externalName.substring(0, classNameDelimiter)))) != null) {
            String fieldName = externalName.substring(classNameDelimiter + 1);
            return psiClass.findFieldByName(fieldName, false);
        }
        return null;
    }

    public boolean isSuspicious() {
        if (this.isEntry()) {
            return false;
        }
        return super.isSuspicious() || this.isUsedForReading() != this.isUsedForWriting();
    }

    protected void initialize() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reference/RefFieldImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accept$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

