/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SillyAssignmentInspection
extends AbstractBaseJavaLocalInspectionTool {
    protected LocalQuickFix createRemoveAssignmentFix(PsiReferenceExpression expression2) {
        PsiVariable variable;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasModifierProperty("final")) {
            return null;
        }
        return new RemoveSillyAssignmentFix();
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.variable.assigned.to.itself.display.name", (Object[])new Object[0]);
        if (string == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SillyAssignment" == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(1);
        }
        return "SillyAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                SillyAssignmentInspection.this.checkSillyAssignment(expression2, holder);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitVariable(PsiVariable variable) {
                PsiExpression initializer = PsiUtil.deparenthesizeExpression((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiAssignmentExpression) {
                    PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)initializer).getLExpression());
                    this.checkExpression(variable, lExpr);
                } else {
                    this.checkExpression(variable, initializer);
                }
            }

            private void checkExpression(PsiVariable variable, PsiExpression expression2) {
                if (!(expression2 instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expression2;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression || variable.hasModifierProperty("static")) && refExpr.isReferenceTo((PsiElement)variable)) {
                    holder.registerProblem((PsiElement)refExpr, InspectionsBundle.message((String)"assignment.to.declared.variable.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{SillyAssignmentInspection.this.createRemoveAssignmentFix(refExpr)});
                }
            }
        };
        if (javaElementVisitor == null) {
            SillyAssignmentInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private void checkSillyAssignment(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        PsiReferenceExpression rRef;
        if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression lExpression = assignment.getLExpression();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        if (!((lExpression = PsiUtil.deparenthesizeExpression((PsiExpression)lExpression)) instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
        PsiElement resolved = lRef.resolve();
        if (!(resolved instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)resolved;
        if (!((rExpression = SillyAssignmentInspection.deparenthesizeRExpr(rExpression, variable)) instanceof PsiReferenceExpression)) {
            if (!(rExpression instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rExpression;
            PsiExpression assignee = SillyAssignmentInspection.deparenthesizeRExpr(rAssignmentExpression.getLExpression(), variable);
            if (!(assignee instanceof PsiReferenceExpression)) {
                return;
            }
            rRef = (PsiReferenceExpression)assignee;
        } else {
            rRef = (PsiReferenceExpression)rExpression;
        }
        PsiManager manager = assignment.getManager();
        if (!SillyAssignmentInspection.sameInstanceReferences((PsiJavaCodeReferenceElement)lRef, (PsiJavaCodeReferenceElement)rRef, manager)) {
            return;
        }
        holder.registerProblem((PsiElement)rRef, InspectionsBundle.message((String)"assignment.to.itself.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{this.createRemoveAssignmentFix(rRef)});
    }

    private static PsiExpression deparenthesizeRExpr(PsiExpression rExpression, PsiVariable variable) {
        if ((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rExpression;
            PsiExpression operand2 = typeCastExpression.getOperand();
            PsiTypeElement castTypeElement = typeCastExpression.getCastType();
            if (castTypeElement == null || operand2 == null) {
                return null;
            }
            PsiType castType = castTypeElement.getType();
            if (castType instanceof PsiPrimitiveType) {
                if (variable.getType().equalsToText("java.lang.Object")) {
                    return rExpression;
                }
                if (TypeUtils.isNarrowingConversion(operand2.getType(), castType)) {
                    return null;
                }
            }
            return SillyAssignmentInspection.deparenthesizeRExpr(operand2, variable);
        }
        return rExpression;
    }

    private static boolean sameInstanceReferences(@Nullable PsiJavaCodeReferenceElement lRef, @Nullable PsiJavaCodeReferenceElement rRef, PsiManager manager) {
        boolean rThis;
        PsiElement rResolved;
        if (lRef == null && rRef == null) {
            return true;
        }
        if (lRef == null || rRef == null) {
            return false;
        }
        PsiElement lResolved = lRef.resolve();
        if (!manager.areElementsEquivalent(lResolved, rResolved = rRef.resolve())) {
            return false;
        }
        if (!(lResolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)lResolved;
        if (variable.hasModifierProperty("static")) {
            return true;
        }
        PsiElement lQualifier = lRef.getQualifier();
        PsiElement rQualifier = rRef.getQualifier();
        if (lQualifier instanceof PsiJavaCodeReferenceElement && rQualifier instanceof PsiJavaCodeReferenceElement) {
            return SillyAssignmentInspection.sameInstanceReferences((PsiJavaCodeReferenceElement)lQualifier, (PsiJavaCodeReferenceElement)rQualifier, manager);
        }
        if (Comparing.equal((Object)lQualifier, (Object)rQualifier)) {
            return true;
        }
        boolean lThis = lQualifier == null || lQualifier instanceof PsiThisExpression || lQualifier instanceof PsiSuperExpression;
        boolean bl = rThis = rQualifier == null || rQualifier instanceof PsiThisExpression || rQualifier instanceof PsiSuperExpression;
        if (lThis && rThis) {
            PsiJavaCodeReferenceElement llQualifier = SillyAssignmentInspection.getQualifier(lQualifier);
            PsiJavaCodeReferenceElement rrQualifier = SillyAssignmentInspection.getQualifier(rQualifier);
            return SillyAssignmentInspection.sameInstanceReferences(llQualifier, rrQualifier, manager);
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getQualifier(PsiElement qualifier) {
        if (qualifier instanceof PsiThisExpression) {
            PsiClass innerMostClass;
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)qualifier).getQualifier();
            if (thisQualifier != null && (innerMostClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisQualifier, PsiClass.class)) == thisQualifier.resolve()) {
                return null;
            }
            return thisQualifier;
        }
        if (qualifier != null) {
            return ((PsiSuperExpression)qualifier).getQualifier();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveSillyAssignmentFix
    implements LocalQuickFix {
        private RemoveSillyAssignmentFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"assignment.to.itself.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                RemoveSillyAssignmentFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor2.getPsiElement()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
            if (parent instanceof PsiVariable) {
                element.delete();
            }
            if (!(parent instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (PsiTreeUtil.isAncestor((PsiElement)lhs, (PsiElement)element, (boolean)false)) {
                if (rhs != null) {
                    assignmentExpression.replace((PsiElement)rhs);
                } else {
                    assignmentExpression.delete();
                }
            } else {
                PsiElement grandParent = assignmentExpression.getParent();
                if (grandParent instanceof PsiExpressionStatement) {
                    grandParent.delete();
                } else {
                    assignmentExpression.replace(element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection$RemoveSillyAssignmentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

