/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class MigrateToStreamFix
implements LocalQuickFix {
    private final BaseStreamApiMigration myMigration;

    protected MigrateToStreamFix(BaseStreamApiMigration migration) {
        this.myMigration = migration;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = "Replace with " + this.myMigration.getReplacement();
        if (string == null) {
            MigrateToStreamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with Stream API equivalent" == null) {
            MigrateToStreamFix.$$$reportNull$$$0(1);
        }
        return "Replace with Stream API equivalent";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiLoopStatement loopStatement;
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            MigrateToStreamFix.$$$reportNull$$$0(3);
        }
        if ((loopStatement = (PsiLoopStatement)ObjectUtils.tryCast((Object)descriptor2.getPsiElement(), PsiLoopStatement.class)) == null) {
            return;
        }
        StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
        PsiStatement body2 = loopStatement.getBody();
        if (body2 == null || source == null) {
            return;
        }
        TerminalBlock tb = TerminalBlock.from(source, body2);
        PsiElement result = this.myMigration.migrate(project, (PsiElement)body2, tb);
        if (result == null) {
            return;
        }
        tb.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
        MigrateToStreamFix.simplify(project, result);
    }

    static void simplify(@NotNull Project project, PsiElement result) {
        if (project == null) {
            MigrateToStreamFix.$$$reportNull$$$0(4);
        }
        if (result == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
        result = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamMigration/MigrateToStreamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

