/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FunctionHelper {
    private static final Logger LOG = Logger.getInstance(FunctionHelper.class);
    private final PsiType myResultType;

    FunctionHelper(PsiType resultType) {
        this.myResultType = resultType;
    }

    PsiType getResultType() {
        return this.myResultType;
    }

    final String getText() {
        return this.getExpression().getText();
    }

    String getStatementText() {
        return this.getText() + ";\n";
    }

    abstract PsiExpression getExpression();

    String tryLightTransform() {
        return null;
    }

    abstract void transform(StreamToLoopInspection.StreamToLoopReplacementContext var1, String ... var2);

    void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
    }

    void registerReusedElements(Consumer<? super PsiElement> consumer) {
    }

    @Nullable
    String getParameterName(int index) {
        return null;
    }

    void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
        String name2 = this.getParameterName(index);
        if (name2 != null) {
            var.addBestNameCandidate(name2);
        }
    }

    void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
    }

    List<String> suggestFinalOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, String desiredName, String worstCaseName) {
        List<String> candidates = Arrays.asList(JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, (String)desiredName, (PsiExpression)this.getExpression(), (PsiType)this.getResultType()).names);
        if (candidates.isEmpty() && worstCaseName != null) {
            candidates = Collections.singletonList(worstCaseName);
        }
        return candidates;
    }

    private static void suggestFromExpression(StreamVariable var, Project project, PsiExpression expression2) {
        SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression2, null, true);
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(info.names));
        if (expression2.getType() != null && !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(var.getType(), expression2.getType())) {
            SuggestedNameInfo byType = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, expression2.getType(), true);
            names.removeAll(Arrays.asList(byType.names));
        }
        names.forEach(var::addOtherNameCandidate);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression2, int paramCount) {
        return FunctionHelper.create(expression2, paramCount, false);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    static FunctionHelper create(PsiExpression expression2, int paramCount, boolean allowReturns) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return null;
        }
        PsiType type2 = FunctionalExpressionUtils.getFunctionalExpressionType(expression2);
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type2);
        if (interfaceMethod == null || interfaceMethod.getParameterList().getParametersCount() != paramCount) {
            return null;
        }
        PsiType returnType = interfaceMethod.getReturnType();
        if (returnType == null) {
            return null;
        }
        returnType = ((PsiClassType)type2).resolveGenerics().getSubstitutor().substitute(returnType);
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameterList list = lambda2.getParameterList();
            if (list.getParametersCount() != paramCount) {
                return null;
            }
            String[] parameters2 = (String[])StreamEx.of((Object[])list.getParameters()).map(PomNamedTarget::getName).toArray(String[]::new);
            PsiElement body2 = lambda2.getBody();
            PsiExpression lambdaExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
            if (lambdaExpression == null) {
                if (PsiType.VOID.equals((Object)returnType) && body2 instanceof PsiCodeBlock) {
                    List<PsiReturnStatement> returns = FunctionHelper.getReturns(body2);
                    if (!(allowReturns || returns.isEmpty() && ControlFlowUtils.codeBlockMayCompleteNormally((PsiCodeBlock)body2))) {
                        return null;
                    }
                    for (PsiReturnStatement ret : returns) {
                        if (PsiTreeUtil.getParentOfType((PsiElement)ret, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class}) == null) continue;
                        return null;
                    }
                    return new VoidBlockLambdaFunctionHelper((PsiCodeBlock)body2, parameters2);
                }
                return null;
            }
            return new LambdaFunctionHelper(returnType, (PsiElement)lambdaExpression, parameters2);
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            if (methodRef.resolve() == null) {
                return null;
            }
            String template = FunctionHelper.tryInlineMethodReference(paramCount, methodRef);
            if (template != null) {
                return new InlinedFunctionHelper(returnType, paramCount, template);
            }
            return new MethodReferenceFunctionHelper(returnType, type2, methodRef);
        }
        if (expression2 instanceof PsiReferenceExpression && ExpressionUtils.isSafelyRecomputableExpression(expression2)) {
            return new SimpleReferenceFunctionHelper(returnType, expression2, interfaceMethod.getName());
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.function.Function", "identity", 0)) {
                return paramCount == 1 ? new InlinedFunctionHelper(returnType, 1, "{0}") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "naturalOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{0}.compareTo({1})") : null;
            }
            if (MethodCallUtils.isCallToStaticMethod(call, "java.util.Comparator", "reverseOrder", 0) || MethodCallUtils.isCallToStaticMethod(call, "java.util.Collections", "reverseOrder", 0)) {
                return paramCount == 2 ? new InlinedFunctionHelper(returnType, 2, "{1}.compareTo({0})") : null;
            }
        }
        return new ComplexExpressionFunctionHelper(returnType, type2, interfaceMethod.getName(), expression2);
    }

    @Nullable
    private static String tryInlineMethodReference(int paramCount, PsiMethodReferenceExpression methodRef) {
        PsiElement element = methodRef.resolve();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String name2 = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                PsiExpression qualifier;
                String className = aClass.getQualifiedName();
                if ("java.util.Objects".equals(className) && paramCount == 1) {
                    if (name2.equals("nonNull")) {
                        return "{0}!=null";
                    }
                    if (name2.equals("isNull")) {
                        return "{0}==null";
                    }
                }
                if (paramCount == 2 && name2.equals("sum") && ("java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Double".equals(className))) {
                    return "{0}+{1}";
                }
                if ("java.lang.Class".equals(className) && paramCount == 1 && (qualifier = methodRef.getQualifierExpression()) instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement type2 = ((PsiClassObjectAccessExpression)qualifier).getOperand();
                    if (name2.equals("isInstance")) {
                        return "{0} instanceof " + type2.getText();
                    }
                    if (name2.equals("cast")) {
                        return "(" + type2.getText() + "){0}";
                    }
                }
            }
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    static FunctionHelper newObjectSupplier(PsiType type2, final String instanceClassName) {
        FunctionHelper functionHelper = new FunctionHelper(type2){
            PsiExpression myExpression;

            @Override
            PsiExpression getExpression() {
                return this.myExpression;
            }

            @Override
            void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
                LOG.assertTrue(argumentValues.length == 0);
                this.myExpression = context.createExpression("new " + instanceClassName + "<>()");
            }
        };
        if (functionHelper == null) {
            FunctionHelper.$$$reportNull$$$0(0);
        }
        return functionHelper;
    }

    static boolean hasVarReference(PsiElement expressionOrCodeBlock, String name2, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name2 + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body2 = lambda2.getBody();
        LOG.assertTrue(body2 != null);
        return ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body2)).findFirst() != null;
    }

    @NotNull
    static <T extends PsiElement> T replaceVarReference(@NotNull T expressionOrCodeBlock, @NotNull String name2, String replacement, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        if (expressionOrCodeBlock == null) {
            FunctionHelper.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            FunctionHelper.$$$reportNull$$$0(2);
        }
        if (name2.equals(replacement)) {
            T t = expressionOrCodeBlock;
            if (t == null) {
                FunctionHelper.$$$reportNull$$$0(3);
            }
            return t;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(name2 + "->" + expressionOrCodeBlock.getText());
        PsiParameter var = lambda2.getParameterList().getParameters()[0];
        PsiElement body2 = lambda2.getBody();
        LOG.assertTrue(body2 != null);
        PsiExpression replacementExpression = context.createExpression(replacement);
        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope(body2)).findAll()) {
            ref.getElement().replace((PsiElement)replacementExpression);
        }
        PsiElement psiElement = lambda2.getBody();
        if (psiElement == null) {
            FunctionHelper.$$$reportNull$$$0(4);
        }
        return (T)psiElement;
    }

    @NotNull
    private static List<PsiReturnStatement> getReturns(PsiElement body2) {
        final ArrayList<PsiReturnStatement> returns = new ArrayList<PsiReturnStatement>();
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
                if (returnStatement == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitReturnStatement(returnStatement);
                returns.add(returnStatement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnStatement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/FunctionHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PsiReturnStatement> arrayList = returns;
        if (arrayList == null) {
            FunctionHelper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/FunctionHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionOrCodeBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newObjectSupplier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/FunctionHelper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVarReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replaceVarReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VoidBlockLambdaFunctionHelper
    extends LambdaFunctionHelper {
        VoidBlockLambdaFunctionHelper(PsiCodeBlock body2, String[] parameters2) {
            super((PsiType)PsiType.VOID, (PsiElement)body2, parameters2);
        }

        @Override
        String getStatementText() {
            Object[] children = this.myBody.getChildren();
            return ((StreamEx)StreamEx.of((Object[])children, (int)1, (int)(children.length - 1)).dropWhile(e -> e instanceof PsiWhiteSpace)).map(PsiElement::getText).joining();
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            super.transform(context, argumentValues);
            List returns = FunctionHelper.getReturns(this.myBody);
            String continueStatement = "continue;";
            returns.forEach(ret -> ret.replace((PsiElement)context.createStatement(continueStatement)));
        }
    }

    private static class LambdaFunctionHelper
    extends FunctionHelper {
        String[] myParameters;
        PsiElement myBody;

        LambdaFunctionHelper(PsiType returnType, PsiElement body2, String[] parameters2) {
            super(returnType);
            this.myParameters = parameters2;
            this.myBody = body2;
        }

        @Override
        String tryLightTransform() {
            LOG.assertTrue(this.myParameters.length == 1);
            return this.myParameters[0];
        }

        @Override
        PsiExpression getExpression() {
            return (PsiExpression)this.myBody;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myParameters.length);
            EntryStream.zip((Object[])this.myParameters, (Object[])argumentValues).forKeyValue((oldName, newName) -> {
                this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
            });
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            int idx = ArrayUtil.indexOf((Object[])this.myParameters, (Object)newName);
            if (idx >= 0) {
                int i = 1;
                while (true) {
                    String paramName;
                    if (!((paramName = newName + '$' + i).equals(oldName) || StreamEx.of((Object[])this.myParameters).has((Object)paramName) || LambdaFunctionHelper.hasVarReference(this.myBody, paramName, context))) {
                        this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, newName, paramName, context);
                        this.myParameters[idx] = paramName;
                        break;
                    }
                    ++i;
                }
            }
            this.myBody = LambdaFunctionHelper.replaceVarReference(this.myBody, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myBody);
        }

        @Override
        String getParameterName(int index) {
            return this.myParameters[index];
        }

        @Override
        void preprocessVariable(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var, int index) {
            super.preprocessVariable(context, var, index);
            boolean hasClassOrLambda = StreamEx.ofTree((Object)this.myBody, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(e -> e instanceof PsiLambdaExpression || e instanceof PsiClass);
            if (hasClassOrLambda) {
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)context.createExpression(this.getParameterName(index) + "->" + this.myBody.getText());
                PsiParameter parameter2 = lambda2.getParameterList().getParameters()[0];
                PsiElement body2 = lambda2.getBody();
                LOG.assertTrue(body2 != null);
                boolean mayBeNotFinal = ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(body2)).allMatch(e -> PsiTreeUtil.getParentOfType((PsiElement)e.getElement(), (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) == lambda2);
                if (!mayBeNotFinal) {
                    var.markFinal();
                }
            }
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            if (this.myBody instanceof PsiExpression) {
                FunctionHelper.suggestFromExpression(var, context.getProject(), (PsiExpression)this.myBody);
            }
        }
    }

    static class InlinedFunctionHelper
    extends FunctionHelper {
        private final int myArgCount;
        private final String myTemplate;
        private PsiExpression myExpression;

        InlinedFunctionHelper(PsiType type2, int argCount, String template) {
            super(type2);
            this.myArgCount = argCount;
            this.myTemplate = template;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            LOG.assertTrue(argumentValues.length == this.myArgCount);
            this.myExpression = context.createExpression(MessageFormat.format(this.myTemplate, argumentValues));
        }
    }

    private static class SimpleReferenceFunctionHelper
    extends FunctionHelper {
        private PsiExpression myReference;
        private final String myName;
        private PsiExpression myExpression;

        SimpleReferenceFunctionHelper(PsiType returnType, PsiExpression reference, String methodName) {
            super(returnType);
            this.myReference = reference;
            this.myName = methodName;
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            this.myExpression = context.createExpression(this.myReference.getText() + "." + this.myName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myReference = SimpleReferenceFunctionHelper.replaceVarReference(this.myReference, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myReference);
        }
    }

    private static class ComplexExpressionFunctionHelper
    extends FunctionHelper {
        private final String myMethodName;
        private final String myNameCandidate;
        private final String myFnType;
        private PsiExpression myExpression;
        private PsiExpression myFinalExpression;

        private ComplexExpressionFunctionHelper(PsiType type2, PsiType functionalInterface, String name2, PsiExpression expression2) {
            super(type2);
            this.myMethodName = name2;
            this.myExpression = expression2;
            this.myNameCandidate = this.getNameCandidate(functionalInterface);
            this.myFnType = functionalInterface.getCanonicalText();
        }

        private String getNameCandidate(PsiType functionalInterface) {
            PsiElement parent = this.myExpression.getParent();
            if (parent instanceof PsiExpressionList) {
                PsiParameter[] parameters2;
                PsiMethod method;
                int idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)this.myExpression);
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiMethodCallExpression && idx >= 0 && (method = ((PsiMethodCallExpression)gParent).resolveMethod()) != null && idx < (parameters2 = method.getParameterList().getParameters()).length) {
                    return parameters2[idx].getName();
                }
            }
            return functionalInterface.getPresentableText().toLowerCase(Locale.ENGLISH);
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myFinalExpression != null);
            return this.myFinalExpression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myExpression = ComplexExpressionFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
        }

        @Override
        void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myExpression);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            String varName = context.declare(this.myNameCandidate, this.myFnType, this.myExpression.getText());
            this.myFinalExpression = context.createExpression(varName + "." + this.myMethodName + "(" + String.join((CharSequence)",", argumentValues) + ")");
        }
    }

    private static class MethodReferenceFunctionHelper
    extends FunctionHelper {
        private final PsiType myType;
        private final PsiType myQualifierType;
        private PsiMethodReferenceExpression myMethodRef;
        private PsiExpression myExpression;

        MethodReferenceFunctionHelper(PsiType returnType, PsiType functionalInterfaceType, PsiMethodReferenceExpression methodRef) {
            super(returnType);
            this.myMethodRef = methodRef;
            this.myType = functionalInterfaceType;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            this.myQualifierType = qualifier == null ? null : qualifier.getType();
        }

        @Override
        String tryLightTransform() {
            PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.createLambda(this.myMethodRef, true);
            if (lambdaExpression == null) {
                return null;
            }
            String typedParamList = LambdaRefactoringUtil.createLambdaParameterListWithFormalTypes(this.myType, lambdaExpression, false);
            if (typedParamList != null && lambdaExpression.getBody() != null) {
                lambdaExpression = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)this.myMethodRef.getProject()).createExpressionFromText(typedParamList + "->" + lambdaExpression.getBody().getText(), (PsiElement)this.myMethodRef);
            }
            this.myExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody());
            if (this.myExpression == null) {
                return null;
            }
            PsiParameterList list = lambdaExpression.getParameterList();
            if (list.getParametersCount() != 1) {
                return null;
            }
            return list.getParameters()[0].getName();
        }

        @Override
        PsiExpression getExpression() {
            LOG.assertTrue(this.myExpression != null);
            return this.myExpression;
        }

        @Override
        void registerReusedElements(Consumer<? super PsiElement> consumer) {
            consumer.accept((PsiElement)this.myMethodRef);
        }

        @Override
        void transform(StreamToLoopInspection.StreamToLoopReplacementContext context, String ... argumentValues) {
            PsiLambdaExpression lambda2;
            PsiMethodReferenceExpression methodRef = this.myMethodRef;
            PsiExpression qualifier = methodRef.getQualifierExpression();
            if (qualifier != null) {
                String qualifierText = qualifier.getText();
                if (!ExpressionUtils.isSafelyRecomputableExpression(qualifier) && this.myQualifierType != null) {
                    String nameCandidate = "expr";
                    SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, this.myQualifierType, true);
                    if (info.names.length > 0) {
                        nameCandidate = info.names[0];
                    }
                    String expr = context.declare(nameCandidate, this.myQualifierType.getCanonicalText(), qualifierText);
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)context.createExpression("(" + this.myQualifierType.getCanonicalText() + " " + expr + ")->(" + this.myType.getCanonicalText() + ")" + expr + "::" + this.myMethodRef.getReferenceName());
                    PsiTypeCastExpression castExpr = (PsiTypeCastExpression)lambdaExpression.getBody();
                    LOG.assertTrue(castExpr != null);
                    methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
                    LOG.assertTrue(methodRef != null);
                }
            }
            if ((lambda2 = LambdaRefactoringUtil.createLambda(methodRef, true)) == null) {
                throw new IllegalStateException("Unable to convert method reference to lambda: " + methodRef.getText());
            }
            this.myExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            LOG.assertTrue(this.myExpression != null);
            EntryStream.zip((Object[])lambda2.getParameterList().getParameters(), (Object[])argumentValues).forKeyValue((param, newName) -> {
                String oldName = param.getName();
                if (oldName != null) {
                    this.myExpression = MethodReferenceFunctionHelper.replaceVarReference(this.myExpression, oldName, newName, context);
                }
            });
        }

        @Override
        void suggestOutputNames(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable var) {
            PsiExpression body2;
            PsiLambdaExpression lambda2 = LambdaRefactoringUtil.createLambda(this.myMethodRef, true);
            if (lambda2 != null && (body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody())) != null) {
                FunctionHelper.suggestFromExpression(var, context.getProject(), body2);
            }
        }

        @NotNull
        private PsiMethodReferenceExpression fromText(StreamToLoopInspection.StreamToLoopReplacementContext context, String text2) {
            PsiTypeCastExpression castExpr = (PsiTypeCastExpression)context.createExpression("(" + this.myType.getCanonicalText() + ")" + text2);
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)castExpr.getOperand();
            LOG.assertTrue(methodRef != null);
            PsiMethodReferenceExpression psiMethodReferenceExpression = methodRef;
            if (psiMethodReferenceExpression == null) {
                MethodReferenceFunctionHelper.$$$reportNull$$$0(0);
            }
            return psiMethodReferenceExpression;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            if (oldName.equals(newName)) {
                return;
            }
            PsiExpression qualifier = this.myMethodRef.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            qualifier = MethodReferenceFunctionHelper.replaceVarReference(qualifier, oldName, newName, context);
            this.myMethodRef = this.fromText(context, qualifier.getText() + "::" + this.myMethodRef.getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/FunctionHelper$MethodReferenceFunctionHelper", "fromText"));
        }
    }
}

