/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.streamToLoop.ConditionalExpression;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamToLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamToLoopInspection.class);
    private static final Set<String> SUPPORTED_TERMINALS = ContainerUtil.set((Object[])new String[]{"count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet", "toImmutableList", "toImmutableSet"});
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_FOREACH = CallMatcher.instanceCall("java.util.Map", "forEach").parameterTypes("java.util.function.BiConsumer");
    public boolean SUPPORT_UNKNOWN_SOURCES = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Iterate unknown Stream sources via Stream.iterator()", (InspectionProfileEntry)this, "SUPPORT_UNKNOWN_SOURCES");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            StreamToLoopInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StreamToLoopInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression expression2 = call.getMethodExpression();
                PsiElement nameElement = expression2.getReferenceNameElement();
                if (nameElement == null || !SUPPORTED_TERMINALS.contains(nameElement.getText()) || !ControlFlowUtils.canExtractStatement((PsiExpression)call)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
                    if (StreamToLoopInspection.extractOperations(StreamVariable.STUB, call, StreamToLoopInspection.this.SUPPORT_UNKNOWN_SOURCES) != null) {
                        this.register(call, nameElement, "Replace Stream API chain with loop");
                    }
                } else if (StreamToLoopInspection.extractIterableForEach(call) != null || StreamToLoopInspection.extractMapForEach(call) != null) {
                    this.register(call, nameElement, "Replace 'forEach' call with loop");
                }
            }

            private void register(PsiMethodCallExpression call, PsiElement nameElement, String message2) {
                TextRange range = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)StreamToLoopInspection.this.getShortName(), (PsiElement)call) ? new TextRange(0, call.getTextLength()) : nameElement.getTextRange().shiftRight(-call.getTextOffset());
                holder.registerProblem((PsiElement)call, range, message2, new LocalQuickFix[]{new ReplaceStreamWithLoopFix(message2)});
            }
        };
        if (javaElementVisitor == null) {
            StreamToLoopInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Nullable
    static Operation createOperationFromCall(StreamVariable outVar, PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String name2 = method.getName();
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        PsiType callType = call.getType();
        if (callType == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream") && !method.getModifierList().hasExplicitModifier("static")) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null) {
                PsiType elementType = StreamApiUtil.getStreamElementType(qualifier.getType());
                if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)call, false)) {
                    return null;
                }
                Operation op = Operation.createIntermediate(name2, args, outVar, elementType, supportUnknownSources);
                if (op != null) {
                    return op;
                }
                op = TerminalOperation.createTerminal(name2, args, elementType, callType, ExpressionUtils.isVoidContext((PsiExpression)call));
                if (op != null) {
                    return op;
                }
            }
            return null;
        }
        return SourceOperation.createSource(call, supportUnknownSources);
    }

    private static boolean isValidElementType(PsiType elementType, PsiElement context, boolean allowRaw) {
        PsiResolveHelper helper;
        if (elementType == null || !allowRaw && elementType instanceof PsiClassType && ((PsiClassType)elementType).isRaw()) {
            return false;
        }
        return !(elementType instanceof PsiImmediateClassType) || (helper = PsiResolveHelper.SERVICE.getInstance((Project)context.getProject())).resolveReferencedClass(elementType.getCanonicalText(), context) != null;
    }

    @Nullable
    static List<OperationRecord> extractIterableForEach(PsiMethodCallExpression terminalCall) {
        if (!ITERABLE_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = terminalCall.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 1, true);
        if (fn == null) {
            return null;
        }
        PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)terminalCall, true)) {
            return null;
        }
        elementType = GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType);
        TerminalOperation.ForEachTerminalOperation terminal = new TerminalOperation.ForEachTerminalOperation(fn);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new StreamVariable(elementType);
        sourceRecord.myInVar = terminalRecord.myOutVar = StreamVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractMapForEach(PsiMethodCallExpression terminalCall) {
        if (!MAP_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = terminalCall.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 2, true);
        if (fn == null) {
            return null;
        }
        PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(keyType, (PsiElement)terminalCall, true) || !StreamToLoopInspection.isValidElementType(valueType, (PsiElement)terminalCall, true)) {
            return null;
        }
        keyType = GenericsUtil.getVariableTypeByExpressionType((PsiType)keyType);
        valueType = GenericsUtil.getVariableTypeByExpressionType((PsiType)valueType);
        Project project = terminalCall.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass entryClass = facade.findClass("java.util.Map.Entry", terminalCall.getResolveScope());
        if (entryClass == null || entryClass.getTypeParameters().length != 2) {
            return null;
        }
        PsiClassType entryType = JavaPsiFacade.getElementFactory((Project)project).createType(entryClass, new PsiType[]{keyType, valueType});
        TerminalOperation.MapForEachTerminalOperation terminal = new TerminalOperation.MapForEachTerminalOperation(fn, keyType, valueType);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier, true);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new StreamVariable((PsiType)entryType);
        sourceRecord.myInVar = terminalRecord.myOutVar = StreamVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractOperations(StreamVariable outVar, PsiMethodCallExpression terminalCall, boolean supportUnknownSources) {
        ArrayList<OperationRecord> operations = new ArrayList<OperationRecord>();
        PsiMethodCallExpression currentCall = terminalCall;
        StreamVariable lastVar = outVar;
        Operation next = null;
        Operation op;
        while ((op = StreamToLoopInspection.createOperationFromCall(lastVar, currentCall, supportUnknownSources)) != null) {
            Operation combined;
            if (next != null && (combined = op.combineWithNext(next)) != null) {
                op = combined;
                operations.remove(operations.size() - 1);
            }
            OperationRecord or = new OperationRecord();
            or.myOperation = op;
            or.myOutVar = lastVar;
            operations.add(or);
            if (op instanceof SourceOperation) {
                or.myInVar = StreamVariable.STUB;
                Collections.reverse(operations);
                return operations;
            }
            if ((currentCall = MethodCallUtils.getQualifierMethodCall(currentCall)) == null) {
                return null;
            }
            if (op.changesVariable()) {
                PsiType type2 = StreamApiUtil.getStreamElementType(currentCall.getType());
                if (type2 == null) {
                    return null;
                }
                lastVar = new StreamVariable(type2);
            }
            or.myInVar = lastVar;
            next = op;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    static TerminalOperation getTerminal(List<? extends OperationRecord> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        OperationRecord record = operations.get(operations.size() - 1);
        if (record.myOperation instanceof TerminalOperation) {
            return (TerminalOperation)record.myOperation;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OperationRecord {
        Operation myOperation;
        StreamVariable myInVar;
        StreamVariable myOutVar;

        OperationRecord() {
        }
    }

    static class StreamToLoopReplacementContext {
        private final boolean myHasNestedLoops;
        private final String mySuffix;
        private final Set<String> myUsedNames;
        private final Set<String> myUsedLabels;
        private final List<String> myBeforeSteps;
        private final List<String> myAfterSteps;
        private final CommentTracker myCommentTracker;
        private PsiElement myStreamExpression;
        private final PsiElementFactory myFactory;
        private String myLabel;
        private String myFinisher;

        StreamToLoopReplacementContext(PsiStatement statement, List<OperationRecord> records, @NotNull PsiExpression streamExpression, CommentTracker ct) {
            if (streamExpression == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(0);
            }
            this.myBeforeSteps = new ArrayList<String>();
            this.myAfterSteps = new ArrayList<String>();
            this.myFactory = JavaPsiFacade.getElementFactory((Project)streamExpression.getProject());
            this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
            this.myStreamExpression = streamExpression;
            this.mySuffix = this.myHasNestedLoops ? "Outer" : "";
            this.myCommentTracker = ct;
            this.myUsedNames = new HashSet<String>();
            this.myUsedLabels = StreamEx.iterate((Object)statement, Objects::nonNull, PsiElement::getParent).select(PsiLabeledStatement.class).map(PsiLabeledStatement::getName).toSet();
        }

        StreamToLoopReplacementContext(StreamToLoopReplacementContext parentContext, List<OperationRecord> records) {
            this.myBeforeSteps = new ArrayList<String>();
            this.myAfterSteps = new ArrayList<String>();
            this.myUsedNames = parentContext.myUsedNames;
            this.myUsedLabels = parentContext.myUsedLabels;
            this.myStreamExpression = parentContext.myStreamExpression;
            this.myFactory = parentContext.myFactory;
            this.myCommentTracker = parentContext.myCommentTracker;
            this.myHasNestedLoops = records.stream().anyMatch(or -> or.myOperation instanceof Operation.FlatMapOperation);
            this.mySuffix = "Inner";
        }

        public void registerReusedElement(@Nullable PsiElement element) {
            if (element == null) {
                return;
            }
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    myUsedNames.add(variable.getName());
                }
            });
            this.myCommentTracker.markUnchanged(element);
        }

        @Nullable
        private String allocateLabel() {
            if (!this.myHasNestedLoops) {
                return null;
            }
            if (this.myLabel == null) {
                String base = this.mySuffix.toUpperCase(Locale.ENGLISH);
                this.myLabel = (String)((StreamEx)IntStreamEx.ints().mapToObj(i -> i == 0 ? base : base + i).remove(this.myUsedLabels::contains)).findFirst().orElseThrow(IllegalArgumentException::new);
                this.myUsedLabels.add(this.myLabel);
            }
            return this.myLabel;
        }

        public String getLoopLabel() {
            return this.myLabel == null ? "" : this.myLabel + ":\n";
        }

        public String getBreakStatement() {
            String label = this.allocateLabel();
            return label == null ? "break;\n" : "break " + label + ";\n";
        }

        public String registerVarName(Collection<String> variants) {
            if (variants.isEmpty()) {
                return this.registerVarName(Collections.singleton("val"));
            }
            int idx = 0;
            while (true) {
                for (String variant : variants) {
                    String name2 = idx == 0 ? variant : variant + idx;
                    if (this.isUsed(name2)) continue;
                    this.myUsedNames.add(name2);
                    return name2;
                }
                ++idx;
            }
        }

        private boolean isUsed(String varName) {
            return this.myUsedNames.contains(varName) || JavaLexer.isKeyword(varName, LanguageLevel.HIGHEST) || !varName.equals(JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestUniqueVariableName(varName, this.myStreamExpression, v -> PsiTreeUtil.isAncestor((PsiElement)this.myStreamExpression, (PsiElement)v, (boolean)true)));
        }

        public String declare(String desiredName, String type2, String initializer) {
            String name2 = this.registerVarName(this.mySuffix.isEmpty() ? Collections.singleton(desiredName) : Arrays.asList(desiredName, desiredName + this.mySuffix));
            this.myBeforeSteps.add(type2 + " " + name2 + " = " + initializer + ";");
            return name2;
        }

        public void addBeforeStep(String beforeStatement) {
            this.myBeforeSteps.add(beforeStatement);
        }

        public void addAfterStep(String afterStatement) {
            this.myAfterSteps.add(0, afterStatement);
        }

        public String drainAfterSteps() {
            String afterSteps = String.join((CharSequence)"", this.myAfterSteps);
            this.myAfterSteps.clear();
            return afterSteps;
        }

        public String drainBeforeSteps() {
            String beforeSteps = String.join((CharSequence)"", this.myBeforeSteps);
            this.myBeforeSteps.clear();
            return beforeSteps;
        }

        public String declareResult(String desiredName, PsiType type2, String initializer, @NotNull ResultKind kind2) {
            if (kind2 == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(1);
            }
            return this.declareResult(desiredName, type2, null, initializer, kind2);
        }

        public String declareResult(String desiredName, PsiType type2, String mostAbstractAllowedType, String initializer, @NotNull ResultKind kind2) {
            PsiDeclarationStatement declaration2;
            PsiVariable var;
            if (kind2 == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(2);
            }
            if (kind2 != ResultKind.UNKNOWN && this.myStreamExpression.getParent() instanceof PsiVariable && StreamToLoopReplacementContext.isCompatibleType(var = (PsiVariable)this.myStreamExpression.getParent(), type2, mostAbstractAllowedType) && var.getParent() instanceof PsiDeclarationStatement && (kind2 == ResultKind.FINAL || StreamToLoopReplacementContext.canUseAsNonFinal(var)) && (declaration2 = (PsiDeclarationStatement)var.getParent()).getDeclaredElements().length == 1) {
                PsiModifierList modifierList;
                this.myStreamExpression = declaration2;
                PsiVariable copy = (PsiVariable)var.copy();
                if (kind2 == ResultKind.NON_FINAL && (modifierList = copy.getModifierList()) != null) {
                    modifierList.setModifierProperty("final", false);
                }
                PsiExpression oldInitializer = copy.getInitializer();
                LOG.assertTrue(oldInitializer != null);
                oldInitializer.replace((PsiElement)this.createExpression(initializer));
                this.myBeforeSteps.add(copy.getText());
                return var.getName();
            }
            String name2 = this.registerVarName(Arrays.asList(desiredName, "result"));
            this.myBeforeSteps.add(type2.getCanonicalText() + " " + name2 + " = " + initializer + ";");
            if (this.myFinisher != null) {
                throw new IllegalStateException("Finisher is already defined");
            }
            this.setFinisher(name2);
            return name2;
        }

        public boolean tryUnwrapOrElse(@NotNull Number wantedValue) {
            if (wantedValue == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(3);
            }
            if (!(this.myStreamExpression instanceof PsiExpression)) {
                return false;
            }
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myStreamExpression);
            if (call == null || call.getParent() instanceof PsiExpressionStatement || !"orElse".equals(call.getMethodExpression().getReferenceName())) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length == 1 && wantedValue.equals(ExpressionUtils.computeConstantExpression(args[0]))) {
                this.myStreamExpression = call;
                return true;
            }
            return false;
        }

        private static boolean isCompatibleType(@NotNull PsiVariable var, @NotNull PsiType type2, @Nullable String mostAbstractAllowedType) {
            if (var == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(4);
            }
            if (type2 == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(5);
            }
            if (EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(var.getType(), type2)) {
                return true;
            }
            if (mostAbstractAllowedType == null) {
                return false;
            }
            PsiType[] superTypes = type2.getSuperTypes();
            return Arrays.stream(superTypes).anyMatch(superType -> {
                if (var == null) {
                    StreamToLoopReplacementContext.$$$reportNull$$$0(9);
                }
                return InheritanceUtil.isInheritor((PsiType)superType, (String)mostAbstractAllowedType) && StreamToLoopReplacementContext.isCompatibleType(var, superType, mostAbstractAllowedType);
            });
        }

        @Contract(value="null -> false")
        private static boolean canUseAsNonFinal(PsiVariable var) {
            if (!(var instanceof PsiLocalVariable)) {
                return false;
            }
            PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)var, null);
            return block != null && ReferencesSearch.search((PsiElement)var).allMatch(ref -> {
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                return context == null || PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)block, (boolean)false);
            });
        }

        public PsiElement makeFinalReplacement() {
            LOG.assertTrue(this.myStreamExpression != null);
            if (this.myFinisher == null || this.myStreamExpression instanceof PsiStatement) {
                PsiElement toDelete = this.myStreamExpression;
                if (toDelete instanceof PsiExpression && toDelete.getParent() instanceof PsiExpressionStatement) {
                    toDelete = toDelete.getParent();
                    while (toDelete instanceof PsiExpressionStatement && toDelete.getParent() instanceof PsiLabeledStatement) {
                        toDelete = toDelete.getParent();
                    }
                }
                this.myCommentTracker.delete(toDelete);
                return null;
            }
            PsiExpression expression2 = this.myFactory.createExpressionFromText(this.myFinisher, this.myStreamExpression);
            PsiElement parent = this.myStreamExpression.getParent();
            if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(expression2, (PsiExpression)parent, false)) {
                expression2 = this.myFactory.createExpressionFromText("(" + this.myFinisher + ")", this.myStreamExpression);
            }
            return this.myCommentTracker.replace(this.myStreamExpression, (PsiElement)expression2);
        }

        public void setFinisher(String finisher) {
            this.myFinisher = finisher;
        }

        public void setFinisher(ConditionalExpression conditionalExpression) {
            if (conditionalExpression instanceof ConditionalExpression.Optional) {
                conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, true);
            }
            this.setFinisher(conditionalExpression.asExpression());
        }

        public String assignAndBreak(ConditionalExpression conditionalExpression) {
            FunctionHelper fn;
            PsiExpression[] args;
            PsiMethodCallExpression call;
            PsiIfStatement ifStatement;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myStreamExpression, PsiStatement.class);
            boolean inReturn = statement instanceof PsiReturnStatement;
            if (conditionalExpression instanceof ConditionalExpression.Optional) {
                conditionalExpression = this.tryUnwrapOptional((ConditionalExpression.Optional)conditionalExpression, inReturn);
            }
            if (conditionalExpression instanceof ConditionalExpression.Boolean) {
                conditionalExpression = this.tryUnwrapBoolean((ConditionalExpression.Boolean)conditionalExpression, inReturn);
            }
            if (inReturn) {
                this.setFinisher(conditionalExpression.getFalseBranch());
                Object mark = new Object();
                PsiTreeUtil.mark((PsiElement)this.myStreamExpression, (Object)mark);
                PsiElement returnCopy = statement.copy();
                PsiElement placeHolderCopy = PsiTreeUtil.releaseMark((PsiElement)returnCopy, (Object)mark);
                LOG.assertTrue(placeHolderCopy != null);
                PsiElement replacement = placeHolderCopy.replace((PsiElement)this.createExpression(conditionalExpression.getTrueBranch()));
                return (placeHolderCopy == returnCopy ? replacement : returnCopy).getText();
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myStreamExpression.getParent());
            if (parent instanceof PsiIfStatement && conditionalExpression instanceof ConditionalExpression.Boolean && !((ConditionalExpression.Boolean)conditionalExpression).isInverted() && (ifStatement = (PsiIfStatement)parent).getElseBranch() == null) {
                PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                if (thenStatement instanceof PsiReturnStatement || thenStatement instanceof PsiThrowStatement) {
                    this.myStreamExpression = parent;
                    return thenStatement.getText();
                }
                if (thenStatement instanceof PsiExpressionStatement) {
                    this.myStreamExpression = parent;
                    return thenStatement.getText() + "\n" + this.getBreakStatement();
                }
            }
            if (conditionalExpression instanceof ConditionalExpression.Optional && this.myStreamExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myStreamExpression)) != null && call.getParent() instanceof PsiExpressionStatement && (args = call.getArgumentList().getExpressions()).length == 1 && "ifPresent".equals(call.getMethodExpression().getReferenceName()) && (fn = FunctionHelper.create(args[0], 1)) != null) {
                fn.transform(this, ((ConditionalExpression.Optional)conditionalExpression).unwrap("").getTrueBranch());
                this.myStreamExpression = call.getParent();
                return fn.getStatementText() + this.getBreakStatement();
            }
            String found = this.declareResult(conditionalExpression.getCondition(), this.createType(conditionalExpression.getType()), conditionalExpression.getFalseBranch(), ResultKind.NON_FINAL);
            return found + " = " + conditionalExpression.getTrueBranch() + ";\n" + this.getBreakStatement();
        }

        private ConditionalExpression tryUnwrapBoolean(ConditionalExpression.Boolean condition2, boolean unwrapLazilyEvaluated) {
            if (this.myStreamExpression instanceof PsiExpression) {
                PsiConditionalExpression ternary;
                PsiExpression negation = BoolUtils.findNegation((PsiExpression)this.myStreamExpression);
                if (negation != null) {
                    this.myStreamExpression = negation;
                    condition2 = condition2.negate();
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)this.myStreamExpression.getParent());
                ConditionalExpression candidate = null;
                if (parent instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression expression2 = (PsiPolyadicExpression)parent;
                    Object[] operands2 = expression2.getOperands();
                    if (operands2.length > 1 && PsiTreeUtil.isAncestor((PsiElement)operands2[0], (PsiElement)this.myStreamExpression, (boolean)false)) {
                        IElementType type2 = expression2.getOperationTokenType();
                        if (type2.equals(JavaTokenType.ANDAND)) {
                            candidate = condition2.toPlain((PsiType)PsiType.BOOLEAN, StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" && "), "false");
                        } else if (type2.equals(JavaTokenType.OROR)) {
                            candidate = condition2.toPlain((PsiType)PsiType.BOOLEAN, "true", StreamEx.of((Object[])operands2, (int)1, (int)operands2.length).map(PsiElement::getText).joining((CharSequence)" || "));
                        }
                    }
                } else if (parent instanceof PsiConditionalExpression && PsiTreeUtil.isAncestor((PsiElement)(ternary = (PsiConditionalExpression)parent).getCondition(), (PsiElement)this.myStreamExpression, (boolean)false)) {
                    PsiType type3 = ternary.getType();
                    PsiExpression thenExpression2 = ternary.getThenExpression();
                    PsiExpression elseExpression2 = ternary.getElseExpression();
                    if (type3 != null && thenExpression2 != null && elseExpression2 != null) {
                        candidate = condition2.toPlain(type3, thenExpression2.getText(), elseExpression2.getText());
                    }
                }
                if (candidate != null && (unwrapLazilyEvaluated || ExpressionUtils.isSafelyRecomputableExpression(this.createExpression(candidate.getFalseBranch())))) {
                    this.myStreamExpression = parent;
                    return candidate;
                }
            }
            return condition2;
        }

        @NotNull
        private ConditionalExpression tryUnwrapOptional(ConditionalExpression.Optional condition2, boolean unwrapLazilyEvaluated) {
            PsiMethodCallExpression call;
            if (this.myStreamExpression instanceof PsiExpression && (call = ExpressionUtils.getCallForQualifier((PsiExpression)this.myStreamExpression)) != null && !(call.getParent() instanceof PsiExpressionStatement)) {
                String name2 = call.getMethodExpression().getReferenceName();
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0 && "isPresent".equals(name2)) {
                    this.myStreamExpression = call;
                    ConditionalExpression.Boolean boolean_ = new ConditionalExpression.Boolean(condition2.getCondition(), false);
                    if (boolean_ == null) {
                        StreamToLoopReplacementContext.$$$reportNull$$$0(6);
                    }
                    return boolean_;
                }
                if (args.length == 1) {
                    FunctionHelper helper;
                    String absentExpression = null;
                    if ("orElse".equals(name2)) {
                        absentExpression = args[0].getText();
                    } else if (unwrapLazilyEvaluated && "orElseGet".equals(name2) && (helper = FunctionHelper.create(args[0], 0)) != null) {
                        helper.transform(this, new String[0]);
                        absentExpression = helper.getText();
                    }
                    if (absentExpression != null) {
                        this.myStreamExpression = call;
                        ConditionalExpression.Plain plain = condition2.unwrap(absentExpression);
                        if (plain == null) {
                            StreamToLoopReplacementContext.$$$reportNull$$$0(7);
                        }
                        return plain;
                    }
                }
            }
            ConditionalExpression.Optional optional = condition2;
            if (optional == null) {
                StreamToLoopReplacementContext.$$$reportNull$$$0(8);
            }
            return optional;
        }

        public Project getProject() {
            return this.myStreamExpression.getProject();
        }

        public PsiExpression createExpression(String text2) {
            return this.myFactory.createExpressionFromText(text2, this.myStreamExpression);
        }

        public PsiStatement createStatement(String text2) {
            return this.myFactory.createStatementFromText(text2, this.myStreamExpression);
        }

        public PsiType createType(String text2) {
            return this.myFactory.createTypeFromText(text2, this.myStreamExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "streamExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wantedValue";
                    break;
                }
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$StreamToLoopReplacementContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$StreamToLoopReplacementContext";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryUnwrapOptional";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "declareResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tryUnwrapOrElse";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompatibleType";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$isCompatibleType$4";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum ResultKind {
        FINAL,
        NON_FINAL,
        UNKNOWN;

    }

    static class ReplaceStreamWithLoopFix
    implements LocalQuickFix {
        private final String myMessage;

        ReplaceStreamWithLoopFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Stream API chain with loop" == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(1);
            }
            return "Replace Stream API chain with loop";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            TerminalOperation terminal;
            PsiElement element;
            if (project == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor2.getStartElement()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)element;
            if (!ControlFlowUtils.canExtractStatement((PsiExpression)terminalCall)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if ((terminalCall = RefactoringUtil.ensureCodeBlock(terminalCall)) == null) {
                return;
            }
            PsiType resultType = terminalCall.getType();
            if (resultType == null) {
                return;
            }
            List<OperationRecord> operations = StreamToLoopInspection.extractOperations(StreamVariable.STUB, terminalCall, true);
            if (operations == null) {
                operations = StreamToLoopInspection.extractIterableForEach(terminalCall);
            }
            if (operations == null) {
                operations = StreamToLoopInspection.extractMapForEach(terminalCall);
            }
            if ((terminal = StreamToLoopInspection.getTerminal(operations)) == null) {
                return;
            }
            PsiStatement statement = (PsiStatement)ObjectUtils.tryCast((Object)RefactoringUtil.getParentStatement((PsiElement)terminalCall, false), PsiStatement.class);
            LOG.assertTrue(statement != null);
            CommentTracker ct = new CommentTracker();
            try {
                StreamToLoopReplacementContext context = new StreamToLoopReplacementContext(statement, operations, (PsiExpression)terminalCall, ct);
                ReplaceStreamWithLoopFix.registerVariables(operations, context);
                String replacement = "";
                for (PsiStatement[] or : StreamEx.ofReversed(operations)) {
                    replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, context);
                }
                PsiElement firstAdded = null;
                for (PsiStatement addedStatement : ((PsiBlockStatement)factory.createStatementFromText("{" + replacement + "}", (PsiElement)statement)).getCodeBlock().getStatements()) {
                    PsiElement res = ReplaceStreamWithLoopFix.addStatement(project, statement, addedStatement);
                    if (firstAdded != null) continue;
                    firstAdded = res;
                }
                PsiElement result = context.makeFinalReplacement();
                if (result != null) {
                    result = ReplaceStreamWithLoopFix.normalize(project, result);
                    if (firstAdded == null) {
                        firstAdded = result;
                    }
                }
                if (firstAdded != null) {
                    ct.insertCommentsBefore(firstAdded);
                }
            }
            catch (Exception ex) {
                LOG.error("Error converting Stream to loop", (Throwable)ex, new Attachment[]{new Attachment("Stream_code.txt", terminalCall.getText())});
            }
        }

        private static PsiElement addStatement(@NotNull Project project, PsiStatement statement, PsiStatement context) {
            if (project == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(4);
            }
            PsiElement element = statement.getParent().addBefore((PsiElement)context, (PsiElement)statement);
            return ReplaceStreamWithLoopFix.normalize(project, element);
        }

        private static PsiElement normalize(@NotNull Project project, PsiElement element) {
            if (project == null) {
                ReplaceStreamWithLoopFix.$$$reportNull$$$0(5);
            }
            element = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(element);
            RedundantCastUtil.getRedundantCastsInside((PsiElement)element).forEach(RemoveRedundantCastUtil::removeCast);
            return element;
        }

        private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
            return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
        }

        private static void registerVariables(List<OperationRecord> operations, StreamToLoopReplacementContext context) {
            ReplaceStreamWithLoopFix.allOperations(operations).forEach(or -> or.myOperation.preprocessVariables(context, or.myInVar, or.myOutVar));
            ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myOperation).forEach(op -> op.registerReusedElements(context::registerReusedElement));
            ((StreamEx)ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myInVar).distinct()).forEach(var -> var.register(context));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$ReplaceStreamWithLoopFix";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/streamToLoop/StreamToLoopInspection$ReplaceStreamWithLoopFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "normalize";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

