/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.task.ProjectTaskManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CompileAction
extends CompileActionBase {
    private static final String RECOMPILE_FILES_ID_MOD = "CompileFile";

    @Override
    protected void doAction(DataContext dataContext, Project project) {
        Module module = (Module)dataContext.getData(LangDataKeys.MODULE_CONTEXT);
        if (module != null) {
            ProjectTaskManager.getInstance((Project)project).rebuild(new Module[]{module});
        } else {
            VirtualFile[] files = CompileAction.getCompilableFiles(project, (VirtualFile[])dataContext.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
            if (files.length > 0) {
                ProjectTaskManager.getInstance((Project)project).compile(files);
            }
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompileAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        presentation.setText(ActionsBundle.actionText((String)RECOMPILE_FILES_ID_MOD));
        presentation.setVisible(true);
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        Module module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        boolean forFiles = false;
        VirtualFile[] files = CompileAction.getCompilableFiles(project, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        if (module == null && files.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(!ActionPlaces.isPopupPlace((String)e.getPlace()));
            return;
        }
        String elementDescription = null;
        if (module != null) {
            elementDescription = CompilerBundle.message((String)"action.compile.description.module", (Object[])new Object[]{module.getName()});
        } else {
            PsiPackage aPackage = null;
            if (files.length == 1) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(files[0]);
                if (directory != null) {
                    aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                }
            } else {
                PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
                if (element instanceof PsiPackage) {
                    aPackage = (PsiPackage)element;
                }
            }
            if (aPackage != null) {
                String name2 = aPackage.getQualifiedName();
                if (name2.length() == 0) {
                    name2 = "<default>";
                }
                elementDescription = "'" + name2 + "'";
            } else if (files.length == 1) {
                forFiles = true;
                VirtualFile file = files[0];
                FileType fileType = file.getFileType();
                if (CompilerManager.getInstance((Project)project).isCompilableFileType(fileType) || compilerConfiguration.isCompilableResourceFile(project, file)) {
                    elementDescription = "'" + file.getName() + "'";
                } else if (!ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
            } else {
                forFiles = true;
                elementDescription = CompilerBundle.message((String)"action.compile.description.selected.files", (Object[])new Object[0]);
            }
        }
        if (elementDescription == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(CompileAction.createPresentationText(elementDescription, forFiles), true);
        presentation.setEnabled(true);
    }

    private static String createPresentationText(String elementDescription, boolean forFiles) {
        StringBuilder buffer = new StringBuilder(40);
        buffer.append(ActionsBundle.actionText((String)(forFiles ? RECOMPILE_FILES_ID_MOD : "Compile"))).append(" ");
        int length = elementDescription.length();
        if (length > 23) {
            if (StringUtil.startsWithChar((CharSequence)elementDescription, (char)'\'')) {
                buffer.append("'");
            }
            buffer.append("...");
            buffer.append(elementDescription, length - 20, length);
        } else {
            buffer.append(elementDescription);
        }
        return buffer.toString();
    }

    private static VirtualFile[] getCompilableFiles(Project project, VirtualFile[] files) {
        if (files == null || files.length == 0) {
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            FileType fileType;
            PsiDirectory directory;
            if (!fileIndex.isInSourceContent(file) || !file.isInLocalFileSystem() || (file.isDirectory() ? (directory = psiManager.findDirectory(file)) == null || JavaDirectoryService.getInstance().getPackage(directory) == null : !compilerManager.isCompilableFileType(fileType = file.getFileType()) && !compilerConfiguration.isCompilableResourceFile(project, file))) continue;
            filesToCompile.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(filesToCompile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/actions/CompileAction", "update"));
    }
}

