/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArtifactAntGenerationContextImpl
implements ArtifactAntGenerationContext {
    @NonNls
    public static final String ARTIFACTS_TEMP_DIR_PROPERTY = "artifacts.temp.dir";
    private final Map<Artifact, String> myArtifact2Target = new THashMap();
    private final List<Generator> myBeforeBuildGenerators = new ArrayList<Generator>();
    private final List<Generator> myAfterBuildGenerators = new ArrayList<Generator>();
    private final Set<String> myTempFileNames = new THashSet();
    private final Set<String> myCreatedTempSubdirs = new THashSet();
    private final Set<String> myProperties = new LinkedHashSet<String>();
    private final Project myProject;
    private final GenerationOptions myGenerationOptions;
    private final List<Generator> myBeforeCurrentArtifact = new ArrayList<Generator>();
    private final Set<Artifact> myArtifactsToClean = new THashSet();

    public ArtifactAntGenerationContextImpl(Project project, GenerationOptions generationOptions, List<Artifact> allArtifacts) {
        this.myProject = project;
        this.myGenerationOptions = generationOptions;
        for (Artifact artifact : allArtifacts) {
            if (!ArtifactUtil.shouldClearArtifactOutputBeforeRebuild(artifact)) continue;
            this.myArtifactsToClean.add(artifact);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public GenerationOptions getGenerationOptions() {
        return this.myGenerationOptions;
    }

    public String getConfiguredArtifactOutputProperty(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.$$$reportNull$$$0(0);
        }
        return "artifact.output." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getArtifactOutputProperty(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.$$$reportNull$$$0(1);
        }
        if (this.shouldBuildIntoTempDirectory(artifact)) {
            return "artifact.temp.output." + BuildProperties.convertName((String)artifact.getName());
        }
        return this.getConfiguredArtifactOutputProperty(artifact);
    }

    public boolean shouldBuildIntoTempDirectory(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.$$$reportNull$$$0(2);
        }
        return !this.myArtifactsToClean.contains(artifact);
    }

    public String getCleanTargetName(@NotNull Artifact artifact) {
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.$$$reportNull$$$0(3);
        }
        return "clean.artifact." + BuildProperties.convertName((String)artifact.getName());
    }

    public String getTargetName(@NotNull Artifact artifact) {
        String target;
        if (artifact == null) {
            ArtifactAntGenerationContextImpl.$$$reportNull$$$0(4);
        }
        if ((target = this.myArtifact2Target.get(artifact)) == null) {
            target = ArtifactAntGenerationContextImpl.generateTargetName(artifact.getName());
            this.myArtifact2Target.put(artifact, target);
        }
        return target;
    }

    private static String generateTargetName(String artifactName) {
        return "artifact." + BuildProperties.convertName((String)artifactName);
    }

    public String getSubstitutedPath(String path) {
        return GenerationUtils.toRelativePath((String)path, (File)VfsUtil.virtualToIoFile((VirtualFile)this.myProject.getBaseDir()), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)this.myGenerationOptions);
    }

    public void runBeforeCurrentArtifact(Generator generator) {
        this.myBeforeCurrentArtifact.add(generator);
    }

    public void runBeforeBuild(Generator generator) {
        this.myBeforeBuildGenerators.add(generator);
    }

    public void runAfterBuild(Generator generator) {
        this.myAfterBuildGenerators.add(generator);
    }

    public String createNewTempFileProperty(String basePropertyName, String fileName) {
        String tempFileName = fileName;
        int i = 1;
        String tempSubdir = null;
        while (this.myTempFileNames.contains(tempFileName)) {
            tempSubdir = String.valueOf(i++);
            tempFileName = tempSubdir + "/" + fileName;
        }
        String propertyName = basePropertyName;
        i = 2;
        while (this.myProperties.contains(propertyName)) {
            propertyName = basePropertyName + i++;
        }
        this.runBeforeBuild((Generator)new Property(propertyName, BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)tempFileName)));
        if (tempSubdir != null && this.myCreatedTempSubdirs.add(tempSubdir)) {
            this.runBeforeBuild((Generator)new Mkdir(BuildProperties.propertyRelativePath((String)ARTIFACTS_TEMP_DIR_PROPERTY, (String)tempSubdir)));
        }
        this.myTempFileNames.add(tempFileName);
        this.myProperties.add(propertyName);
        return propertyName;
    }

    public Generator[] getAndClearBeforeCurrentArtifact() {
        Generator[] generators = this.myBeforeCurrentArtifact.toArray(new Generator[0]);
        this.myBeforeCurrentArtifact.clear();
        return generators;
    }

    public String getModuleOutputPath(String moduleName) {
        return BuildProperties.getOutputPathProperty((String)moduleName);
    }

    public String getModuleTestOutputPath(@NonNls String moduleName) {
        return BuildProperties.getOutputPathForTestsProperty((String)moduleName);
    }

    public List<Generator> getBeforeBuildGenerators() {
        return this.myBeforeBuildGenerators;
    }

    public List<Generator> getAfterBuildGenerators() {
        return this.myAfterBuildGenerators;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "artifact";
        objectArray2[1] = "com/intellij/compiler/ant/artifacts/ArtifactAntGenerationContextImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguredArtifactOutputProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getArtifactOutputProperty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBuildIntoTempDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCleanTargetName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

