/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OccurrenceCounter<T> {
    private final TObjectIntHashMap<T> myOccurrenceMap = new TObjectIntHashMap();
    private T myBest;
    private int myBestOccurrences;

    OccurrenceCounter() {
    }

    void add(@NotNull T element) {
        int prevOccurrences;
        if (element == null) {
            OccurrenceCounter.$$$reportNull$$$0(0);
        }
        if ((prevOccurrences = this.myOccurrenceMap.get(element)) == 0) {
            this.myOccurrenceMap.put(element, 1);
        } else {
            this.myOccurrenceMap.adjustValue(element, 1);
        }
        if (this.myBest == null) {
            this.myBestOccurrences = 1;
            this.myBest = element;
        } else if (this.myBest.equals(element)) {
            ++this.myBestOccurrences;
        } else {
            this.myBestOccurrences = prevOccurrences + 1;
            this.myBest = element;
        }
    }

    @Nullable
    T getBest() {
        return this.myBest;
    }

    int getBestOccurrences() {
        return this.myBestOccurrences;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/OccurrenceCounter", "add"));
    }
}

