/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Comparator;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodChainsSearchUtil {
    private MethodChainsSearchUtil() {
    }

    @Nullable
    public static PsiMethod getMethodWithMinNotPrimitiveParameters(@NotNull PsiMethod[] methods, @NotNull PsiClass target) {
        if (methods == null) {
            MethodChainsSearchUtil.$$$reportNull$$$0(0);
        }
        if (target == null) {
            MethodChainsSearchUtil.$$$reportNull$$$0(1);
        }
        return Stream.of(methods).filter(m -> {
            if (target == null) {
                MethodChainsSearchUtil.$$$reportNull$$$0(2);
            }
            for (PsiParameter parameter2 : m.getParameterList().getParameters()) {
                PsiType t = parameter2.getType();
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)t);
                if (aClass != target) continue;
                return false;
            }
            return true;
        }).min(Comparator.comparing(MethodChainsSearchUtil::getNonPrimitiveParameterCount)).orElse(null);
    }

    private static int getNonPrimitiveParameterCount(PsiMethod method) {
        return (int)Stream.of(method.getParameterList().getParameters()).map(p -> p.getType()).filter(t -> !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)t)).count();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/chainsSearch/MethodChainsSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodWithMinNotPrimitiveParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getMethodWithMinNotPrimitiveParameters$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

