/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationChain {
    private static final Logger LOG = Logger.getInstance(OperationChain.class);
    @NotNull
    private final ChainOperation[] myReverseOperations;
    private final RefChainOperation myHeadOperation;
    private final MethodCall myHeadMethodCall;
    private final int myWeight;
    private final PsiClass myQualifierClass;

    @Nullable
    public static OperationChain create(@NotNull RefChainOperation operation, int weight, @NotNull ChainCompletionContext context) {
        if (operation == null) {
            OperationChain.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OperationChain.$$$reportNull$$$0(1);
        }
        if (operation instanceof MethodCall) {
            PsiClass contextClass;
            MethodCall signature = (MethodCall)operation;
            PsiClass qualifier = context.resolvePsiClass(signature.getQualifierDef());
            if (qualifier == null || !signature.isStatic() && InheritanceUtil.isInheritorOrSelf((PsiClass)context.getTarget().getTargetClass(), (PsiClass)qualifier, (boolean)true)) {
                return null;
            }
            PsiMethod[] methods = context.resolve(signature);
            if (methods.length == 0) {
                return null;
            }
            Set classes2 = Arrays.stream(methods).flatMap(m -> Arrays.stream(m.getParameterList().getParameters())).map(p -> PsiUtil.resolveClassInType((PsiType)p.getType())).collect(Collectors.toSet());
            if (classes2.contains(contextClass = context.getTarget().getTargetClass())) {
                return null;
            }
            classes2.add(contextClass);
            return new OperationChain(qualifier, new ChainOperation[]{new ChainOperation.MethodCall(methods)}, signature, signature, weight);
        }
        TypeCast cast = (TypeCast)operation;
        PsiClass operand2 = context.resolvePsiClass(cast.getCompilerRef());
        PsiClass castType = context.resolvePsiClass(cast.getCastTypeRef());
        if (operand2 == null || castType == null) {
            return null;
        }
        return new OperationChain(operand2, new ChainOperation[]{new ChainOperation.TypeCast(operand2, castType)}, cast, null, weight);
    }

    private OperationChain(@NotNull PsiClass qualifierClass, @NotNull ChainOperation[] reverseOperations, RefChainOperation signature, MethodCall headMethodSign, int weight) {
        if (qualifierClass == null) {
            OperationChain.$$$reportNull$$$0(2);
        }
        if (reverseOperations == null) {
            OperationChain.$$$reportNull$$$0(3);
        }
        this.myQualifierClass = qualifierClass;
        this.myReverseOperations = reverseOperations;
        this.myHeadOperation = signature;
        this.myHeadMethodCall = headMethodSign;
        this.myWeight = weight;
    }

    public boolean hasCast() {
        return Arrays.stream(this.myReverseOperations).anyMatch(op -> op instanceof ChainOperation.TypeCast);
    }

    @Nullable
    public MethodCall getHeadMethodCall() {
        return this.myHeadMethodCall;
    }

    @NotNull
    public RefChainOperation getHead() {
        RefChainOperation refChainOperation = this.myHeadOperation;
        if (refChainOperation == null) {
            OperationChain.$$$reportNull$$$0(4);
        }
        return refChainOperation;
    }

    public int length() {
        return this.myReverseOperations.length;
    }

    public PsiClass getQualifierClass() {
        return this.myQualifierClass;
    }

    @NotNull
    public PsiMethod[] getFirst() {
        PsiMethod[] psiMethodArray = ((ChainOperation.MethodCall)this.myReverseOperations[0]).getCandidates();
        if (psiMethodArray == null) {
            OperationChain.$$$reportNull$$$0(5);
        }
        return psiMethodArray;
    }

    public ChainOperation[] getPath() {
        return (ChainOperation[])ArrayUtil.reverseArray((Object[])this.myReverseOperations);
    }

    public int getChainWeight() {
        return this.myWeight;
    }

    @Nullable
    OperationChain continuationWithMethod(@NotNull MethodCall signature, int weight, @NotNull ChainCompletionContext context) {
        OperationChain head;
        if (signature == null) {
            OperationChain.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OperationChain.$$$reportNull$$$0(7);
        }
        if ((head = OperationChain.create(signature, weight, context)) == null) {
            return null;
        }
        ChainOperation[] newReverseOperations = new ChainOperation[this.length() + 1];
        System.arraycopy(this.myReverseOperations, 0, newReverseOperations, 0, this.myReverseOperations.length);
        newReverseOperations[this.length()] = head.getPath()[0];
        return new OperationChain(head.getQualifierClass(), newReverseOperations, head.getHead(), signature, Math.min(weight, this.getChainWeight()));
    }

    @Nullable
    OperationChain continuationWithCast(@NotNull TypeCast cast, @NotNull ChainCompletionContext context) {
        OperationChain head;
        if (cast == null) {
            OperationChain.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OperationChain.$$$reportNull$$$0(9);
        }
        if ((head = OperationChain.create(cast, 0, context)) == null) {
            return null;
        }
        ChainOperation[] newReverseOperations = new ChainOperation[this.length() + 1];
        System.arraycopy(this.myReverseOperations, 0, newReverseOperations, 0, this.myReverseOperations.length);
        newReverseOperations[this.length()] = head.getPath()[0];
        return new OperationChain(head.getQualifierClass(), newReverseOperations, head.getHead(), this.myHeadMethodCall, this.getChainWeight());
    }

    @NotNull
    OperationChain removeHeadCast(@NotNull ChainCompletionContext context) {
        if (context == null) {
            OperationChain.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(this.getHead() instanceof TypeCast);
        ChainOperation[] newReverseOperations = new ChainOperation[this.length() - 1];
        System.arraycopy(this.myReverseOperations, 0, newReverseOperations, 0, this.length() - 1);
        OperationChain operationChain = new OperationChain(Objects.requireNonNull(context.resolvePsiClass(this.myHeadMethodCall.getQualifierDef())), newReverseOperations, this.myHeadMethodCall, this.myHeadMethodCall, this.getChainWeight());
        if (operationChain == null) {
            OperationChain.$$$reportNull$$$0(11);
        }
        return operationChain;
    }

    public String toString() {
        Object[] path = this.getPath();
        return Arrays.toString(path) + " on " + this.myQualifierClass.getName();
    }

    public static CompareResult compare(@NotNull OperationChain left, @NotNull OperationChain right) {
        int rightCurrentIdx;
        if (left == null) {
            OperationChain.$$$reportNull$$$0(12);
        }
        if (right == null) {
            OperationChain.$$$reportNull$$$0(13);
        }
        if (left.length() == 0 || right.length() == 0) {
            throw new IllegalStateException("chains can't be empty");
        }
        int leftCurrentIdx = 0;
        for (rightCurrentIdx = 0; leftCurrentIdx < left.length() && rightCurrentIdx < right.length(); ++leftCurrentIdx, ++rightCurrentIdx) {
            ChainOperation thisNext = left.myReverseOperations[leftCurrentIdx];
            ChainOperation thatNext = right.myReverseOperations[leftCurrentIdx];
            if (OperationChain.lookSimilar(thisNext, thatNext)) continue;
            return CompareResult.NOT_EQUAL;
        }
        if (leftCurrentIdx < left.length() && rightCurrentIdx == right.length()) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        if (leftCurrentIdx == left.length() && rightCurrentIdx < right.length()) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        return CompareResult.EQUAL;
    }

    static boolean lookSimilar(ChainOperation op1, ChainOperation op2) {
        HashSet methodSet2;
        if (op1 instanceof ChainOperation.TypeCast || op2 instanceof ChainOperation.TypeCast) {
            return false;
        }
        Object[] methods1 = ((ChainOperation.MethodCall)op1).getCandidates();
        Object[] methods2 = ((ChainOperation.MethodCall)op2).getCandidates();
        PsiMethod repr1 = methods1[0];
        PsiMethod repr2 = methods2[0];
        if (repr1.hasModifierProperty("static") || repr2.hasModifierProperty("static")) {
            return false;
        }
        if (!repr1.getName().equals(repr2.getName()) || repr1.getParameterList().getParametersCount() != repr2.getParameterList().getParametersCount()) {
            return false;
        }
        HashSet methodSet1 = ContainerUtil.newHashSet((Object[])methods1);
        if (ContainerUtil.intersects((Collection)methodSet1, (Collection)(methodSet2 = ContainerUtil.newHashSet((Object[])methods2)))) {
            return true;
        }
        Set deepestSupers1 = methodSet1.stream().flatMap(m -> Arrays.stream(m.findDeepestSuperMethods())).collect(Collectors.toSet());
        return methodSet2.stream().flatMap(m -> Arrays.stream(m.findDeepestSuperMethods())).anyMatch(deepestSupers1::contains);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOperations";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHeadCast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeHeadCast";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CompareResult {
        LEFT_CONTAINS_RIGHT,
        RIGHT_CONTAINS_LEFT,
        EQUAL,
        NOT_EQUAL;

    }
}

