/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;

public class ChainCompletionContext {
    private static final String[] WIDELY_USED_CLASS_NAMES = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Class"};
    private static final Set<String> WIDELY_USED_SHORT_NAMES = ContainerUtil.set((Object[])new String[]{"String", "Object", "Class"});
    @NotNull
    private final ChainSearchTarget myTarget;
    @NotNull
    private final List<PsiNamedElement> myContextElements;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiResolveHelper myResolveHelper;
    @NotNull
    private final TIntObjectHashMap<PsiClass> myQualifierClassResolver;
    @NotNull
    private final Map<MethodCall, PsiMethod[]> myResolver;
    @NotNull
    private final CompilerReferenceServiceEx myRefServiceEx;
    private final NotNullLazyValue<Set<CompilerRef>> myContextClassReferences;

    public ChainCompletionContext(@NotNull ChainSearchTarget target, @NotNull List<PsiNamedElement> contextElements, @NotNull PsiElement context) {
        if (target == null) {
            ChainCompletionContext.$$$reportNull$$$0(0);
        }
        if (contextElements == null) {
            ChainCompletionContext.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ChainCompletionContext.$$$reportNull$$$0(2);
        }
        this.myContextClassReferences = new NotNullLazyValue<Set<CompilerRef>>(){

            @NotNull
            protected Set<CompilerRef> compute() {
                Set<CompilerRef> set = ChainCompletionContext.this.getContextTypes().stream().map(PsiUtil::resolveClassInType).filter(Objects::nonNull).map(c -> ClassUtil.getJVMClassName((PsiClass)c)).filter(Objects::nonNull).mapToInt(c -> ChainCompletionContext.this.myRefServiceEx.getNameId((String)c)).filter(n -> n != 0).mapToObj(n -> new CompilerRef.JavaCompilerClassRef(n)).collect(Collectors.toSet());
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$1", "compute"));
            }
        };
        this.myTarget = target;
        this.myContextElements = contextElements;
        this.myContext = context;
        this.myResolveScope = context.getResolveScope();
        this.myProject = context.getProject();
        this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
        this.myQualifierClassResolver = new TIntObjectHashMap();
        this.myResolver = FactoryMap.create(sign -> sign.resolve());
        this.myRefServiceEx = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance(this.myProject);
    }

    @NotNull
    public ChainSearchTarget getTarget() {
        ChainSearchTarget chainSearchTarget = this.myTarget;
        if (chainSearchTarget == null) {
            ChainCompletionContext.$$$reportNull$$$0(3);
        }
        return chainSearchTarget;
    }

    public boolean contains(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        Set<PsiType> types = this.getContextTypes();
        if (types.contains(type2)) {
            return true;
        }
        for (PsiType contextType : types) {
            if (!type2.isAssignableFrom(contextType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CompilerReferenceServiceEx getRefService() {
        CompilerReferenceServiceEx compilerReferenceServiceEx = this.myRefServiceEx;
        if (compilerReferenceServiceEx == null) {
            ChainCompletionContext.$$$reportNull$$$0(4);
        }
        return compilerReferenceServiceEx;
    }

    @NotNull
    public PsiElement getContextPsi() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            ChainCompletionContext.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public PsiFile getContextFile() {
        return this.myContext.getContainingFile();
    }

    @NotNull
    public Set<PsiType> getContextTypes() {
        Set<PsiType> set = this.myContextElements.stream().map(ChainCompletionContext::getType).collect(Collectors.toSet());
        if (set == null) {
            ChainCompletionContext.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<CompilerRef> getContextClassReferences() {
        Set set = (Set)this.myContextClassReferences.getValue();
        if (set == null) {
            ChainCompletionContext.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            ChainCompletionContext.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ChainCompletionContext.$$$reportNull$$$0(9);
        }
        return project;
    }

    public boolean hasQualifier(@Nullable PsiClass targetClass) {
        return this.getQualifiers(targetClass).findAny().isPresent();
    }

    public Stream<PsiNamedElement> getQualifiers(@Nullable PsiClass targetClass) {
        if (targetClass == null) {
            return Stream.empty();
        }
        return this.getQualifiers((PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createType(targetClass));
    }

    public Stream<PsiNamedElement> getQualifiers(@NotNull PsiType targetType) {
        if (targetType == null) {
            ChainCompletionContext.$$$reportNull$$$0(10);
        }
        return this.myContextElements.stream().filter(e -> {
            PsiType elementType;
            if (targetType == null) {
                ChainCompletionContext.$$$reportNull$$$0(15);
            }
            return (elementType = ChainCompletionContext.getType((PsiElement)e)) != null && targetType.isAssignableFrom(elementType);
        });
    }

    @Nullable
    public PsiClass resolvePsiClass(CompilerRef.CompilerClassHierarchyElementDef aClass) {
        int nameId = aClass.getName();
        if (this.myQualifierClassResolver.contains(nameId)) {
            return (PsiClass)this.myQualifierClassResolver.get(nameId);
        }
        PsiClass psiClass = null;
        String name2 = this.myRefServiceEx.getName(nameId);
        PsiClass resolvedClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(name2, this.myResolveScope);
        if (resolvedClass != null && this.accessValidator().test((PsiMember)resolvedClass)) {
            psiClass = resolvedClass;
        }
        this.myQualifierClassResolver.put(nameId, psiClass);
        return psiClass;
    }

    @NotNull
    public PsiMethod[] resolve(MethodCall sign) {
        PsiMethod[] psiMethodArray = this.myResolver.get(sign);
        if (psiMethodArray == null) {
            ChainCompletionContext.$$$reportNull$$$0(11);
        }
        return psiMethodArray;
    }

    public Predicate<PsiMember> accessValidator() {
        return m -> this.myResolveHelper.isAccessible(m, this.myContext, null);
    }

    @Nullable
    public static ChainCompletionContext createContext(@Nullable PsiType targetType, @Nullable PsiElement containingElement, boolean suggestIterators) {
        if (containingElement == null) {
            return null;
        }
        ChainSearchTarget target = ChainSearchTarget.create(targetType);
        if (target == null) {
            return null;
        }
        if (suggestIterators) {
            target = target.toIterators();
        }
        Set<? extends PsiVariable> excludedVariables = ChainCompletionContext.getEnclosingLocalVariables(containingElement);
        ContextProcessor processor = new ContextProcessor(null, containingElement.getProject(), containingElement, excludedVariables);
        PsiScopesUtil.treeWalkUp(processor, containingElement, (PsiElement)containingElement.getContainingFile());
        List<PsiNamedElement> contextElements = processor.getContextElements();
        return new ChainCompletionContext(target, contextElements, containingElement);
    }

    @NotNull
    private static Set<? extends PsiVariable> getEnclosingLocalVariables(@NotNull PsiElement place) {
        if (place == null) {
            ChainCompletionContext.$$$reportNull$$$0(12);
        }
        THashSet result = new THashSet();
        if (place instanceof PsiLocalVariable) {
            result.add((PsiLocalVariable)place);
        }
        for (PsiElement parent = place.getParent(); parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            if (!(parent instanceof PsiLocalVariable) || !PsiTreeUtil.isAncestor((PsiElement)((PsiLocalVariable)parent).getInitializer(), (PsiElement)place, (boolean)false)) continue;
            result.add((PsiLocalVariable)parent);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            ChainCompletionContext.$$$reportNull$$$0(13);
        }
        return tHashSet;
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static boolean isWidelyUsed(@NotNull PsiType type2) {
        if (type2 == null) {
            ChainCompletionContext.$$$reportNull$$$0(14);
        }
        if ((type2 = type2.getDeepComponentType()) instanceof PsiPrimitiveType) {
            return true;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        if (WIDELY_USED_SHORT_NAMES.contains(((PsiClassType)type2).getClassName())) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type2).resolve();
        if (resolvedClass == null) {
            return false;
        }
        String qName = resolvedClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        for (String name2 : WIDELY_USED_CLASS_NAMES) {
            if (!name2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextPsi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextClassReferences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingLocalVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingLocalVariables";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isWidelyUsed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifiers$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextProcessor
    implements PsiScopeProcessor,
    ElementClassHint {
        private final List<PsiNamedElement> myContextElements;
        private final PsiVariable myCompletionVariable;
        private final PsiResolveHelper myResolveHelper;
        private final PsiElement myPlace;
        private final Set<? extends PsiVariable> myExcludedVariables;

        private ContextProcessor(@Nullable PsiVariable variable, @NotNull Project project, @NotNull PsiElement place, @NotNull Set<? extends PsiVariable> excludedVariables) {
            if (project == null) {
                ContextProcessor.$$$reportNull$$$0(0);
            }
            if (place == null) {
                ContextProcessor.$$$reportNull$$$0(1);
            }
            if (excludedVariables == null) {
                ContextProcessor.$$$reportNull$$$0(2);
            }
            this.myContextElements = new SmartList();
            this.myCompletionVariable = variable;
            this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project);
            this.myPlace = place;
            this.myExcludedVariables = excludedVariables;
        }

        @Override
        public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
            return kind2 == ElementClassHint.DeclarationKind.ENUM_CONST || kind2 == ElementClassHint.DeclarationKind.FIELD || kind2 == ElementClassHint.DeclarationKind.METHOD || kind2 == ElementClassHint.DeclarationKind.VARIABLE;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                ContextProcessor.$$$reportNull$$$0(3);
            }
            if (state == null) {
                ContextProcessor.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiMethod && !PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)element)) || element instanceof PsiVariable && this.myExcludedVariables.contains(element) || element instanceof PsiMember && !this.myResolveHelper.isAccessible((PsiMember)element, this.myPlace, null))) {
                PsiType type2 = ChainCompletionContext.getType(element);
                if (type2 == null) {
                    return true;
                }
                if (ChainCompletionContext.isWidelyUsed(type2)) {
                    return true;
                }
                this.myContextElements.add((PsiNamedElement)element);
            }
            return true;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                ContextProcessor.$$$reportNull$$$0(5);
            }
            if (hintKey == ElementClassHint.KEY) {
                return (T)this;
            }
            return null;
        }

        @NotNull
        public List<PsiNamedElement> getContextElements() {
            this.myContextElements.remove(this.myCompletionVariable);
            List<PsiNamedElement> list = this.myContextElements;
            if (list == null) {
                ContextProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedVariables";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getHint";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

