/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.ProblemsViewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.ui.UIUtil;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsViewImpl
extends ProblemsView {
    private static final String PROBLEMS_TOOLWINDOW_ID = "Problems";
    private final ProblemsViewPanel myPanel;
    private final ExecutorService myViewUpdater = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"ProblemsView Pool");
    private final Icon myActiveIcon = AllIcons.Toolwindows.Problems;
    private final Icon myPassiveIcon = AllIcons.Toolwindows.ProblemsEmpty;

    public ProblemsViewImpl(Project project, ToolWindowManager wm) {
        super(project);
        this.myPanel = new ProblemsViewPanel(project);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                Disposer.dispose((Disposable)ProblemsViewImpl.this.myPanel);
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project.isDisposed()) {
                return;
            }
            final ToolWindow tw = wm.registerToolWindow(PROBLEMS_TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)this.myPanel), "", false);
            content.setHelpId("reference.problems.tool.window");
            tw.getContentManager().addContent(content);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    tw.getContentManager().removeAllContents(true);
                }
            });
            this.updateIcon();
        });
    }

    @Override
    public void clearOldMessages(@Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        if (currentSessionId == null) {
            ProblemsViewImpl.$$$reportNull$$$0(0);
        }
        this.myViewUpdater.execute(() -> {
            if (currentSessionId == null) {
                ProblemsViewImpl.$$$reportNull$$$0(5);
            }
            this.cleanupChildrenRecursively(this.myPanel.getErrorViewStructure().getRootElement(), scope, currentSessionId);
            this.updateIcon();
            this.myPanel.reload();
        });
    }

    private void cleanupChildrenRecursively(@NotNull Object fromElement, @Nullable CompileScope scope, @NotNull UUID currentSessionId) {
        if (fromElement == null) {
            ProblemsViewImpl.$$$reportNull$$$0(1);
        }
        if (currentSessionId == null) {
            ProblemsViewImpl.$$$reportNull$$$0(2);
        }
        ErrorViewStructure structure = this.myPanel.getErrorViewStructure();
        for (ErrorTreeElement element : structure.getChildElements(fromElement)) {
            if (element instanceof GroupingElement) {
                VirtualFile file;
                if (scope != null && (file = ((GroupingElement)element).getFile()) != null && !scope.belongs(file.getUrl())) continue;
                if (!currentSessionId.equals(element.getData())) {
                    structure.removeElement(element);
                    continue;
                }
                this.cleanupChildrenRecursively(element, scope, currentSessionId);
                continue;
            }
            if (currentSessionId.equals(element.getData())) continue;
            structure.removeElement(element);
        }
    }

    @Override
    public void addMessage(int type2, @NotNull String[] text2, @Nullable String groupName, @Nullable Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable UUID sessionId) {
        if (text2 == null) {
            ProblemsViewImpl.$$$reportNull$$$0(3);
        }
        this.myViewUpdater.execute(() -> {
            ErrorViewStructure structure;
            GroupingElement group;
            if (text2 == null) {
                ProblemsViewImpl.$$$reportNull$$$0(4);
            }
            if ((group = (structure = this.myPanel.getErrorViewStructure()).lookupGroupingElement(groupName)) != null && sessionId != null && !sessionId.equals(group.getData())) {
                structure.removeElement((ErrorTreeElement)group);
            }
            if (navigatable != null) {
                this.myPanel.addMessage(type2, text2, groupName, navigatable, exportTextPrefix, rendererTextPrefix, sessionId);
            } else {
                this.myPanel.addMessage(type2, text2, null, -1, -1, sessionId);
            }
            this.updateIcon();
        });
    }

    private void updateIcon() {
        UIUtil.invokeLaterIfNeeded(() -> {
            ToolWindow tw;
            if (!this.myProject.isDisposed() && (tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(PROBLEMS_TOOLWINDOW_ID)) != null) {
                boolean active = this.myPanel.getErrorViewStructure().hasMessages(EnumSet.of(ErrorTreeElementKind.ERROR, ErrorTreeElementKind.WARNING, ErrorTreeElementKind.NOTE));
                tw.setIcon(active ? this.myActiveIcon : this.myPassiveIcon);
            }
        });
    }

    @Override
    public void setProgress(String text2, float fraction) {
        this.myPanel.setProgress(text2, fraction);
    }

    @Override
    public void setProgress(String text2) {
        this.myPanel.setProgressText(text2);
    }

    @Override
    public void clearProgress() {
        this.myPanel.clearProgressData();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSessionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/ProblemsViewImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "clearOldMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanupChildrenRecursively";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addMessage$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$clearOldMessages$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

