/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ModuleOptionsTableModel;
import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class TargetOptionsComponent
extends JPanel {
    private static final String[] KNOWN_TARGETS;
    private static final String COMPILER_DEFAULT = "Same as language level";
    private final ComboBox<String> myCbProjectTargetLevel;
    private final JBTable myTable;
    private final Project myProject;

    public TargetOptionsComponent(@NotNull Project project) {
        if (project == null) {
            TargetOptionsComponent.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.myProject = project;
        this.myCbProjectTargetLevel = TargetOptionsComponent.createTargetOptionsCombo();
        this.myTable = new JBTable((TableModel)new ModuleOptionsTableModel());
        this.myTable.setRowHeight(JBUI.scale((int)22));
        this.myTable.getEmptyText().setText("All modules will be compiled with project bytecode version");
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue("Module");
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn targetLevelColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = "Target bytecode version";
        targetLevelColumn.setHeaderValue(columnTitle);
        targetLevelColumn.setCellEditor(new TargetLevelCellEditor());
        targetLevelColumn.setCellRenderer(new TargetLevelCellRenderer());
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(columnTitle) + 10;
        targetLevelColumn.setPreferredWidth(width);
        targetLevelColumn.setMinWidth(width);
        targetLevelColumn.setMaxWidth(width);
        new TableSpeedSearch((JTable)this.myTable);
        this.add((Component)new JLabel("Project bytecode version: "), TargetOptionsComponent.constraints(0, 0, 1, 1, 0.0, 0.0, 0));
        this.add((Component)this.myCbProjectTargetLevel, TargetOptionsComponent.constraints(1, 0, 1, 1, 1.0, 0.0, 0));
        this.add((Component)new JLabel("Per-module bytecode version:"), TargetOptionsComponent.constraints(0, 1, 2, 1, 1.0, 0.0, 0));
        JPanel tableComp = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(b -> this.addModules()).setRemoveAction(b -> this.removeSelectedModules()).createPanel();
        tableComp.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        this.add((Component)tableComp, TargetOptionsComponent.constraints(0, 2, 2, 1, 1.0, 1.0, 1));
    }

    private static ComboBox<String> createTargetOptionsCombo() {
        ComboBox combo = new ComboBox((Object[])KNOWN_TARGETS);
        combo.setEditable(true);
        combo.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                JBTextField editor = new JBTextField(TargetOptionsComponent.COMPILER_DEFAULT, 12);
                editor.getEmptyText().setText(TargetOptionsComponent.COMPILER_DEFAULT);
                editor.setBorder(null);
                return editor;
            }
        });
        return combo;
    }

    private static GridBagConstraints constraints(int gridX, int gridY, int gridWidth, int gridHeight, double weightX, double weightY, int fill) {
        return new GridBagConstraints(gridX, gridY, gridWidth, gridHeight, weightX, weightY, 17, fill, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
    }

    private void addModules() {
        int i = ((ModuleOptionsTableModel)this.myTable.getModel()).addModulesToModel(this.myProject, this);
        if (i != -1) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        }
    }

    private void removeSelectedModules() {
        if (this.myTable.getSelectedRows().length > 0) {
            TableUtil.removeSelectedItems((JTable)this.myTable);
        }
    }

    public void setProjectBytecodeTargetLevel(String level) {
        this.myCbProjectTargetLevel.setSelectedItem((Object)(level == null ? "" : level));
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        String item = ((String)ObjectUtils.notNull((Object)((String)this.myCbProjectTargetLevel.getSelectedItem()), (Object)"")).trim();
        return item.isEmpty() ? null : item;
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        return ((ModuleOptionsTableModel)this.myTable.getModel()).getModuleOptions();
    }

    public void setModuleTargetLevels(Map<String, String> moduleLevels) {
        ((ModuleOptionsTableModel)this.myTable.getModel()).setModuleOptions(this.myProject, moduleLevels);
    }

    static {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("1.1");
        targets.add("1.2");
        for (LanguageLevel level : LanguageLevel.values()) {
            if (level == LanguageLevel.JDK_X || level.isPreview()) continue;
            targets.add(JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion()));
        }
        Collections.reverse(targets);
        KNOWN_TARGETS = ArrayUtil.toStringArray(targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/options/TargetOptionsComponent", "<init>"));
    }

    private static class TargetLevelCellRenderer
    extends DefaultTableCellRenderer {
        private TargetLevelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                JLabel comp = (JLabel)component;
                comp.setHorizontalAlignment(0);
                if ("".equals(value2)) {
                    comp.setForeground((Color)JBColor.GRAY);
                    comp.setText(TargetOptionsComponent.COMPILER_DEFAULT);
                } else {
                    comp.setForeground(table.getForeground());
                }
            }
            return component;
        }
    }

    private static class TargetLevelCellEditor
    extends DefaultCellEditor {
        private TargetLevelCellEditor() {
            super((JComboBox<?>)TargetOptionsComponent.createTargetOptionsCombo());
            this.setClickCountToStart(0);
        }
    }
}

