/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cyclicDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.cyclicDependencies.CyclicDependenciesBuilder;
import com.intellij.cyclicDependencies.ui.CyclicDependenciesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class CyclicDependenciesHandler {
    private final Project myProject;
    private final AnalysisScope myScope;

    public CyclicDependenciesHandler(Project project, AnalysisScope scope) {
        this.myProject = project;
        this.myScope = scope;
    }

    public void analyze() {
        CyclicDependenciesBuilder builder = new CyclicDependenciesBuilder(this.myProject, this.myScope);
        Runnable process2 = () -> builder.analyze();
        Runnable successRunnable = () -> SwingUtilities.invokeLater(() -> {
            CyclicDependenciesPanel panel = new CyclicDependenciesPanel(this.myProject, builder);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, AnalysisScopeBundle.message((String)"action.analyzing.cyclic.dependencies.in.scope", (Object[])new Object[]{builder.getScope().getDisplayName()}), false);
            content.setDisposer((Disposable)panel);
            panel.setContent(content);
            DependenciesToolWindow.getInstance((Project)this.myProject).addContent(content);
        });
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.myProject, AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]), process2, successRunnable, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject));
    }
}

