/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.MethodListDlg;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.EditorTextField;
import com.intellij.util.TextFieldCompletionProvider;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class MethodBrowser
extends BrowseModuleValueActionListener {
    public MethodBrowser(Project project) {
        super(project);
    }

    protected abstract String getClassName();

    protected abstract ConfigurationModuleSelector getModuleSelector();

    protected abstract Condition<PsiMethod> getFilter(PsiClass var1);

    protected String showDialog() {
        PsiMethod method;
        String className = this.getClassName();
        if (className.trim().length() == 0) {
            Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        PsiClass testClass = this.getModuleSelector().findClass(className);
        if (testClass == null) {
            Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"class.does.not.exists.error.message", (Object[])new Object[]{className}), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            return null;
        }
        MethodListDlg dlg = new MethodListDlg(testClass, this.getFilter(testClass), this.getField());
        if (dlg.showAndGet() && (method = dlg.getSelected()) != null) {
            return method.getName();
        }
        return null;
    }

    public void installCompletion(EditorTextField field) {
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                String className;
                if (text2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((className = MethodBrowser.this.getClassName()).trim().length() == 0) {
                    return;
                }
                PsiClass testClass = MethodBrowser.this.getModuleSelector().findClass(className);
                if (testClass == null) {
                    return;
                }
                Condition<PsiMethod> filter = MethodBrowser.this.getFilter(testClass);
                for (PsiMethod psiMethod : testClass.getAllMethods()) {
                    if (!filter.value((Object)psiMethod)) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)psiMethod.getName()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/MethodBrowser$1";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(field);
    }
}

