/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.applet.AppletConfigurable;
import com.intellij.execution.applet.AppletConfigurationOptions;
import com.intellij.execution.applet.AppletParameter;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppletConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule, AppletConfigurationOptions>
implements SingleClassConfiguration,
RefactoringListenerProvider,
PersistentStateComponent<AppletConfigurationOptions> {
    public AppletConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            AppletConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            AppletConfiguration.$$$reportNull$$$0(1);
        }
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
    }

    @NotNull
    public AppletConfigurationOptions getOptions() {
        AppletConfigurationOptions appletConfigurationOptions = (AppletConfigurationOptions)super.getOptions();
        if (appletConfigurationOptions == null) {
            AppletConfiguration.$$$reportNull$$$0(2);
        }
        return appletConfigurationOptions;
    }

    @Override
    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            AppletConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            AppletConfiguration.$$$reportNull$$$0(4);
        }
        return new JavaCommandLineState(env){
            private AppletHtmlFile myHtmlURL;
            {
                this.myHtmlURL = null;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                JavaParameters params = new JavaParameters();
                this.myHtmlURL = AppletConfiguration.this.getHtmlURL();
                int classPathType = this.myHtmlURL.isHttp() ? 1 : 3;
                RunConfigurationModule runConfigurationModule = AppletConfiguration.this.getConfigurationModule();
                JavaParametersUtil.configureModule(runConfigurationModule, params, classPathType, AppletConfiguration.this.getOptions().isAlternativeJrePathEnabled() ? AppletConfiguration.this.getOptions().getAlternativeJrePath() : null);
                String policyFileParameter = AppletConfiguration.this.getPolicyFileParameter();
                if (policyFileParameter != null) {
                    params.getVMParametersList().add(policyFileParameter);
                }
                params.getVMParametersList().addParametersString(AppletConfiguration.this.getOptions().getVmParameters());
                params.setMainClass("sun.applet.AppletViewer");
                params.getProgramParametersList().add(this.myHtmlURL.getUrl());
                return params;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler = super.startProcess();
                final AppletHtmlFile htmlUrl = this.myHtmlURL;
                if (htmlUrl != null) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            htmlUrl.deleteFile();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/applet/AppletConfiguration$1$1", "processTerminated"));
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/applet/AppletConfiguration$1", "startProcess"));
            }
        };
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        AppletConfigurable appletConfigurable = new AppletConfigurable(this.getProject());
        if (appletConfigurable == null) {
            AppletConfiguration.$$$reportNull$$$0(5);
        }
        return appletConfigurable;
    }

    private String getPolicyFileParameter() {
        if (!StringUtil.isEmpty((String)this.getOptions().getPolicyFile())) {
            return "-Djava.security.policy=" + this.getPolicyFile();
        }
        return null;
    }

    @Transient
    public String getPolicyFile() {
        return ExternalizablePath.localPathValue((String)this.getOptions().getPolicyFile());
    }

    public void setPolicyFile(String localPath) {
        this.getOptions().setPolicyFile(ExternalizablePath.urlValue((String)localPath));
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.getOptions().getMainClassName());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.getOptions().getHtmlUsed()) {
            return null;
        }
        return RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
    }

    @Override
    @Transient
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.getOptions().getMainClassName());
    }

    public String suggestedName() {
        if (this.getOptions().getMainClassName() == null) {
            return null;
        }
        return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.getOptions().getMainClassName()), (int)0);
    }

    @Override
    public void setMainClassName(@Nullable String qualifiedName) {
        this.getOptions().setMainClassName(qualifiedName);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getOptions().isAlternativeJrePathEnabled() && (StringUtil.isEmptyOrSpaces((String)this.getOptions().getAlternativeJrePath()) || !JdkUtil.checkForJre((String)this.getOptions().getAlternativeJrePath()))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.not.valid.error.message", (Object[])new Object[]{this.getOptions().getAlternativeJrePath()}));
        }
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
        if (this.getOptions().getHtmlUsed()) {
            if (this.getOptions().getHtmlFileName() == null) {
                throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
            try {
                new URL(this.getHtmlURL().getUrl());
            }
            catch (CantRunException | MalformedURLException ex) {
                this.checkUrlIsValid((Exception)ex);
            }
        } else {
            ((JavaRunConfigurationModule)this.getConfigurationModule()).checkClassName(this.getOptions().getMainClassName(), ExecutionBundle.message((String)"no.applet.class.specified.error.message", (Object[])new Object[0]));
        }
    }

    private void checkUrlIsValid(Exception ex) throws RuntimeConfigurationWarning {
        throw new RuntimeConfigurationWarning("URL " + this.getOptions().getHtmlFileName() + " is not valid: " + ex.getLocalizedMessage());
    }

    private AppletHtmlFile getHtmlURL() throws CantRunException {
        if (this.getOptions().getHtmlUsed()) {
            if (this.getOptions().getHtmlFileName() == null) {
                throw new CantRunException(ExecutionBundle.message((String)"html.file.not.specified.error.message", (Object[])new Object[0]));
            }
            return new AppletHtmlFile(this.getOptions().getHtmlFileName(), null);
        }
        if (this.getOptions().getMainClassName() == null) {
            throw new CantRunException(ExecutionBundle.message((String)"class.not.specified.error.message", (Object[])new Object[0]));
        }
        try {
            return this.generateAppletTempPage();
        }
        catch (IOException ignored) {
            throw new CantRunException(ExecutionBundle.message((String)"failed.to.generate.wrapper.error.message", (Object[])new Object[0]));
        }
    }

    @NotNull
    private AppletHtmlFile generateAppletTempPage() throws IOException {
        File tempFile = FileUtil.createTempFile((String)"AppletPage", (String)".html");
        try (FileWriter writer = new FileWriter(tempFile);){
            writer.write("<html>\n<head>\n<title>" + this.getOptions().getMainClassName() + "</title>\n</head>\n<applet codebase=\".\"\ncode=\"" + this.getOptions().getMainClassName() + "\"\nname=\"" + this.getOptions().getMainClassName() + "\"\nwidth=" + this.getOptions().getWidth() + "\nheight=" + this.getOptions().getHeight() + "\nalign=top>\n");
            for (AppletParameter parameter2 : this.getOptions().getAppletParameters()) {
                writer.write("<param name=\"" + parameter2.getName() + "\" value=\"" + parameter2.getValue() + "\">\n");
            }
            writer.write("</applet>\n</body>\n</html>\n");
        }
        AppletHtmlFile appletHtmlFile = new AppletHtmlFile(tempFile.getAbsolutePath(), tempFile);
        if (appletHtmlFile == null) {
            AppletConfiguration.$$$reportNull$$$0(6);
        }
        return appletHtmlFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/applet/AppletConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/applet/AppletConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAppletTempPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AppletHtmlFile {
        private final String myHtmlFile;
        private final File myFileToDelete;
        @NonNls
        protected static final String FILE_PREFIX = "file:/";
        @NonNls
        protected static final String HTTP_PREFIX = "http:/";
        @NonNls
        protected static final String HTTPS_PREFIX = "https:/";

        protected AppletHtmlFile(String htmlFile, File fileToDelete) {
            this.myHtmlFile = htmlFile;
            this.myFileToDelete = fileToDelete;
        }

        public String getUrl() {
            if (!StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)FILE_PREFIX) && !this.isHttp()) {
                try {
                    return new File(this.myHtmlFile).toURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return this.myHtmlFile;
        }

        public boolean isHttp() {
            return StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTP_PREFIX) || StringUtil.startsWithIgnoreCase((String)this.myHtmlFile, (String)HTTPS_PREFIX);
        }

        public void deleteFile() {
            if (this.myFileToDelete != null) {
                this.myFileToDelete.delete();
            }
        }
    }
}

