/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.applet.AppletConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppletConfigurationProducer
extends JavaRuntimeConfigurationProducerBase {
    protected AppletConfigurationProducer() {
        super(ConfigurationTypeUtil.findConfigurationType(AppletConfigurationType.class));
    }

    public PsiElement getSourceElement() {
        return this.restoreSourceElement();
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return null;
        }
        Project project = location.getProject();
        PsiElement element = location.getPsiElement();
        PsiClass psiClass = AppletConfigurationProducer.getAppletClass(element, PsiManager.getInstance((Project)project));
        if (psiClass == null) {
            return null;
        }
        this.storeSourceElement((PsiElement)psiClass);
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(project, context);
        AppletConfiguration configuration = (AppletConfiguration)settings.getConfiguration();
        configuration.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        configuration.setModule(psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null);
        configuration.setGeneratedName();
        return settings;
    }

    public int compareTo(Object o) {
        return -1;
    }

    @Nullable
    private static PsiClass getAppletClass(PsiElement element, PsiManager manager) {
        while (element != null) {
            PsiClass aClass;
            if (element instanceof PsiClass && AppletConfigurationProducer.isAppletClass(aClass = (PsiClass)element, manager)) {
                return aClass;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean isAppletClass(PsiClass aClass, PsiManager manager) {
        if (DumbService.isDumb((Project)manager.getProject())) {
            return false;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            return false;
        }
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithLibrariesScope((Module)module) : GlobalSearchScope.projectScope((Project)manager.getProject());
        PsiClass appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.applet.Applet", scope);
        if (appletClass != null && aClass.isInheritor(appletClass, true)) {
            return true;
        }
        appletClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("javax.swing.JApplet", scope);
        return appletClass != null && aClass.isInheritor(appletClass, true);
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        PsiClass aClass;
        if (existingConfigurations == null) {
            AppletConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((aClass = AppletConfigurationProducer.getAppletClass(location.getPsiElement(), PsiManager.getInstance((Project)location.getProject()))) != null) {
            for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
                if (!Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((AppletConfiguration)existingConfiguration.getConfiguration()).getOptions().getMainClassName())) continue;
                return existingConfiguration;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "com/intellij/execution/applet/AppletConfigurationProducer", "findExistingByElement"));
    }
}

