/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractApplicationConfigurationProducer<T extends ApplicationConfiguration>
extends JavaRunConfigurationProducerBase<T> {
    public AbstractApplicationConfigurationProducer(@NotNull ConfigurationType configurationType) {
        if (configurationType == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(0);
        }
        super(configurationType);
    }

    public AbstractApplicationConfigurationProducer(@NotNull ApplicationConfigurationType configurationType) {
        if (configurationType == null) {
            AbstractApplicationConfigurationProducer.$$$reportNull$$$0(1);
        }
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(T configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiClass aClass;
        PsiMethod method;
        Location contextLocation = context.getLocation();
        if (contextLocation == null) {
            return false;
        }
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (!element.isPhysical()) {
            return false;
        }
        PsiElement currentElement = element;
        while ((method = AbstractApplicationConfigurationProducer.findMain(currentElement)) != null) {
            aClass = method.getContainingClass();
            if (ConfigurationUtil.MAIN_CLASS.value((Object)aClass)) {
                sourceElement.set((Object)method);
                this.setupConfiguration(configuration, aClass, context);
                return true;
            }
            currentElement = method.getParent();
        }
        aClass = ApplicationConfigurationType.getMainClass(element);
        if (aClass == null) {
            return false;
        }
        sourceElement.set((Object)aClass);
        this.setupConfiguration(configuration, aClass, context);
        return true;
    }

    private void setupConfiguration(T configuration, PsiClass aClass, ConfigurationContext context) {
        ((ApplicationConfiguration)configuration).setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
    }

    @Nullable
    private static PsiMethod findMain(PsiElement element) {
        PsiMethod method;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
            if (PsiMethodUtil.isMainMethod((PsiMethod)method)) {
                return method;
            }
            element = method.getParent();
        }
        return null;
    }

    public boolean isConfigurationFromContext(T appConfiguration, ConfigurationContext context) {
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location);
        if (aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)((ApplicationConfiguration)appConfiguration).getMainClassName())) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location, PsiMethod.class, (boolean)false);
            if (method != null && TestFrameworks.getInstance().isTestMethod(method)) {
                return false;
            }
            Module configurationModule = ((JavaRunConfigurationModule)appConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)context.getModule(), (Object)configurationModule)) {
                return true;
            }
            ApplicationConfiguration template = (ApplicationConfiguration)context.getRunManager().getConfigurationTemplate(this.getConfigurationFactory()).getConfiguration();
            Module predefinedModule = ((JavaRunConfigurationModule)template.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationType", "com/intellij/execution/application/AbstractApplicationConfigurationProducer", "<init>"));
    }
}

