/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchPositionManager
extends PositionManagerImpl {
    private final VirtualFile myScratchFile;

    public JavaScratchPositionManager(DebugProcessImpl debugProcess, VirtualFile scratchFile) {
        super(debugProcess);
        this.myScratchFile = scratchFile;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) throws NoDataException {
        if (type2 == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(0);
        }
        if (position == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(1);
        }
        this.checkPosition(position);
        List list = super.locationsOfLine(type2, position);
        if (list == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(3);
        }
        if (position == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(4);
        }
        this.checkPosition(position);
        List list = super.createPrepareRequests(requestor, position);
        if (list == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(6);
        }
        this.checkPosition(position);
        List list = super.getAllClasses(position);
        if (list == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void checkPosition(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            JavaScratchPositionManager.$$$reportNull$$$0(8);
        }
        if (!this.myScratchFile.equals(position.getFile().getVirtualFile())) {
            throw NoDataException.INSTANCE;
        }
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        SourcePosition position = super.getSourcePosition(location);
        if (position == null) {
            throw NoDataException.INSTANCE;
        }
        return position;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        String alternativeQName;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(this.myScratchFile);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes2 = ((PsiJavaFile)psiFile).getClasses();
        if (classes2.length == 0) {
            return null;
        }
        String originalQName = refType.name();
        for (PsiClass aClass : classes2) {
            if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)aClass.getQualifiedName())) continue;
            return psiFile;
        }
        int dollar = originalQName.indexOf(36);
        String string = alternativeQName = dollar > 0 ? originalQName.substring(0, dollar) : null;
        if (!StringUtil.isEmpty((String)alternativeQName)) {
            for (PsiClass aClass : classes2) {
                if (!StringUtil.equals((CharSequence)alternativeQName, (CharSequence)aClass.getQualifiedName())) continue;
                return psiFile;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchPositionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchPositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

