/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.indices.DiscoveredTestDataHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryIndex
implements Disposable {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private volatile DiscoveredTestDataHolder myHolder;
    private final Object myLock;
    private final Path myBasePath;

    public static TestDiscoveryIndex getInstance(Project project) {
        return (TestDiscoveryIndex)project.getComponent(TestDiscoveryIndex.class);
    }

    public TestDiscoveryIndex(Project project) {
        this(project, TestDiscoveryExtension.baseTestDiscoveryPathForProject(project));
    }

    public TestDiscoveryIndex(Project project, @NotNull Path basePath) {
        if (basePath == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myBasePath = basePath;
        if (Files.exists(basePath, new LinkOption[0])) {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.getHolder()));
        }
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        Boolean result;
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(1);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(2);
        }
        return (result = (Boolean)this.executeUnderLock(holder -> {
            if (testClassName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(29);
            }
            if (testMethodName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(30);
            }
            return holder.hasTestTrace(testClassName, testMethodName, frameworkId);
        })) == Boolean.TRUE;
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) {
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(3);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(4);
        }
        this.executeUnderLock(holder -> {
            if (testClassName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(27);
            }
            if (testMethodName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(28);
            }
            holder.removeTestTrace(testClassName, testMethodName, frameworkId);
            return null;
        });
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(String relativePath, byte frameworkId) {
        MultiMap map = (MultiMap)this.executeUnderLock(holder -> holder.getTestsByFile(relativePath, frameworkId));
        MultiMap multiMap = map == null ? MultiMap.empty() : map;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) {
        MultiMap map;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(6);
        }
        MultiMap multiMap = (map = (MultiMap)this.executeUnderLock(holder -> {
            if (classFQName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(26);
            }
            return holder.getTestsByClassName(classFQName, frameworkId);
        })) == null ? MultiMap.empty() : map;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        MultiMap map;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(8);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(9);
        }
        MultiMap multiMap = (map = (MultiMap)this.executeUnderLock(holder -> {
            if (classFQName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(24);
            }
            if (methodName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(25);
            }
            return holder.getTestsByMethodName(classFQName, methodName, frameworkId);
        })) == null ? MultiMap.empty() : map;
        if (multiMap == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(10);
        }
        return multiMap;
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) {
        Collection modules;
        if (classFQName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(11);
        }
        if (methodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(12);
        }
        Collection<Object> collection = (modules = (Collection)this.executeUnderLock(holder -> {
            if (classFQName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(22);
            }
            if (methodName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(23);
            }
            return holder.getTestModulesByMethodName(classFQName, methodName, frameworkId);
        })) == null ? Collections.emptySet() : modules;
        if (collection == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(13);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.myHolder;
            if (holder != null) {
                holder.dispose();
                this.myHolder = null;
            }
        }
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull String[] usedFiles, @Nullable String moduleName, byte frameworkId) {
        if (testClassName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(14);
        }
        if (testMethodName == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(15);
        }
        if (usedMethods == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(16);
        }
        if (usedFiles == null) {
            TestDiscoveryIndex.$$$reportNull$$$0(17);
        }
        this.executeUnderLock(holder -> {
            if (testClassName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(18);
            }
            if (testMethodName == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(19);
            }
            if (usedMethods == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(20);
            }
            if (usedFiles == null) {
                TestDiscoveryIndex.$$$reportNull$$$0(21);
            }
            holder.updateTestData(testClassName, testMethodName, usedMethods, usedFiles, moduleName, frameworkId);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredTestDataHolder getHolder() {
        DiscoveredTestDataHolder holder = this.myHolder;
        if (holder == null) {
            Object object = this.myLock;
            synchronized (object) {
                holder = this.myHolder;
                if (holder == null && this.myBasePath != null) {
                    this.myHolder = holder = new DiscoveredTestDataHolder(this.myBasePath);
                }
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeUnderLock(ThrowableConvertor<DiscoveredTestDataHolder, R, IOException> action) {
        Object object = this.myLock;
        synchronized (object) {
            DiscoveredTestDataHolder holder = this.getHolder();
            if (holder == null || holder.isDisposed()) {
                return null;
            }
            try {
                return (R)action.convert((Object)holder);
            }
            catch (Throwable throwable) {
                LOG.error("Unexpected problem", throwable);
                holder.dispose();
                PathKt.delete((Path)this.myBasePath);
                this.myHolder = null;
                return null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 18: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 2: 
            case 4: 
            case 15: 
            case 19: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodName";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 9: 
            case 12: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMethods";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByClassName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByMethodName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestModulesByMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTrace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeTestTrace";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByClassName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByMethodName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTestModulesByMethodName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateTestData";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateTestData$8";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestModulesByMethodName$7";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestsByMethodName$6";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestsByClassName$5";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeTestTrace$3";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasTestTrace$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

