/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties<T extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>>
extends SMTRunnerConsoleProperties {
    public JavaAwareTestConsoleProperties(String testFrameworkName, RunConfiguration configuration, Executor executor) {
        super(configuration, testFrameworkName, executor);
        this.setPrintTestingStartedTime(false);
    }

    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    public T getConfiguration() {
        return (T)((ModuleBasedConfiguration)super.getConfiguration());
    }

    public int getSelectionMode() {
        return 4;
    }

    public boolean fixEmptySuite() {
        return ResetConfigurationModuleAdapter.tryWithAnotherModule(this.getConfiguration(), this.isDebug());
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(0);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(1);
        }
        return JavaAwareTestConsoleProperties.getStackTraceErrorNavigatable(location, stacktrace);
    }

    @Nullable
    public static Navigatable getStackTraceErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        String[] stackTrace;
        PsiLocation psiLocation;
        PsiClass containingClass;
        if (location == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(2);
        }
        if (stacktrace == null) {
            JavaAwareTestConsoleProperties.$$$reportNull$$$0(3);
        }
        if ((containingClass = (PsiClass)(psiLocation = location.toPsiLocation()).getParentElement(PsiClass.class)) == null) {
            return null;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        PsiMethod containingMethod = null;
        Iterator iterator = psiLocation.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            PsiMethod psiMethod = (PsiMethod)((Location)iterator.next()).getPsiElement();
            if (!containingClass.equals(psiMethod.getContainingClass())) continue;
            containingMethod = psiMethod;
        }
        if (containingMethod == null) {
            return null;
        }
        String methodName = containingMethod.getName();
        StackTraceLine lastLine = null;
        for (String aStackTrace : stackTrace = new LineTokenizer(stacktrace).execute()) {
            StackTraceLine line = new StackTraceLine(containingClass.getProject(), aStackTrace);
            if (!methodName.equals(line.getMethodName()) || !qualifiedName.equals(line.getClassName())) continue;
            lastLine = line;
            break;
        }
        if (lastLine != null) {
            try {
                int lineNumber = lastLine.getLineNumber();
                PsiFile psiFile = containingClass.getContainingFile();
                Document document = PsiDocumentManager.getInstance((Project)containingClass.getProject()).getDocument(psiFile);
                TextRange textRange = containingMethod.getTextRange();
                if (textRange == null || document == null || lineNumber < 0 || lineNumber >= document.getLineCount() || textRange.contains(document.getLineStartOffset(lineNumber))) {
                    return new OpenFileDescriptor(containingClass.getProject(), psiFile.getVirtualFile(), lineNumber, 0);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)this.getProject());
        if (debuggerManager == null) {
            return null;
        }
        Collection sessions = debuggerManager.getSessions();
        for (DebuggerSession debuggerSession : sessions) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    public boolean isEditable() {
        return Registry.is((String)"editable.java.test.console");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/JavaAwareTestConsoleProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorNavigatable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStackTraceErrorNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

