/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.pom.java.LanguageLevel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectData
extends AbstractExternalEntityData {
    public static final Key<JavaProjectData> KEY = Key.create(JavaProjectData.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 1));
    private static final Logger LOG = Logger.getInstance(JavaProjectData.class);
    private static final long serialVersionUID = 1L;
    private static final LanguageLevel DEFAULT_LANGUAGE_LEVEL = LanguageLevel.JDK_1_6;
    private static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_1_6;
    private static final Pattern JDK_VERSION_PATTERN = Pattern.compile(".*1.(\\d+).*");
    @NotNull
    private JavaSdkVersion myJdkVersion;
    @NotNull
    private LanguageLevel myLanguageLevel;
    @NotNull
    private String myCompileOutputPath;

    public JavaProjectData(@NotNull ProjectSystemId owner2, @NotNull String compileOutputPath) {
        if (owner2 == null) {
            JavaProjectData.$$$reportNull$$$0(0);
        }
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(1);
        }
        super(owner2);
        this.myJdkVersion = DEFAULT_JDK_VERSION;
        this.myLanguageLevel = DEFAULT_LANGUAGE_LEVEL;
        this.myCompileOutputPath = compileOutputPath;
    }

    @NotNull
    public String getCompileOutputPath() {
        String string = this.myCompileOutputPath;
        if (string == null) {
            JavaProjectData.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setCompileOutputPath(@NotNull String compileOutputPath) {
        if (compileOutputPath == null) {
            JavaProjectData.$$$reportNull$$$0(3);
        }
        this.myCompileOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)compileOutputPath);
    }

    @NotNull
    public JavaSdkVersion getJdkVersion() {
        JavaSdkVersion javaSdkVersion = this.myJdkVersion;
        if (javaSdkVersion == null) {
            JavaProjectData.$$$reportNull$$$0(4);
        }
        return javaSdkVersion;
    }

    public void setJdkVersion(@NotNull JavaSdkVersion jdkVersion) {
        if (jdkVersion == null) {
            JavaProjectData.$$$reportNull$$$0(5);
        }
        this.myJdkVersion = jdkVersion;
    }

    public void setJdkVersion(@Nullable String jdk) {
        if (jdk == null) {
            return;
        }
        try {
            int version = Integer.parseInt(jdk.trim());
            if (this.applyJdkVersion(version)) {
                return;
            }
        }
        catch (NumberFormatException version) {
            // empty catch block
        }
        Matcher matcher = JDK_VERSION_PATTERN.matcher(jdk);
        if (!matcher.matches()) {
            return;
        }
        String versionAsString = matcher.group(1);
        try {
            this.applyJdkVersion(Integer.parseInt(versionAsString));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean applyJdkVersion(int version) {
        if (version < 0 || version >= JavaSdkVersion.values().length) {
            LOG.warn(String.format("Unsupported jdk version detected (%d). Expected to get number from range [0; %d]", version, JavaSdkVersion.values().length));
            return false;
        }
        for (JavaSdkVersion sdkVersion : JavaSdkVersion.values()) {
            if (sdkVersion.ordinal() != version) continue;
            this.myJdkVersion = sdkVersion;
            return true;
        }
        assert (false) : version + ", max value: " + JavaSdkVersion.values().length;
        return false;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            JavaProjectData.$$$reportNull$$$0(6);
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaProjectData.$$$reportNull$$$0(7);
        }
        this.myLanguageLevel = level;
    }

    public void setLanguageLevel(@Nullable String languageLevel) {
        LanguageLevel level = LanguageLevel.parse((String)languageLevel);
        if (level != null) {
            this.myLanguageLevel = level;
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myJdkVersion.hashCode();
        result = 31 * result + this.myLanguageLevel.hashCode();
        result = 31 * result + this.myCompileOutputPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaProjectData project = (JavaProjectData)((Object)o);
        if (!this.myCompileOutputPath.equals(project.myCompileOutputPath)) {
            return false;
        }
        if (this.myJdkVersion != project.myJdkVersion) {
            return false;
        }
        return this.myLanguageLevel == project.myLanguageLevel;
    }

    public String toString() {
        return "java project";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileOutputPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalSystem/JavaProjectData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalSystem/JavaProjectData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileOutputPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCompileOutputPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setJdkVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

