/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaCallReferenceProcessor
implements CallReferenceProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull PsiReference reference, @NotNull JavaCallHierarchyData data) {
        if (reference == null) {
            JavaCallReferenceProcessor.$$$reportNull$$$0(0);
        }
        if (data == null) {
            JavaCallReferenceProcessor.$$$reportNull$$$0(1);
        }
        PsiClass originalClass = data.getOriginalClass();
        PsiMethod method = data.getMethod();
        Set methodsToFind = data.getMethodsToFind();
        PsiMethod methodToFind = data.getMethodToFind();
        PsiClassType originalType = data.getOriginalType();
        Map methodToDescriptorMap = data.getResultMap();
        Project myProject = data.getProject();
        if (reference instanceof PsiReferenceExpression) {
            PsiMethod callee;
            PsiClass psiClass;
            PsiType qualifierType;
            PsiClass superClass;
            PsiExpression qualifier = ((PsiReferenceExpression)reference).getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression && ((superClass = PsiUtil.resolveClassInType((PsiType)qualifier.getType())) == null || originalClass.isInheritor(superClass, true))) {
                return false;
            }
            if (qualifier != null && !methodToFind.hasModifierProperty("static") && (qualifierType = qualifier.getType()) instanceof PsiClassType && !TypeConversionUtil.isAssignable((PsiType)qualifierType, (PsiType)originalType) && methodToFind != method && (psiClass = ((PsiClassType)qualifierType).resolve()) != null && (callee = psiClass.findMethodBySignature(methodToFind, true)) != null && !methodsToFind.contains(callee)) {
                return false;
            }
        } else {
            if (!(reference instanceof PsiElement)) {
                return true;
            }
            PsiElement parent = ((PsiElement)reference).getParent();
            if (parent instanceof PsiNewExpression) {
                if (((PsiNewExpression)parent).getClassReference() != reference) {
                    return false;
                }
            } else if (parent instanceof PsiAnonymousClass) {
                if (((PsiAnonymousClass)parent).getBaseClassReference() != reference) {
                    return false;
                }
            } else if (!(reference instanceof LightMemberReference)) {
                return true;
            }
        }
        PsiElement element = reference.getElement();
        PsiMember key2 = CallHierarchyNodeDescriptor.getEnclosingElement(element);
        Map map = methodToDescriptorMap;
        synchronized (map) {
            CallHierarchyNodeDescriptor d = (CallHierarchyNodeDescriptor)((Object)methodToDescriptorMap.get(key2));
            if (d == null) {
                d = new CallHierarchyNodeDescriptor(myProject, (CallHierarchyNodeDescriptor)data.getNodeDescriptor(), element, false, true);
                methodToDescriptorMap.put(key2, d);
            } else if (!d.hasReference(reference)) {
                d.incrementUsageCount();
            }
            d.addReference(reference);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/hierarchy/call/JavaCallReferenceProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

