/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotationTargetsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UsedIconsListingAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            UsedIconsListingAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)LangDataKeys.PROJECT.getData(e.getDataContext());
        final MultiMap calls = new MultiMap();
        final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        Processor<PsiReference> consumer = new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiCallExpression.class, (boolean)false);
                if (call == null) {
                    return true;
                }
                if (call.getArgumentList() == null) {
                    return true;
                }
                if (call.getArgumentList().getExpressions() == null) {
                    return true;
                }
                PsiFile file = reference.getElement().getContainingFile();
                if ("AllIcons.java".equals(file.getName())) {
                    return true;
                }
                PsiClass container = PsiUtil.getTopLevelClass((PsiElement)reference.getElement());
                if (container != null && container.getQualifiedName().startsWith("icons.")) {
                    return true;
                }
                for (PsiExpression arg : call.getArgumentList().getExpressions()) {
                    Object value2;
                    if (arg instanceof PsiLiteralExpression) {
                        value2 = ((PsiLiteralExpression)arg).getValue();
                        this.processValue(value2, call, file);
                        continue;
                    }
                    value2 = psiFacade.getConstantEvaluationHelper().computeConstantExpression((PsiElement)arg, false);
                    this.processValue(value2, call, file);
                }
                return true;
            }

            private void processValue(Object value2, PsiCallExpression call, PsiFile file) {
                if (value2 instanceof String) {
                    String str = StringUtil.unquoteString((String)((String)value2), (char)'\"');
                    if (!str.startsWith("/") && file instanceof PsiClassOwner) {
                        str = "/" + ((PsiClassOwner)file).getPackageName().replace('.', '/') + "/" + str;
                    }
                    calls.putValue((Object)str, (Object)call);
                }
            }
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        PsiClass iconLoader = psiFacade.findClass("com.intellij.openapi.util.IconLoader", allScope);
        PsiMethod getIconMethod = iconLoader.findMethodsByName("getIcon", false)[0];
        PsiMethod findIconMethod = iconLoader.findMethodsByName("findIcon", false)[0];
        MethodReferencesSearch.search((PsiMethod)getIconMethod, (boolean)false).forEach((Processor)consumer);
        MethodReferencesSearch.search((PsiMethod)findIconMethod, (boolean)false).forEach((Processor)consumer);
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiClass javaeeIcons = psiFacade.findClass("com.intellij.javaee.oss.JavaeeIcons", allScope);
        MethodReferencesSearch.search((PsiMethod)javaeeIcons.findMethodsByName("getIcon", false)[0], (boolean)false).forEach((Processor)consumer);
        MethodReferencesSearch.search((PsiMethod)findIconMethod, (boolean)false).forEach((Processor)consumer);
        final ArrayList<XmlAttribute> xmlAttributes = new ArrayList<XmlAttribute>();
        PsiSearchHelper.getInstance((Project)project).processAllFilesWithWordInText("icon", (GlobalSearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.projectScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.contains(file) && file.getFileType() == XmlFileType.INSTANCE && index.isInSource(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/internal/UsedIconsListingAction$2", "contains"));
            }
        }, (Processor)new Processor<PsiFile>(){

            public boolean process(PsiFile file) {
                file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        String icon = tag.getAttributeValue("icon");
                        if (icon != null) {
                            xmlAttributes.add(tag.getAttribute("icon"));
                        }
                    }
                });
                return true;
            }
        }, true);
        PsiClass presentation = psiFacade.findClass("com.intellij.ide.presentation.Presentation", allScope);
        MultiMap annotations2 = new MultiMap();
        AnnotationTargetsSearch.search((PsiClass)presentation).forEach(owner2 -> {
            Object value2;
            PsiAnnotation annotation = owner2.getModifierList().findAnnotation("com.intellij.ide.presentation.Presentation");
            PsiAnnotationMemberValue icon = annotation.findAttributeValue("icon");
            if (icon instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)icon).getValue()) instanceof String) {
                annotations2.putValue((Object)((String)value2), (Object)annotation);
            }
            return true;
        });
        UsedIconsListingAction.doReplacements(project, (MultiMap<String, PsiExpression>)calls, xmlAttributes, (MultiMap<String, PsiAnnotation>)annotations2, psiFacade.findClass("com.intellij.icons.AllIcons", allScope));
        for (PsiClass iconClass : psiFacade.findPackage("icons").getClasses(allScope)) {
            if (!iconClass.getName().endsWith("Icons")) continue;
            UsedIconsListingAction.doReplacements(project, (MultiMap<String, PsiExpression>)calls, xmlAttributes, (MultiMap<String, PsiAnnotation>)annotations2, iconClass);
        }
    }

    private static void doReplacements(Project project, MultiMap<String, PsiExpression> calls, List<XmlAttribute> xmlAttributes, MultiMap<String, PsiAnnotation> annotations2, PsiClass iconClass) {
        PsiFile file;
        String replacement;
        String path;
        HashMap<String, String> mappings = new HashMap<String, String>();
        int size = mappings.size();
        UsedIconsListingAction.collectFields(iconClass, "", mappings);
        System.out.println("Found " + (mappings.size() - size) + " icons in " + iconClass.getQualifiedName());
        GlobalSearchScope useScope = (GlobalSearchScope)iconClass.getUseScope();
        for (XmlAttribute att : xmlAttributes) {
            PsiFile file2;
            String value2;
            String replacement2;
            if (!att.isValid() || (replacement2 = mappings.get(value2 = att.getValue())) == null || !useScope.contains((file2 = att.getContainingFile()).getVirtualFile())) continue;
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).run(() -> att.setValue(replacement2));
        }
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        for (Map.Entry entry : calls.entrySet()) {
            path = (String)entry.getKey();
            replacement = mappings.get(path);
            if (replacement == null) continue;
            for (PsiExpression call : (Collection)entry.getValue()) {
                if (!call.isValid() || !useScope.contains((file = call.getContainingFile()).getVirtualFile())) continue;
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
                    if (call instanceof PsiLiteralExpression) {
                        call.replace(factory.createExpressionFromText("\"" + replacement + "\"", (PsiElement)call));
                    } else {
                        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                        String packageName = replacement.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
                        PsiElement expr = factory.createExpressionFromText(packageName + replacement, (PsiElement)call);
                        styleManager.shortenClassReferences(call.replace(expr));
                    }
                });
            }
        }
        for (Map.Entry entry : annotations2.entrySet()) {
            path = (String)entry.getKey();
            replacement = mappings.get(path);
            if (replacement == null) continue;
            for (PsiAnnotation annotation : (Collection)entry.getValue()) {
                if (annotation instanceof PsiCompiledElement || !annotation.isValid() || !useScope.contains((file = annotation.getContainingFile()).getVirtualFile())) continue;
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
                    annotation.getNode();
                    annotation.setDeclaredAttributeValue("icon", JavaPsiFacade.getElementFactory((Project)annotation.getProject()).createAnnotationFromText("@A(\"" + replacement + "\")", null).findDeclaredAttributeValue(null));
                });
            }
        }
    }

    private static void collectFields(PsiClass klass, String prefix, Map<String, String> mapping) {
        String thePrefix = prefix + klass.getName() + ".";
        for (PsiClass psiClass : klass.getInnerClasses()) {
            UsedIconsListingAction.collectFields(psiClass, thePrefix, mapping);
        }
        for (PsiClass psiClass : klass.getFields()) {
            PsiCallExpression initializer = (PsiCallExpression)psiClass.getInitializer();
            PsiLiteralExpression arg = (PsiLiteralExpression)initializer.getArgumentList().getExpressions()[0];
            mapping.put((String)arg.getValue(), thePrefix + psiClass.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/UsedIconsListingAction", "actionPerformed"));
    }
}

