/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.services.artifactory;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.services.MavenRepositoryService;
import com.intellij.jarRepository.services.artifactory.ArtifactoryModel;
import com.intellij.jarRepository.services.artifactory.Endpoint;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactoryRepositoryService
extends MavenRepositoryService {
    @Override
    @NotNull
    public String getDisplayName() {
        if ("Artifactory" == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(0);
        }
        return "Artifactory";
    }

    @Override
    @NotNull
    public List<RemoteRepositoryDescription> getRepositories(@NotNull String url) throws IOException {
        ArrayList<RemoteRepositoryDescription> arrayList;
        if (url == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(1);
        }
        try {
            Gson gson = new Gson();
            InputStreamReader stream = new InputStreamReader(new Endpoint.Repositories(url).getRepositoryDetailsListJson(null).getInputStream());
            ArtifactoryModel.RepositoryType[] repos = (ArtifactoryModel.RepositoryType[])gson.fromJson((Reader)stream, ArtifactoryModel.RepositoryType[].class);
            ArrayList<RemoteRepositoryDescription> result = new ArrayList<RemoteRepositoryDescription>(repos.length);
            for (ArtifactoryModel.RepositoryType repo : repos) {
                result.add(ArtifactoryRepositoryService.convert(repo));
            }
            arrayList = result;
        }
        catch (JsonSyntaxException e) {
            List<RemoteRepositoryDescription> list = Collections.emptyList();
            if (list == null) {
                ArtifactoryRepositoryService.$$$reportNull$$$0(3);
            }
            return list;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static RemoteRepositoryDescription convert(ArtifactoryModel.RepositoryType repo) {
        return new RemoteRepositoryDescription(repo.key, (String)ObjectUtils.notNull((Object)repo.description, (Object)repo.key), repo.url);
    }

    @Override
    @NotNull
    public List<RepositoryArtifactDescription> findArtifacts(@NotNull String url, @NotNull RepositoryArtifactDescription template) throws IOException {
        ArrayList<RepositoryArtifactDescription> arrayList;
        if (url == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(4);
        }
        if (template == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(5);
        }
        try {
            String packaging = StringUtil.notNullize((String)template.getPackaging());
            ArrayList<RepositoryArtifactDescription> artifacts = new ArrayList<RepositoryArtifactDescription>();
            Gson gson = new Gson();
            String className = template.getClassNames();
            if (className == null || className.length() == 0) {
                ArtifactoryModel.GavcResults results;
                String name2 = StringUtil.join(Arrays.asList(template.getGroupId(), template.getArtifactId(), template.getVersion()), (String)":");
                InputStream stream = new Endpoint.Search.Artifact(url).getArtifactSearchResultJson(name2, null).getInputStream();
                ArtifactoryModel.GavcResults gavcResults = results = stream == null ? null : (ArtifactoryModel.GavcResults)gson.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.GavcResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.GavcResult result : results.results) {
                        if (!result.uri.endsWith(packaging)) continue;
                        artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(result.uri, url, null));
                    }
                }
            } else {
                ArtifactoryModel.ArchiveResults results;
                String searchString = className.endsWith("*") || className.endsWith("?") ? className : className + ".class";
                InputStream stream = new Endpoint.Search.Archive(url).getArchiveSearchResultJson(searchString, null).getInputStream();
                ArtifactoryModel.ArchiveResults archiveResults = results = stream == null ? null : (ArtifactoryModel.ArchiveResults)gson.fromJson((Reader)new InputStreamReader(stream), ArtifactoryModel.ArchiveResults.class);
                if (results != null && results.results != null) {
                    for (ArtifactoryModel.ArchiveResult result : results.results) {
                        for (String uri : result.archiveUris) {
                            if (!uri.endsWith(packaging)) continue;
                            artifacts.add(ArtifactoryRepositoryService.convertArtifactInfo(uri, url, result.entry));
                        }
                    }
                }
            }
            arrayList = artifacts;
        }
        catch (JsonSyntaxException e) {
            List<RepositoryArtifactDescription> list = Collections.emptyList();
            if (list == null) {
                ArtifactoryRepositoryService.$$$reportNull$$$0(7);
            }
            return list;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (arrayList == null) {
            ArtifactoryRepositoryService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static RepositoryArtifactDescription convertArtifactInfo(String uri, String baseUri, String className) throws IOException {
        int repoIndex;
        String repoPathFile = uri.substring((baseUri + "storage/").length());
        String repoString = repoPathFile.substring(0, repoIndex = repoPathFile.indexOf(47));
        String repo = repoString.endsWith("-cache") ? repoString.substring(0, repoString.lastIndexOf(45)) : repoString;
        String filePath = repoPathFile.substring(repoIndex + 1, repoPathFile.lastIndexOf(47));
        int artIdIndex = filePath.lastIndexOf(47);
        String version = filePath.substring(artIdIndex + 1);
        String groupArtifact = filePath.substring(0, artIdIndex);
        int groupIndex = groupArtifact.lastIndexOf(47);
        String artifact = groupArtifact.substring(groupIndex + 1);
        String group = groupArtifact.substring(0, groupIndex).replace('/', '.');
        String packaging = uri.substring(uri.lastIndexOf(46) + 1);
        return new RepositoryArtifactDescription(group, artifact, version, packaging, null, className, repo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/services/artifactory/ArtifactoryRepositoryService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRepositories";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

